@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                     <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                     <li class="breadcrumb-item">Inventory</li>
                     <li class="breadcrumb-item active">Review</li>
                  </ol>
               </div>
               <h4 class="page-title">Review</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->
      <div class="row">
         <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
               <div class="card-body">

               <div class="row mb-2">
               <div class="col-lg-12">
                  <div class="text-lg-end pull-right">
                        <a href="{{ route('review.create') }}" class="btn btn-sm btn-primary waves-effect waves-light mb-2 me-2"><i class="mdi mdi-basket me-1"></i> Add New</a>
                  </div>
               </div>
               <!-- end col-->
            </div>


                  <fieldset class="scheduler-border">
                     <legend align="left" class="scheduler-border">Review</legend>
                            <div class="table-responsive">
                                <table class="table table-centered table-striped dt-responsive nowrap w-100 table-sm" id="products-datatable">
                                    <thead class="text-left thead-info">
                                        <th>S.No.</th>
                                        <th>Heading</th>
                                        <th>Product</th>
                                        <th>Star</th>
                                        <th>Created at</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @foreach($response as $key=>$rows)
                                        <form action="{{ route('review.destroy',$rows->id) }}" method="POST">
                                            @csrf @method('DELETE')
                                            <tr>
                                                <td>{{ $key+1 }}</td>
                                                <td>{{ $rows->heading }}</td>
                                                <td>{{ App\Models\Product::whereId($rows->product_id)->value('name') }}</td>
                                                <td>{{ $rows->star }}</td>
                                                <td>{{ $rows->created_at }}</td>
                                                <td>
                                                    <button type="submit" class="btn-sm btn btn-danger btn-rounded waves-effect waves-light" title="Delete" onclick="return confirm('Do You want to Delete?')"><i class="fa fa-trash"></i></button>

                                                </td>
                                            </tr>
                                        </form>
                                        @endforeach
                                    </tbody>
                                </table>
                                <hr />
                                {!! $response->links() !!}
                            </div>

                  </fieldset>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
@endsection