@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                     <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                     <li class="breadcrumb-item">Settings</li>
                     <li class="breadcrumb-item active">Servicable</li>
                  </ol>
               </div>
               <h4 class="page-title">Servicable</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->

  <div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12">
      <div class="card">
        <div class="card-body">
          <div class="row">
    <div class="col-sm-9">
        <form method="get" action="{{ route('servicable.index') }}">
           <div class="row">             
                <div class="col-sm-5">
                    <div class="form-group">
<select name="courier" class="form-control form-control-sm" onchange="window.location='{{ route('servicable.index') }}?courier='+this.value">
                                                <option value="">COURIER *</option>
                                                <option value="BLUEDART">BLUEDART</option>
                                                <option value="DELHIVERY">DELHIVERY</option>
                                                <option value="ECOMEXPRESS">ECOMEXPRESS</option>
                                                <option value="EKART">EKART</option>
                                                <option value="SHADOWFAX">SHADOWFAX</option>
                                                <option value="XPRESSBEES">XPRESSBEES</option>
                                            </select>                    
                                        </div> 
                </div>   
                <div class="col-sm-5">
                    <div class="form-group">
                    <input type="text" class="form-control form-control-sm" name="q" id="q" placeholder="Search Pincode" />
                    </div>
                </div>    
               <div class="col-sm-2">
                                    <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-sm">Search</button>
                </div>
                </div>    
          </div>  
        </form>
    </div>       
    <div class="col-sm-3">
        <div class="text-sm-right">
            <button type="button" title="Import Pincode"  data-toggle="modal" data-target="#uploadModal" class="btn btn-info btn-sm"><i class="fa fa-upload"></i> {{ __('Import') }}</button>

            <a href="{{ route('servicable.export',['courier'=>Request::get('courier'),'export'=>true]) }}" title="Download" class="btn-sm btn btn-success"><i class="fa fa-download"></i> Export</a>
        </div>
    </div>
    <!-- end col-->
</div>
          <fieldset class="scheduler-border">
            <legend align="left" class="scheduler-border">
              ({{ $response->total() }})- {{ __('TOTAL') }}
            </legend>

            <div class="table-responsive">
              <table class="table table-bordered table-sm">
                <thead class="text-left thead-primary">
                  <th>{{ __('S.No.') }}</th>
                  <th>{{ __('PINCODE') }}</th>
                  <th>{{ __('COURIER') }}</th>
                  <th>{{ __('ACTIVE') }}</th>
                  <th>{{ __('LAST_UPDATED_AT') }}</th>
                </thead>
                <tbody>
                  @foreach($response as $key=>$rows)
                  <form action="" id="logout-form{{ $key+1 }}" method="post">
                    @csrf
                    <tr>
                      <td>{{ $key+1 }}</td>
                      <td>{{ $rows->pincode}}</td>
                      <td>{{ $rows->courier }}</td>
                      <td> @if($rows->is_active==1)
                          <a href="{{ route('servicable.active.status',$rows->id).'?action=0' }}" onclick="return confirm('Do You Want to Blocked - {{ $rows->pincode}}?')" class="badge badge-primary">{{ __('Active') }}</a>
                         @else
                          <a href="{{ route('servicable.active.status',$rows->id).'?action=1' }}" onclick="return confirm('Do You Want to Active - {{ $rows->pincode}}?')" class="badge badge-danger text-white"><s>{{ __('Blocked') }}</s></a>
                         @endif
                      </td>
                        <td>{{ $rows->updated_at }}</td>
                    </tr>
                  </form>
                  @endforeach
                </tbody>
              </table>
            </div>
          </fieldset>
        </div>
      </div>
    </div>
  </div>
            <!-- end row-->
        </div>
        <!-- container -->
    </div>
    <!-- content -->
  <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="basicModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card-content">
              <fieldset class="scheduler-border">
                <legend align="left" class="scheduler-border">
                  <b style="font-size: 16px;">Upload Order</b> <a href="{{ url('public/format/SERVICABLE-FORMAT.csv') }}" title="Download Format" download="" style="font-size: 11px;"> <i class="fa fa-download"></i> format</a>
                </legend>
                <form method="post" action="{{ route('servicable.store') }}" enctype="multipart/form-data"  class="needs-validation" novalidate>
                  @csrf
                  <div class="row">
                    <div class="col-md-12">
                               <div class="form-group">
                      <select name="courier" required="true" class="form-control">
                                                <option value="">COURIER *</option>
                                                <option value="BLUEDART" @if(Request::get('courier')=='BLUEDART')  selected="selected" @endif>BLUEDART</option>
                                                <option value="DELHIVERY" @if(Request::get('courier')=='DELHIVERY')  selected="selected" @endif>DELHIVERY</option>
                                                <option value="ECOMEXPRESS" @if(Request::get('courier')=='ECOMEXPRESS')  selected="selected" @endif>ECOMEXPRESS</option>
                                                <option value="EKART" @if(Request::get('courier')=='EKART')  selected="selected" @endif>EKART</option>
                                                <option value="SHADOWFAX" @if(Request::get('courier')=='SHADOWFAX')  selected="selected" @endif>SHADOWFAX</option>
                                                <option value="XPRESSBEES" @if(Request::get('courier')=='XPRESSBEES')  selected="selected" @endif>XPRESSBEES</option>
                                            </select>                    
                                        </div> 
                      <div class="form-group">
                        <input type="file" name="uploadfile" class="form-control" required/>
                      </div>
                      <div class="form-group">
                        <select name="is_active" class="form-control" required>
                          <option value="">:--Status--:</option>
                          <option value="1">Active</option>
                          <option value="0">Blocked</option>
                        </select>   
                      </div>                      
                      <button type="submit" style="font-size: 18px;" class="btn btn-info shadow-primary btn-block" name="submit" value="Upload"><i class="fa fa-upload"></i> Upload Pincode</button>
                    </div>
                  </div>
                </form>
              </fieldset>
            </div>
          </div>
          <button type="button" class="close" style="margin-left: -35px;margin-top: -30px; font-weight: bold;" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
          </button>
        </div>
      </div>
    </div>
  </div>
   <!-- end container-fluid -->
 </div>
</div>
@endsection