<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>Dashboard | <?php echo e(config('app.name')); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="Admin <?php echo e(config('app.name')); ?>" name="description" />
        <meta content="<?php echo e(config('app.name')); ?>" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset('images/favicon.png')); ?>">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <!-- App css -->
        <link href="<?php echo e(asset('master/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" id="bootstrap-stylesheet" />
        <link href="<?php echo e(asset('master/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('master/css/app.min.css')); ?>" rel="stylesheet" type="text/css"  id="app-stylesheet" />

        <style type="text/css">
            fieldset.scheduler-border {
              border: 1px groove #ddd !important;
              padding: 0 1.4em 1.4em 1.4em !important;
              margin: 0 0 1.5em 0 !important;
              -webkit-box-shadow:  0px 0px 0px 0px #000;
              box-shadow:  0px 0px 0px 0px #000;
            }
            legend.scheduler-border {
              font-size: 1.2em !important;
              font-weight: bold !important;
              text-align: left !important;
              width:auto;
              padding:0 10px;
              border-bottom:none;
            }
            #loading-wrapper
              {
              position: fixed;
              top: 0;
              left: 0;
              width: 100%;
              height: 100%;
              z-index: 5000;
              background: #01070fad;
              }
            .modal-danger .modal-content, .modal-danger .modal-header
            {
              background: #f75851;
              border: 0;
            }
            #loading-wrapper #loader
            {
              position: absolute;
              top: 30%;
              left: 50%;
              margin-left: -30px;
              margin-top: -30px;
              width: 60px;
              height: 60px
            }
            #loading-wrapper #loader:before
            {
              content: '';
              box-sizing: border-box;
              position: absolute;
              top: 50%;
              left: 50%;
              width: 48px;
              height: 48px;
              margin-left: -24px;
              -webkit-border-radius: 50%;
              -moz-border-radius: 50%;
              border-radius: 50%;
              border: 2px solid #d0d6e9;
              border-top-color: #118cf1;
              -moz-animation: spinner .6s linear infinite;
              -webkit-animation: spinner .6s linear infinite;
              animation: spinner .6s linear infinite
            }
    
            @-moz-keyframes spinner {
            from
            {
            transform:rotate(0);
            }
            to{
            transform:rotate(360deg);
            }}
            @-webkit-keyframes spinner {
            from {
            transform:rotate(0)
            }to{
            transform:rotate(360deg)
            }}
            @keyframes                                                                spinner {
            from{
            transform:rotate(0)
            }to{
    
            transform:rotate(360deg)
    
            }
      </style>


    </head>

    <body>

        <!-- Navigation Bar-->

        <?php echo $__env->make('theme.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- End Navigation Bar-->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <div id="loading-wrapper" class="ajax-loader">
            <div id="loader"></div>
        </div>

        <?php echo $__env->yieldContent('content'); ?>

        <!-- end wrapper -->

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->



        <!-- Footer Start -->
        <?php echo $__env->make('theme.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- end Footer -->


        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>


        <!-- Vendor js -->
        <script src="<?php echo e(asset('master/js/vendor.min.js')); ?>"></script>

        <!--Morris Chart-->
        <script src="<?php echo e(asset('master/libs/morris-js/morris.min.js')); ?>"></script>
        <script src="<?php echo e(asset('master/libs/raphael/raphael.min.js')); ?>"></script>

        <!-- Dashboard init js-->
        <script src="<?php echo e(asset('master/js/pages/dashboard.init.js')); ?>"></script>

        <!-- Plugin js-->
        <script src="<?php echo e(asset('master/libs/parsleyjs/parsley.min.js')); ?>"></script>

        <!-- Validation init js-->
        <script src="<?php echo e(asset('master/js/pages/form-validation.init.js')); ?>"></script>

        <!-- App js -->
        <script src="<?php echo e(asset('master/js/app.min.js')); ?>"></script>
        <?php echo $__env->make('layouts.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    </body>
</html>
<script>
    $(function() {
        var start = moment().subtract(29, 'days');
        var end = moment();
        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
               'Today': [moment(), moment()],
               'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
               'Last 7 Days': [moment().subtract(6, 'days'), moment()],
               'Last 30 Days': [moment().subtract(29, 'days'), moment()],
               'This Month': [moment().startOf('month'), moment().endOf('month')],
               'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);
      cb(start, end);
    });
    document.onreadystatechange = function()
    {
        if(document.readyState=='loaded' || document.readyState=='complete')
            document.getElementById('loading-wrapper').style.display='none';
    }
</script><?php /**PATH C:\xampp\php8.2\htdocs\advance\cmsweb\resources\views/theme/layouts/app.blade.php ENDPATH**/ ?>