<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Models\Backup;
use App\Models\Integration;
use App\Models\Apiresponse;
use App\Models\Product;
use App\Models\Product_detail;
use App\Models\Product_image;
use App\Models\Product_json;
use App\Models\Shopify_product;
use App\Models\Shopify_product_variant;
use App\Models\Shopify_product_image;
use App\Models\Shopify_product_variant_image;
use Exception;
use Curl;

class IntegrationController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        // $price = $request->price;
        // $per = rand(30,60);
        // $mrp = floor($price+($price/100)*$per);
        // die("Formula : $price + ($price/100)*$per = $mrp");
        // echo "<pre>";
         $arr_data = Http::get('https://f41968996a842be8621cf96803a4a38a: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@allhitbazaar.myshopify.com/admin/api/2021-01/products.json?limit=250&status=active&created_at_min=2018-01-01T00:15:47-04:00&created_max_min=2019-01-01T00:00:00-04:00')->json();
        // dd($arr_data);
        // $arr_data = json_decode(Product_json::value('fetch_json_data'),true);
        foreach ($arr_data['products'] as $key => $rows) 
        {
          if(Product::where('productId',$rows['id'])->count()==0)  
          {  
            $product_data = Product::insert(['user_id'=>Auth::id(),'productId'=>$rows['id'],'name'=>$rows['title'],'slug'=>$rows['handle'],'selling_price'=>0.0,'actual_price'=>0.0,'cod_amount'=>0.0,'prepaid_amount'=>0.0,'shipping_amount'=>50.0,'in_stock'=>10000,'is_cod'=>1,'is_prepaid'=>1,'in_shopify'=>1,'sort_by'=>1,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);         
             $product_id = DB::getPdo()->lastInsertId();
             foreach($rows['variants'] as $key=>$vrows)
             {  
             $per = rand(30,60);
             $price = $vrows['price'];
             $mrp = round($price+($price/100)*$per);
               Product_detail::insert(['product_id'=>$product_id,'product_type'=>$rows['product_type'],'sku'=>$vrows['sku'],'image'=>$rows['image']['src'],'description'=>$rows['body_html'],'meta_title'=>$rows['title'],'meta_keywords'=>$rows['title'],'meta_description'=>$rows['body_html'],'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);
               Product::whereId($product_id)->update(['selling_price'=>$price,'actual_price'=>$mrp,'cod_amount'=>$price,'prepaid_amount'=>$price]);
             }   
             foreach($rows['images'] as $key=>$variant_img_rows)
             {   
                Product_image::insert(['product_id'=>$product_id,'mainimage'=>$variant_img_rows['src'],'thumbimage'=>$variant_img_rows['src'],'created_at'=>date('Y-m-d H:i:s')]);
             }   
          }    

        }
        die();
        echo '<pre>';
       $result = Http::get('https://63637667021d58c084a45024204fae52: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@soophiya.myshopify.com/admin/api/2021-01/'.$request->path)->json();
           print_r($result); 

           die();
        foreach(Backup::where('shipping_amount',0)->take(100)->get(['order_id']) as $pro)
        {
       $result = Http::get('https://63637667021d58c084a45024204fae52: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@soophiya.myshopify.com/admin/api/2021-01/orders/'.$pro->order_id.'.json')->json();
         //   print_r($result); 
            Backup::where('order_id',$pro->order_id)->update(['subtotal_price'=>$result['order']['subtotal_price'],'total_tax'=>$result['order']['total_tax'],'shipping_amount'=>$result['order']['shipping_lines'][0]['price']]);
 //           die();
        }    
die();

/*        $result = Http::get('https://63637667021d58c084a45024204fae52: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@soophiya.myshopify.com/admin/api/2021-01/webhooks.json')->json();

            print_r($result); die();

*/

        $result = Integration::whereUser_id(Auth::id())
                              ->latest()
                              ->paginate(16);
        return view('theme.integration.index')->with(['response'=>$result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Settings / Add Integration']; 
        return view('theme.integration.add',['breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->submit=='Save' && $request->isMethod('post') && $request->has('submit'))
        {

            $request->validate(['api_type'=>'required',
                                'account_name'=>'required|unique:integrations',
                                'api_key'=>'required|unique:integrations',
                                'account_password'=>'required|unique:integrations',
                                'account_url'=>'required|unique:integrations']);
            $token = Str::uuid().Auth::user()->id.'-'.strtotime('Now');
            $client_api_url_explode = explode('/admin/',$request->account_url); 
            if($request->api_type=='ORDER')
            {
             $client_api_url = $client_api_url_explode[0].'/admin/webhooks.json';
            }
            $store_intgs_objs = new Integration();
            $store_intgs_objs->user_id          = Auth::user()->id;
            $store_intgs_objs->api_type         = $request->api_type;
            $store_intgs_objs->store            = 'SHOPIFY';
            $store_intgs_objs->account_name     = $request->account_name;
            $store_intgs_objs->api_key          = $request->api_key;
            $store_intgs_objs->api_name         = $request->account_name;
            $store_intgs_objs->emergency_developer_email = $request->emergency_developer_email;
            $store_intgs_objs->token            = $token;
            $store_intgs_objs->secret           = $request->secret;
            $store_intgs_objs->account_password = $request->account_password;
            $store_intgs_objs->account_url      = $request->account_url;
            $store_intgs_objs->is_active        = $request->is_active;
            $store_intgs_objs->save();

             $client_api_url_explode = explode('/admin/',$request->account_url); 
             $webhooks_url = url('/api/webhooks/order-response/'.$token.'/'.Auth::id());   
             $client_api_url = $client_api_url_explode[0].'/admin/webhooks.json';
             $get_response = Http::post($client_api_url,array( 'webhook' => array('topic'=>'orders/create','address'=>$webhooks_url,'format'=>'json') ) )->json();
            $response = (object) $get_response;
            $api_response_object = new Apiresponse();
            $api_response_object->user_id        = Auth::id();
            $api_response_object->integration_id = $store_intgs_objs->id;
            $api_response_object->webhook_id     = $response->webhook['id'];
            $api_response_object->address        = $response->webhook['address'];
            $api_response_object->format         = $response->webhook['format'];
            $api_response_object->api_version    = $response->webhook['api_version'];
            $api_response_object->is_active      = 1;
            $api_response_object->created_at     = date('Y-m-d H:i:s',strtotime($response->webhook['created_at']));
            $api_response_object->updated_at     = date('Y-m-d H:i:s',strtotime($response->webhook['updated_at']));
            $api_response_object->save();
//            Integration::whereId($store_intgs_objs->id)->update(['is_webhook'=>1]);
            return redirect()->route('integration.index')->with('message','Integration Created Successful.');
        }else{
            return redirect()->route('integration.index')->with('error','Invalid Arguments!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        if($request->has('action') && $request->action==0)
        {
           Integration::where('id',$id)->update(['is_active'=>0]);
           return redirect()->route('integration.index')->with('error','API Inactivated Successful.');
        } if($request->has('action') && $request->action==1){
           Integration::where('id',$id)->update(['is_active'=>1]);
           return redirect()->route('integration.index')->with('success','API Activated Successful.');
        }
        $response = Integration::findOrFail($id);
        return view('integration.edit',['rows'=>$response]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->submit=='Save' && $request->isMethod('put') && $request->has('submit'))
        {
            $request->validate(['api_type'=>'required',
                                'account_name'=>'required',
                                'api_key'=>'required',
                                'account_password'=>'required',
                                'account_url'=>'required']);
            $token = Str::uuid().Auth::user()->id;
            $client_api_url_explode = explode('/admin/',$request->account_url); 
            if($request->api_type=='Order')
            {
        //    $webhooks_url = 'https://codverify.com/shopify-hooks/shopify-orders-create?token='.$token;   
             $webhooks_url = url('order-hooks/shopify-orders-create?token='.$token);   
             $client_api_url = $client_api_url_explode[0].'/admin/webhooks.json';
            }elseif($request->api_type=='Product')
            {
            // $webhooks_url = 'https://codverify.com/hooks/shopify-orders-create?token='.$token;   
            }else{
            // $webhooks_url = 'https://codverify.com/hooks/shopify-orders-create?token='.$token;   
            }


            // $store_intgs_objs = new Integration();
            // $store_intgs_objs->user_id          = Auth::user()->id;
            // $store_intgs_objs->api_type         = $request->api_type;
            // $store_intgs_objs->store            = 'SHOPIFY';
            // $store_intgs_objs->account_name     = $request->account_name;
            // $store_intgs_objs->api_key          = $request->api_key;
            // $store_intgs_objs->api_name         = 'Order';
            // $store_intgs_objs->token            = $token;
            // $store_intgs_objs->account_password = $request->account_password;
            // $store_intgs_objs->account_url      = $request->account_url;
            // $store_intgs_objs->save();

                    $response = Curl::to($client_api_url)
                    ->withData( array( 'webhook' => array('topic'=>'orders/create','address'=>$webhooks_url,'format'=>'json' )) )
                    ->asJson()
                    ->post();
                    $response->webhook->id;
                    $api_response_object = new Apiresponse();
                    $api_response_object->user_id        = Auth::user()->id;
                    $api_response_object->integration_id = $id;
                    $api_response_object->webhook_id     = $response->webhook->id;
                    $api_response_object->address        = $response->webhook->address;
                    $api_response_object->format         = $response->webhook->format;
                    $api_response_object->api_version    = $response->webhook->api_version;
                    $api_response_object->created_at     = date('Y-m-d H:i:s',strtotime($response->webhook->created_at));
                    $api_response_object->updated_at     = date('Y-m-d H:i:s',strtotime($response->webhook->updated_at));
                    $api_response_object->save();
                return redirect()->route('integration.index')->with('message','API Saved Successful.');
        }else{
                return redirect()->route('integration.index')->with('error','Invalid Arguments!');
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Integration::where('id',$id)->update(['is_delete'=>1]);
        return redirect()->route('integration.index')->with('error','API Deleted Successful.');
    }
}
