<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Helper;
use App\Imports\InvoiceImport;
use App\Models\Invoice;

class InvoiceController extends Controller
{

    public function __construct(){
        $this->middleware('auth');
    } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
         $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Invoice','javascript:void(0)'=>'Invoice / Bulk']; 
         $inv_count = Invoice::when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('invoice_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('invoice_date', '>=', $arr[0])->whereDate('invoice_date', '<=', $arr[1]);
                            })->count();    

         $all_result = Invoice::select('invoice_date', DB::raw('count(id) as total'))
                            ->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('invoice_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('invoice_date', '>=', $arr[0])->whereDate('invoice_date', '<=', $arr[1]);
                            })->groupBy('invoice_date')->orderBy('invoice_date','Asc')->paginate(32);
        return view('theme.invoice.bulk',['response'=>$all_result,'inv_count'=>$inv_count,'breadcrumbs'=>$breadcrumbs]);
    }
    
    /**
     * Upload bulk of the resource.
     *
     * @return \Illuminate\Http\Response
     */
	public function import(Request $request){

        if ($request->has('submit') && $request->isMethod('post')) {
            $filename = $_FILES["uploadfile"]["tmp_name"];
            if ($_FILES["uploadfile"]["size"] > 0) {
                $file = fopen($filename, "r");
                $i = 0;
                while (($data = fgetcsv($file, 100000, ",")) !== false) {
                    if ($i > 0) 
                    {
                        $rows = Invoice::where('order_id', trim($data[4]))->where('invoice_number', trim($data[6]))->first();
                        if (is_null($rows)) 
                        {
                        $inv_data = ['user_id'=>Auth::id(),
                                     'sold_by'=>$data[0],
                                     'sold_by_address'=>$data[1],
                                     'gst'=>trim($data[2]),
                                     'pan'=>trim($data[3]),
                                     'order_id'=>trim($data[4]),
                                     'order_date'=>date('Y-m-d',strtotime($data[5])),
                                     'invoice_number'=>trim($data[6]),
                                     'invoice_details'=>$data[7],
                                     'invoice_date'=>date('Y-m-d',strtotime($data[8])),
                                     'billing_customer'=>$data[9],
                                     'billing_address'=>$data[10],
                                     'billing_city'=>$data[11],
                                     'billing_state'=>$data[12],
                                     'billing_pincode'=>$data[13],
                                     'state_code'=>$data[14],
                                     'product'=>$data[15],
                                     'hsn'=>trim($data[16]),
                                     'quantity'=>trim($data[17]),
                                     'price'=>trim(str_replace(',','',$data[18])),
                                     'tax_rate'=>trim(str_replace(',','',$data[19])),
                                     'cgst'=>trim(str_replace(',','',$data[20])),
                                     'sgst'=>trim(str_replace(',','',$data[21])),
                                     'igst'=>trim(str_replace(',','',$data[22])),
                                     'tax_amount'=>trim(str_replace(',','',$data[23])),
                                     'total_amount'=>trim(str_replace(',','',$data[24])),
                                     'single_price'=>trim(str_replace(',','',$data[25])),
                                     'created_at'=>date('Y-m-d H:i:s')
                                    ];
                        Invoice::create($inv_data);
                        }
                    }
                    $i++;
                }
            } else {
                return redirect()
                    ->route('upload.invoice')
                    ->with('error', 'Invalid File!.');
            }
        }
        return redirect()
            ->route('upload.invoice')
            ->with('message', 'Invoice Uploaded  Successful.');
	}    



    //---------------------------------------------Download Label ----------
    public function download_bulk_invoice(Request $request)
    {
        if($request->segment(5))
        {
             $download_path = url("/admin/print-invoice/download/".$request->segment(4).'/'.$request->segment(5).'/action/bulk');
        $filename = $request->segment(6).'-'.$request->segment(4)."-invoice.pdf";

        }else{
             $download_path = url("/admin/print-invoice/export/".$request->segment(4));
        $filename = $request->count.'-'.$request->segment(4)."-invoice.pdf";

        }     //echo $download_path; die();
        $labels = shell_exec("xvfb-run wkhtmltopdf --disable-smart-shrinking -L 0 -R 0 --page-width 3in --page-height 6in -B 15mm ".$download_path." ".storage_path("invoice/".$filename));
        if($labels)
        {
           return response()->download(storage_path("invoice/".$filename))->deleteFileAfterSend(true);    
        }   

    }


}
