<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Helper;
use App\Models\Backup;

class OrderController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function fetch_all_shopify_orders()
    {
         $all_result = Backup::join('shopify_products','backups.productId','=','shopify_products.productId')
                             ->join('shopify_product_images','shopify_products.id','=','shopify_product_images.product_id')
                             ->when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*','shopify_product_images.src')->paginate(10);   
        return view('theme.orders.fetch_all_orders',['all_result'=>$all_result]);
    }

//------------------------------ fetch_single_shopify_orders 

    public function fetch_single_shopify_orders(Request $request)
    {    
         $id = decrypt($request->segment(3));   
         $single_result = Backup::join('products','backups.product','=','products.name')
                                ->join('product_details','products.id','=','product_details.product_id')
                                ->when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->where('backups.id',$id)->select('backups.*','product_details.image')->first(); 
        if($single_result!=null)
        {
            $breadcrumbs = ['home'=>'Dashboard','fetch-all-orders'=>'Orders','javascript:void(0)'=>$single_result->order_no];  
            return view('theme.orders.fetch_single_orders',['rows'=>$single_result,'breadcrumbs'=>$breadcrumbs]);
        }else{
        return back()->with("error","Sorry we Can't Fetch Your Order Details.");            
        }                    
    }


}
