<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Models\Backup;
use App\Models\Collection;
use App\Models\Apiresponse;
use App\Models\Product;
use App\Models\Product_detail;
use App\Models\Product_image;
use App\Models\Product_json;
use App\Models\Shopify_product;
use App\Models\Shopify_product_variant;
use App\Models\Shopify_product_image;
use App\Models\Shopify_product_variant_image;
use Exception;
use Curl;

class ProductController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {

        
        $all_result = Product::join('product_details','products.id','=','product_details.product_id')
        ->select('products.*','product_details.image')->orderBy('products.created_at','Desc')->paginate(100);   
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Inventory / Product']; 
        return view('theme.inventory.product.index',['response'=>$all_result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Inventory / Add Product']; 
        return view('theme.inventory.product.add',['breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->submit=='Save' && $request->isMethod('post') && $request->has('submit'))
        {

            $request->validate(['name'=>'required']);




            $fillable_collection_data = ['productId' =>rand(1211111111111,9999999999999),
                                         'user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                         'slug' =>Str::slug($request->name,'-').'-'.strtotime("Now"),
                                         'whatsapp' =>$request->whatsapp,
                                         'btnName' =>$request->btnName,
                                         'is_whatsapp'=>$request->is_whatsapp,
                                         'is_active'=>$request->is_active,
                                         'created_at'=>date('Y-m-d H:i:s')];
            Product::insert($fillable_collection_data);                             
            $product_id = DB::getPdo()->lastInsertId();
            $fillable_collection_data_2 = [
            'product_id' =>$product_id,
            'image' =>'',
            'product_type' =>$request->collection,
            'description' =>$request->description,
            'meta_title' =>$request->meta_title,
            'meta_keywords' =>$request->meta_keywords,
            'meta_description' =>$request->meta_description,
            'is_active'=>$request->is_active,
            'created_at'=>date('Y-m-d H:i:s')];
            Product_detail::insert($fillable_collection_data_2);                                             

               if ($request->hasFile('image')) 
                {
                    foreach ($request->file('image') as $key => $imagefile) 
                    {
                        $image      = $imagefile; 
                        $image_name = Str::slug($request->name,'-').'-'.rand(11111,9999).'.'.$image->getClientOriginalExtension();
                        $destinationPath = public_path('/storage/productimages/mainimage');
                        $image->move($destinationPath, $image_name);
                        $src = url('/public/storage/productimages/mainimage/'.$image_name);
                       
                        if($request->is_main==$key){

                            $is_main = 1;
                            Product_detail::where('product_id',$product_id)->update(['image'=>$src]);                            
                        }else{
                            $is_main = 0;
                        }
                        $arrayData = array('product_id'=>$product_id,'mainimage'=>$src,'thumbimage'=>$src,'is_main'=>$is_main,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s'));  
                            Product_image::insert($arrayData);       
                    }    
                } 

            return redirect()->route('product.index')->with('message','Product Created Successful.');
        }else{
            return redirect()->route('product.index')->with('error','Invalid Arguments!');
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        if($request->has('action') && $request->action==0)
        {
           Product::where('id',$id)->update(['is_active'=>0]);
           return redirect()->route('product.index')->with('error','Product Inactivated Successful.');
        } if($request->has('action') && $request->action==1){
           Product::where('id',$id)->update(['is_active'=>1]);
           return redirect()->route('product.index')->with('success','Product Activated Successful.');
        }
        $response = Product::join('product_details','products.id','=','product_details.product_id')
        ->select('products.*','product_details.product_type','product_details.sku','product_details.description','product_details.meta_title','product_details.meta_keywords','product_details.meta_description')->where('products.id',$id)->first();
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Inventory / Edit Product']; 
        return view('theme.inventory.product.edit',['breadcrumbs'=>$breadcrumbs,'rows'=>$response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        if($request->submit=='Save' && $request->isMethod('put') && $request->has('submit'))
        {

            $request->validate(['name'=>'required']);

            if(empty($request->is_cod)){
                $is_cod = 0;
            }else{
                $is_cod = $request->is_cod;
            }

            if(empty($request->is_prepaid)){
                $is_prepaid = 0;
            }else{
                $is_prepaid = $request->is_prepaid;
            }

            if(empty($request->is_partial)){
                $is_partial = 0;
            }else{
                $is_partial = $request->is_partial;
            }
            $fillable_collection_data = ['user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                        // 'slug' =>Str::slug($request->name,'-'),
                                         'whatsapp' =>$request->whatsapp,
                                         'btnName' =>$request->btnName,
                                         'is_whatsapp'=>$request->is_whatsapp,
                                         'is_cod' =>$is_cod,
                                         'is_prepaid' =>$is_prepaid,
                                         'is_partial' =>$is_partial,
                                         'is_active'=>$request->is_active,
                                         'updated_at'=>date('Y-m-d H:i:s')];
            Product::where('id',$id)->update($fillable_collection_data);                             
            $fillable_collection_data_2 = [
            'product_id' =>$id,
            'product_type' =>$request->collection,
            'description' =>$request->description,
            'meta_title' =>$request->meta_title,
            'meta_keywords' =>$request->meta_keywords,
            'meta_description' =>$request->meta_description,
            'is_active'=>$request->is_active,
            'updated_at'=>date('Y-m-d H:i:s')];
            Product_detail::where('product_id',$id)->update($fillable_collection_data_2);                                             

                if ($request->hasFile('image')) 
                {
                    foreach ($request->file('image') as $key => $imagefile) 
                    {
                        $image      = $imagefile; 
                        $image_name = Str::slug($request->name,'-').'-'.rand(11111,9999).'.'.$image->getClientOriginalExtension();
                        $destinationPath = public_path('/storage/productimages/mainimage');
                        $image->move($destinationPath, $image_name);
                        $src = url('/public/storage/productimages/mainimage/'.$image_name);
                        $arrayData = array('product_id'=>$id,'mainimage'=>$src,'thumbimage'=>$src,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s'));  

                        if($key==0){
                            Product_detail::where('product_id',$id)->update(['image'=>$src]);                            
                        }
                            Product_image::insert($arrayData);       
                    }    
                } 
            return redirect()->route('product.index')->with('message','Updated Successful.');
        }else{
            return redirect()->route('product.index')->with('error','Invalid Arguments!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Product_image::where('product_id',$id)->delete();
        Product_detail::where('product_id',$id)->delete();
        Product::where('id',$id)->delete();
        return redirect()->route('product.index')->with('error','Product Deleted Successful.');
    }

    public function ajax_update_images(Request $request)
    {
        Product_image::where('product_id',$request->product_id)->update(['is_main'=>0]);
        Product_image::where('id',$request->id)->update(['is_main'=>1]);
       
        Product_detail::where('product_id',$request->product_id)
                       ->update(['image'=>Product_image::where('product_id',$request->product_id)->where('id',$request->id)->value('mainimage')]);

        die('success');
    }

    public function ajax_remove_images(Request $request)
    {      //echo Product_image::where('id',$request->id)->where('product_id',$request->product_id)->where('is_main',1)->count();
           // die();  
        if(Product_image::where('id',$request->id)->where('product_id',$request->product_id)->where('is_main',1)->count()>0){
            die('false');
        }else{
           // Product_detail::where('product_id',$request->product_id)->update(['image'=>'']);
            Product_image::where('id',$request->id)->where('product_id',$request->product_id)->delete();
            die('success');
        }
    }


}
