<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Helper;
use App\Models\Backup;

class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function fetch_filter_orders(Request $request)
    {
        if($request->filter=='Backup')
        {
         $all_result = Backup::when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*')->get();   

        if($request->has('export'))                        
        {
         $fileExport = count($all_result).'-'.date("d-M-Y").'-'.$request->filter.".csv";
            $fields =
                '"VENDOR","ORDER_NO","PRODUCT","QUANTITY","PAYMENT_MODE","AMOUNT","ORDER_DATE","MOBILE","EMAIL","NAME","ADDRESS","CITY","STATE","PINCODE"'."\n";
            foreach ($all_result as $key => $export_rows)
            {
                $fields .='"'.$export_rows->vendor.
                            '","' .
                            $export_rows->order_no .
                            '","' .
                            $export_rows->product .
                            '","' .
                            $export_rows->quantity .
                            '","' .
                            $export_rows->payment_mode.
                            '","' .
                            $export_rows->amount .
                            '","' .
                            date($export_rows->order_date) .
                            '","' .
                            $export_rows->mobile .
                            '","' .
                            $export_rows->email .
                            '","' .
                            $export_rows->name .
                            '","' .
                            $export_rows->address .
                            '","' .
                            $export_rows->city .
                            '","' .
                            $export_rows->state .
                            '","' .
                            $export_rows->pincode .
                            '"';
                $fields .= "\n";
                //                        }
            }
            header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
            header('Content-type: text/x-csv');
            $fileName = $fileExport;
            header("Content-Disposition: attachment; filename=".$fileName);
            header("Content-Transfer-Encoding: binary");
            header("Connection: close");
            echo $fields;
            exit();
          } 



        }elseif($request->filter=='All'){
         $all_result = Backup::when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*')->get();               

        if($request->has('export'))                        
        {
         $fileExport = count($all_result).'-'.date("d-M-Y").'-'.$request->filter.".csv";
            $fields =
                '"VENDOR","ORDER_NO","PRODUCT","QUANTITY","PAYMENT_MODE","AMOUNT","ORDER_DATE","MOBILE","EMAIL","NAME","ADDRESS","CITY","STATE","PINCODE"'."\n";
            foreach ($all_result as $key => $export_rows)
            {
                $fields .='"'.$export_rows->vendor.
                            '","' .
                            $export_rows->order_no .
                            '","' .
                            $export_rows->product .
                            '","' .
                            $export_rows->quantity .
                            '","' .
                            $export_rows->payment_mode.
                            '","' .
                            $export_rows->amount .
                            '","' .
                            date($export_rows->order_date) .
                            '","' .
                            $export_rows->mobile .
                            '","' .
                            $export_rows->email .
                            '","' .
                            $export_rows->name .
                            '","' .
                            $export_rows->address .
                            '","' .
                            $export_rows->city .
                            '","' .
                            $export_rows->state .
                            '","' .
                            $export_rows->pincode .
                            '"';
                $fields .= "\n";
                //                        }
            }
            header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
            header('Content-type: text/x-csv');
            $fileName = $fileExport;
            header("Content-Disposition: attachment; filename=".$fileName);
            header("Content-Transfer-Encoding: binary");
            header("Connection: close");
            echo $fields;
            exit();
          } 

        }elseif($request->filter=='Fresh'){
         $all_result = Backup::when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*')->get();               

        if($request->has('export'))                        
        {
         $fileExport = count($all_result).'-'.date("d-M-Y").'-'.$request->filter.".csv";
            $fields =
                '"VENDOR","ORDER_NO","PRODUCT","QUANTITY","PAYMENT_MODE","AMOUNT","ORDER_DATE","MOBILE","EMAIL","NAME","ADDRESS","CITY","STATE","PINCODE"'."\n";
            foreach ($all_result as $key => $export_rows)
            {
                $fields .='"'.$export_rows->vendor.
                            '","' .
                            $export_rows->order_no .
                            '","' .
                            $export_rows->product .
                            '","' .
                            $export_rows->quantity .
                            '","' .
                            $export_rows->payment_mode.
                            '","' .
                            $export_rows->amount .
                            '","' .
                            date($export_rows->order_date) .
                            '","' .
                            $export_rows->mobile .
                            '","' .
                            $export_rows->email .
                            '","' .
                            $export_rows->name .
                            '","' .
                            $export_rows->address .
                            '","' .
                            $export_rows->city .
                            '","' .
                            $export_rows->state .
                            '","' .
                            $export_rows->pincode .
                            '"';
                $fields .= "\n";
                //                        }
            }
            header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
            header('Content-type: text/x-csv');
            $fileName = $fileExport;
            header("Content-Disposition: attachment; filename=".$fileName);
            header("Content-Transfer-Encoding: binary");
            header("Connection: close");
            echo $fields;
            exit();
          } 



        }elseif($request->filter=='Fresh'){
                 $all_result = Backup::when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*')->get();               

        if($request->has('export'))                        
        {
         $fileExport = count($all_result).'-'.date("d-M-Y").'-'.$request->filter.".csv";
            $fields =
                '"VENDOR","ORDER_NO","PRODUCT","QUANTITY","PAYMENT_MODE","AMOUNT","ORDER_DATE","MOBILE","EMAIL","NAME","ADDRESS","CITY","STATE","PINCODE"'."\n";
            foreach ($all_result as $key => $export_rows)
            {
                $fields .='"'.$export_rows->vendor.
                            '","' .
                            $export_rows->order_no .
                            '","' .
                            $export_rows->product .
                            '","' .
                            $export_rows->quantity .
                            '","' .
                            $export_rows->payment_mode.
                            '","' .
                            $export_rows->amount .
                            '","' .
                            date($export_rows->order_date) .
                            '","' .
                            $export_rows->mobile .
                            '","' .
                            $export_rows->email .
                            '","' .
                            $export_rows->name .
                            '","' .
                            $export_rows->address .
                            '","' .
                            $export_rows->city .
                            '","' .
                            $export_rows->state .
                            '","' .
                            $export_rows->pincode .
                            '"';
                $fields .= "\n";
                //                        }
            }
            header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
            header('Content-type: text/x-csv');
            $fileName = $fileExport;
            header("Content-Disposition: attachment; filename=".$fileName);
            header("Content-Transfer-Encoding: binary");
            header("Connection: close");
            echo $fields;
            exit();
          } 



       }else{
                 $all_result = Backup::when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*')->get();               


        if($request->has('export'))                        
        {
         $fileExport = count($all_result).'-'.date("d-M-Y").".csv";
            $fields =
                '"VENDOR","ORDER_NO","PRODUCT","QUANTITY","PAYMENT_MODE","AMOUNT","ORDER_DATE","MOBILE","EMAIL","NAME","ADDRESS","CITY","STATE","PINCODE"'."\n";
            foreach ($all_result as $key => $export_rows)
            {
                $fields .='"'.$export_rows->vendor.
                            '","' .
                            $export_rows->order_no .
                            '","' .
                            $export_rows->product .
                            '","' .
                            $export_rows->quantity .
                            '","' .
                            $export_rows->payment_mode.
                            '","' .
                            $export_rows->amount .
                            '","' .
                            date($export_rows->order_date) .
                            '","' .
                            $export_rows->mobile .
                            '","' .
                            $export_rows->email .
                            '","' .
                            $export_rows->name .
                            '","' .
                            $export_rows->address .
                            '","' .
                            $export_rows->city .
                            '","' .
                            $export_rows->state .
                            '","' .
                            $export_rows->pincode .
                            '"';
                $fields .= "\n";
                //                        }
            }
            header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
            header('Content-type: text/x-csv');
            $fileName = $fileExport;
            header("Content-Disposition: attachment; filename=".$fileName);
            header("Content-Transfer-Encoding: binary");
            header("Connection: close");
            echo $fields;
            exit();
          } 



       }     
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Reports'];       
        return view('theme.reports.report_list',['all_result'=>$all_result,'breadcrumbs'=>$breadcrumbs]);
    }

}
