<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\Download;
use App\Models\Servicable;

class ServicableController extends Controller
{
    function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $result = Servicable::when(request()->get('q'), function ($query) 
                            {
                                return $query->where('pincode',request()->get('q'));
                            })->when(request()->get('courier'), function ($query) 
                            {
                                return $query->where('courier',request()->get('courier'));
                            })->whereUser_id(Auth::id())->orderBy('pincode','Asc')
                        ->paginate(20);
        return view('theme.servicable.index')->with(['response'=>$result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('pincode.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(!empty($request->input('submit')) && $request->isMethod('post'))
         {
                $filename=$_FILES["uploadfile"]["tmp_name"];
                if($_FILES["uploadfile"]["size"] > 0)
                {   
                    $file = fopen($filename, "r");
                    $i=0;
                    while (($data = fgetcsv($file, 100000, ",")) !== FALSE)
                    {
                        if($i>0)
                        {       
                          if(Servicable::wherePincode(trim($data[0]))->whereCourier($request->courier)->count()==0)
                          {
                            $pincode = array("user_id"=>Auth::id(),"pincode"=>$data[0],"courier"=>$request->courier,'is_active'=>$request->is_active);
                            Servicable::create($pincode);
                          }else{
                            $pincode = array("user_id"=>Auth::id(),"pincode"=>$data[1],"courier"=>$request->courier,'is_active'=>$request->is_active);
                            Servicable::wherePincode(trim($data[0]))->whereCourier($request->courier)->update($pincode);
                          }  
                        }
                        $i++;
                    }
                }else{
                    return redirect()->route('servicable.index')->with('error','Invalid File!.');
                }  
         } 
        return redirect()->route('servicable.index')->with('message','Pincode Uploaded  Successful.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        if($request->has('is_active') && $request->is_active==0)
        {
           Servicable::where('id',$id)->update(['is_active'=>0]);
           return redirect()->route('servicable.index')->with('error','Pincode Service Blocked Successful.');
        } if($request->has('is_active') && $request->is_active==1){
           Servicable::where('id',$id)->update(['is_active'=>1]);
           return redirect()->route('servicable.index')->with('success','Pincode Service Activated Successful.');
        }

        if($request->has('is_cod') && $request->is_cod==0)
        {
           Servicable::where('id',$id)->update(['is_cod'=>0]);
           return redirect()->route('servicable.index')->with('error','COD Service Blocked Successful.');
        } if($request->has('is_cod') && $request->is_cod==1){
           Servicable::where('id',$id)->update(['is_cod'=>1]);
           return redirect()->route('servicable.index')->with('success','COD Service Activated Successful.');
        }
        $response = Servicable::findOrFail($id);
        return view('pincode.edit',['rows'=>$response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Servicable::where('id',$id)->delete();
        return redirect()->route('servicable.index')->with('error','Pincode Deleted Successful.');
    }
   /**
    
        * CodStatus Status Pincode wise

   */ 
    public function CodStatus(Request $request ,$id)
    {   
        $pincode_rows = Servicable::findOrFail($id);
        $pincode_rows->is_cod = $request->action;
        $pincode_rows->save();             
        if($request->action==0)
        {
            Session::flash('error','Pincode COD Blocked Successful.');
        }else{
            Session::flash('info','Pincode COD Activated Successful.');
        }    
        return redirect()->route('servicable.index');
    }


   /**
    
        * Active Status Pincode wise

   */ 
    public function ActiveStatus(Request $request ,$id)
    {   
        $pincode_rows = Servicable::findOrFail($id);
        $pincode_rows->is_active = $request->action;
        $pincode_rows->save();             
        if($request->action==0)
        {
            Session::flash('error','Pincode Blocked Successful.');
        }else{
            Session::flash('info','Pincode Activated Successful.');
        }    
        return redirect()->route('servicable.index');
    }


   /**
    
        * Export Status Pincode wise

   */ 
    public function Export(Request $request)
    {   
        $export_rows_result = Servicable::whereUser_id(Auth::id())->whereCourier($request->courier)->get();
        if($request->export==true)
        { 
            $name = 'TOP_PINCODE_'.date('Y-m-d H:i:s');
            Download::create(['user_id'=>Auth::id(),'name'=>$name,'datafile'=>count($export_rows_result)]);
            $fields = '"PINCODE","COURIER","IS_ACTIVE","LAST_UPDATED_DATE"'."\n";
            foreach ($export_rows_result as $key => $export_rows)
                    {
                        $fields .='"'.$export_rows->pincode.'","'.$export_rows->courier.'","'.$export_rows->is_active.'","'.$export_rows->updated_at.'"';
                        $fields .= "\n";
                    }
                header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
                header('Content-type: text/x-csv');
                $fileName = $request->courier."-PINCODES.csv";
                header("Content-Disposition: attachment; filename=".$fileName);
                header("Content-Transfer-Encoding: binary");
                header("Connection: close");
                echo $fields;
                exit();
        }else{
            Session::flash('info','Invalid Request.');
        }    
        return redirect()->route('servicable.index');
    }
}
