<?php

use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Str;
use Carbon\Carbon;

class Helper
{
    #------------------------ SEND MSG91OTP---------------------------------------
    public static function MSG91OTP($mobile, $otp, $message)
    {
        if (isset($mobile) && isset($otp) && isset($message)) {
            $url = 'http://control.msg91.com/api/sendotp.php';
            $response = Curl::to($url)
                ->withData(['authkey' => config('constants.MSG_91'), 'message' => urlencode($message), 'sender' => config('constants.APP_ID'), 'mobile' => $mobile, 'otp' => $otp])
                ->post();
        } else {
            $response = "Invalid Parameters";
        }

        return $response;
    }
    #------------------------ SEND MSG91OTP---------------------------------------
    public static function MSG91VERIFY($mobile, $otp)
    {
        if (isset($mobile) && isset($otp)) {
            $url = 'https://control.msg91.com/api/verifyRequestOTP.php?authkey=' . config('constants.MSG_91') . '&mobile=' . $mobile . '&otp=' . $otp;
            $response = Curl::to($url)
                ->asJson()
                ->post();
        } else {
            $response = "Invalid Parameters";
        }

        return $response;
    }
    public static function DATERANGEARR($request_date)
    {
        $date_range = explode('-', $request_date);
        return [date('Y-m-d', strtotime(@$date_range[0])), date('Y-m-d', strtotime(@$date_range[1]))];
    }
    public static function DATERANGE($request_date)
    {
        $date_range = explode('-', $request_date);
        $arr['s_date'] = date('Y-m-d H:i:s', strtotime($date_range[0]));
        $arr['e_date'] = date('Y-m-d H:i:s', strtotime($date_range[1]));
        return $arr;
    }
    //---------------------------- GENERATE GST-------------------------------
    public static function GST($amount)
    {
        $deducted_amount = ($amount * 18) / 100;
        return $deducted_amount;
    }
    //---------------------------- GENERATE GST DEDUCTED-------------------------------
    public static function GST_DEDUCTED($amount)
    {
        $deducted_amount = $amount - ($amount * 18) / 100;
        return $deducted_amount;
    }
    #--------------------------   Courier Services
    public static function AWB($courier_id)
    {
        $courier_rows = Courier::where('courier_id', $courier_id)
            ->where('status', 1)
            ->take(1)
            ->get();

        if ($courier_rows[0]->courier == 'DELHIVERY') {
            $delhivery_awb__generation_api = 'https://track.delhivery.com/waybill/api/bulk/json/?cl=' . urlencode($courier_rows[0]->username) . '&token=' . $courier_rows[0]->token . '&count=1';
            $AWBResponse = Curl::to($delhivery_awb__generation_api)->get();
            //   print_r($AWBResponse);
            $delivery_new_awb = explode(',', json_decode($AWBResponse, true));
            $waybill = $delivery_new_awb[0];
            //        dd($AWBResponse);
            //  die();
            if (isset($waybill)) {
                return $waybill;
            } else {
                return "false";
            }
        }
    }
    // CLosed Basic function
   
   public static function ParseTime($created_at)
   {
    $startTime = Carbon::parse($created_at);
    $finishTime = Carbon::parse(date('Y-m-d H:i:s'));
    return $totalDuration = $startTime->diffForHumans($finishTime);
   }

}
