<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopifyProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shopify_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_id');
            $table->foreign('integration_id')->references('id')->on('integrations'); 
            $table->string('productId')->unique();
            $table->text('title');
            $table->text('body_html');
            $table->string('vendor');
            $table->string('product_type');
            $table->text('handle');
            $table->string('published_at');
            $table->text('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shopify_products');
    }
}
