<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSlidersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreign('user_id')->references('id')->on('users'); 
            $table->text('name')->nullable();
            $table->text('slug')->unique();
            $table->text('upload_banner')->nullable();
            $table->longText('description')->nullable();
            $table->integer('sort_by')->default(0);
            $table->tinyInteger('is_active')->default(0);
            $table->timestamps();
            $table->index('id');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sliders');
    }
}
