@extends('theme.layouts.app')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">


<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                  </ol>
               </div>
               <h4 class="page-title">Products</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->

   <div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-lg-8">
                        <form class="d-flex flex-wrap align-items-center">
                            <div class="me-3">
                                <input type="search" class="form-control my-1 my-lg-0" id="inputPassword2" placeholder="Search..." />
                            </div>
                        </form>
                    </div>
                    <div class="col-lg-4">
                        <div class="text-lg-end pull-right">
                            <button type="button" class="btn btn-danger waves-effect waves-light mb-2 me-2"><i class="mdi mdi-basket me-1"></i> Add New Product</button>
                            <button type="button" class="btn btn-light waves-effect mb-2">Export</button>
                        </div>
                    </div>
                    <!-- end col-->
                </div>

                <div class="table-responsive">
                    <table class="table table-centered table-nowrap mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 20px;">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="customCheck1" />
                                        <label class="form-check-label" for="customCheck1">&nbsp;</label>
                                    </div>
                                </th>
                                <th>Products</th>
                                <th>Selling Price</th>
                                <th>Actual Price</th>
                                <th>COD Price</th>
                                <th>Order Status</th>
                                <th style="width: 125px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($all_result as $key=>$rows)
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="customCheck11" />
                                        <label class="form-check-label" for="customCheck11">&nbsp;</label>
                                    </div>
                                </td>
                                <td>
                                    <img src="{{ $rows->thumbimage }}" alt="{{ $rows->name }}" height="32" /> {{ $rows->name }}
                                </td>
                                <td><i class="fa fa-inr"></i> {{ $rows->selling_price }}</td>
                                <td><i class="fa fa-inr"></i> {{ $rows->actual_price }}</td>
                                <td><i class="fa fa-inr"></i> {{ $rows->cod_amount }}</td>
                                <td>
                                                    @if($rows->is_active==1)
                                                    <a href="{{ route('collection.edit',$rows->id) }}?action=0" title="Inactive" onclick="return confirm('Do you want to Inactive?');">
                                                        <span class="badge badge-success shadow-success m-1">Active</span>
                                                    </a>
                                                    @else
                                                    <a href="{{ route('collection.edit',$rows->id) }}?action=1" title="Active" onclick="return confirm('Do you want to Active?');">
                                                        <span class="badge badge-danger shadow-danger m-1">Inactive</span>
                                                    </a>
                                                    @endif
                                                </td>
                                <td>
                                    <a href="javascript:void(0);" class="action-icon"> <i class="mdi mdi-eye"></i></a>
                                    <a href="javascript:void(0);" class="action-icon"> <i class="mdi mdi-square-edit-outline"></i></a>
                                    <a href="javascript:void(0);" class="action-icon"> <i class="mdi mdi-delete"></i></a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <ul class="pagination pagination-rounded justify-content-end my-2">
                    <li class="page-item">
                        <a class="page-link" href="javascript: void(0);" aria-label="Previous">
                            <span aria-hidden="true">«</span>
                            <span class="visually-hidden">Previous</span>
                        </a>
                    </li>
                    <li class="page-item active"><a class="page-link" href="javascript: void(0);">1</a></li>
                    <li class="page-item"><a class="page-link" href="javascript: void(0);">2</a></li>
                    <li class="page-item"><a class="page-link" href="javascript: void(0);">3</a></li>
                    <li class="page-item"><a class="page-link" href="javascript: void(0);">4</a></li>
                    <li class="page-item"><a class="page-link" href="javascript: void(0);">5</a></li>
                    <li class="page-item">
                        <a class="page-link" href="javascript: void(0);" aria-label="Next">
                            <span aria-hidden="true">»</span>
                            <span class="visually-hidden">Next</span>
                        </a>
                    </li>
                </ul>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
    <!-- end col -->
</div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>

@endsection