<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8" />
        <title>{{ Request::segment(4) }}</title>

        <style>
            .mantu{
              text-transform: uppercase;
            }
            .tbody {
                width: 100%;
            }
            table tr th,
            table tr td {
                padding: 2px 2px;
                margin: 0px;
                vertical-align: top;
            }

            @charset "utf-8";
            * {
                margin: 0px auto;
                padding: 0px;
            }

            .barcode-39 {
                font-family: "barcode-39";
                margin: 0px;
            }
            .f8 {
                font-size: 36px;
            }
            @media print {
                @page {
                    size: 484px 484px;
                    margin: 0px;
                }
                .mantu {
                    page-break-after: always;
                }
            }
            .barcode-39 {
                font-family: "barcode-39";
                font-size: 24px;
            }
            .barcode-38 {
                font-family: "barcode-39";
                font-size: 30px;
                margin-bottom: 5px;
            }
        </style>
        <script type="text/javascript" src="{{asset('plugins/qrcode/JsBarcode.all.js')}}"></script>
        <script type="text/javascript" src="{{asset('plugins/qrcode/orderJsBarcode.all.js')}}"></script>
    </head>
    <body style="font-family: Calibri (Body); font-size: 11px;">

     @foreach($response as $key1=>$chunk_rows) 

       @foreach($chunk_rows as $key=>$rowslist) 
       @php
       $rows = (object) $rowslist;
       @endphp
          @if($key==0)
          <div class="mantu">
              <table cellpadding="0" cellspacing="0">
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd; padding: 0px;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="35%" style="vertical-align: middle;" align="center">
                                      <h2>{{ $rows->vendor }}</h2>
                                      <div style="border-top: solid 1px #ddd; margin-top: 15px;"></div>
                                      <br />
                                      <h2>DG - {{ $rows->is_dg }}</h2>
                                  </td>
                                  <td width="65%" style="border-left: solid 1px #dddd; text-align: center;">
                                      @if($rows->route!='N/A')
                                      <div><h3>{{ $rows->route }}</h3></div>
                                      @endif
                                      <div>
                                          <svg id="barcode{{ $rows->waybill }}"></svg>
                                          <script>
                                              JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                          </script>
                                      </div>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-transform: uppercase;">
                                      <h3 style="margin-top: 0px; border-bottom: solid 1px #ddd;">Ship To:</h3>
                                      <div style="font-size: 14px; margin-top: 10px;">
                                          <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                          <br />
                                          <strong>Address :</strong> {{ $rows->address }},
                                          <strong>
                                              {{ $rows->city }}, {{ $rows->state }} <br />
                                              Pincode : {{ $rows->pincode }}
                                          </strong>
                                          <br />
                                          <strong>Mobile : {{ $rows->mobile }}</strong>
                                      </div>
                                  </td>
                                  <td width="40%" style="border-left: solid 1px #ddd;" align="center">
                                      <h3 style="margin-top: 0px; text-align: center; border-bottom: solid 1px #ddd;">{{ $rows->courier }}</h3>
                                      @if($rows->payment_mode=='PREPAID')
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">PREPAID</div>
                                      </div>
                                      @else
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">Cash On Delivery</div>
                                          <div style="margin: 5px 0px;">Please collect</div>
                                          <div style="font-size: medium;">Rs.{{ $rows->amount }}</div>
                                      </div>
                                      @endif
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>
                  <tr>
                      <td colspan="5" style="padding: 0px;">
                          <table width="100%" cellpadding="0" cellspacing="0" class="tbody">
                              <thead>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0" style="border-bottom: solid 1px #ddd;">
                                              <tr>
                                                  <th width="60%" style="border-right: solid 1px #ddd;">Product</th>
                                                  <th width="10%" style="border-right: solid 1px #ddd;">Qty</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Price</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Subtotal</th>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                                  <tr></tr>
                              </thead>

                              <tbody>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0">
                                              <tr>
                                                  <td align="center" width="60%" style="border-right: solid 1px #ddd;"><strong>{{ $rows->proname }}</strong></td>
                                                  <td align="center" width="10%" style="border-right: solid 1px #ddd;">1</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                              </tbody>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="40%" style="border-right: solid 1px #ddd;">
                                      <center><p style="font-size: 20px; font-weight: bold;">{{ $rows->product_code }}</p></center>
                                      <div style="border-top: solid 1px #ddd; margin-top: 15px;"></div>
                                      <br />
                                      <p>If undelivered please return to {{ $rows->vendor }}</p>
                                  </td>
                                  <td width="45%" style="border-right: solid 1px #ddd;" align="left">
                                      <p>ORDER ID : {{ $rows->order_no }}</p>
                                      <br />
                                      ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                      <p>
                                          <br />
                                          <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                      </p>
                                  </td>
                                  <td width="15%" align="center">
                                      <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
              </table>
          </div>
          @elseif($key==1)

          <div class="mantu">
              <style type="text/css">
                  table.pic-table {
                      border-collapse: collapse;
                      width: 600px;
                      page-break-inside: avoid;
                  }
                  @font-face {
                      font-family: Basawa;
                      src: url(/static/fonts/B39MHR.ttf);
                  }
                  .barcode {
                      font-family: Basawa;
                      font-size: 72px;
                  }
                  .barcode-inside {
                      font-size: 48px;
                      text-align: center;
                      display: block;
                  }
                  .heading > td {
                      padding: 10px;
                  }
                  .brand-icon {
                      height: 30px;
                      vertical-align: middle;
                  }
                  .loc-code {
                      position: absolute;
                      right: 5px;
                      bottom: 5px;
                      font-size: 20px;
                  }
                  .address-cell {
                      padding: 5px;
                  }
                  .top-head {
                      margin-top: 5px;
                      margin-bottom: 8px;
                  }

                  .small-head {
                      font-weight: bold;
                      margin: 16px 0;
                  }
                  .barcode-head {
                      text-align: center;
                      margin-bottom: 4px;
                      margin-top: 6px;
                  }
                  .address-cell > h3 {
                      margin-top: 6px;
                      margin-bottom: 6px;
                      font-size: 25px;
                  }
                  .address-cell > p {
                      margin: 0 8px;
                  }
                  .pad-head {
                      font-size: 22px;
                  }
                  .text-center {
                      text-align: center;
                  }
                  .rotate270 {
                      -webkit-transform: rotate(270deg);
                      -moz-transform: rotate(270deg);
                      -o-transform: rotate(270deg);
                      -ms-transform: rotate(270deg);
                      transform: rotate(270deg);
                  }
                  .clearfix:after {
                      content: "";
                      display: table;
                      clear: both;
                  }
                  @media print {
                  }
              </style>
              <table border="0" class="pic-table">
                  <tbody>
                      <tr class="heading" style="text-align: center;">
                          <td style="font-size: 20px;">
                              {{ $rows->courier }}
                          </td>
                          <td>
                              {{$rows->route}}
                          </td>
                      </tr>
                      <tr>
                          <td colspan="2" style="position: relative; text-align: center; padding-left: 45px; padding-right: 45px;">
                              <span class="barcode">
                                  <svg id="barcode{{ $rows->waybill }}"></svg>
                                  <script>
                                      JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                  </script>
                              </span>
                          </td>
                      </tr>
                      <tr>
                          <td class="address-cell">
                              <h4 class="top-head">Shipping Address :</h4>
                              <div style="font-size: 14px; margin-top: 10px;">
                                  <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                  <strong>Address :</strong> {{ $rows->address }},
                                  <strong>
                                      {{ $rows->city }}, {{ $rows->state }} <br />
                                      Pincode : {{ $rows->pincode }}
                                  </strong>
                                  <br />
                                  <strong>Mobile : {{ $rows->mobile }}</strong>
                              </div>
                          </td>
                          <td style="width: 200px; text-align: center;">
                              @if($rows->payment_mode=='PREPAID')
                              <div style="font-size: medium;"><h3 class="pad-head">PREPAID</h3></div>
                              @else
                              <div style="font-size: medium;"><h3 class="pad-head">AMOUNT TO BE COLLECTED (COD)</h3></div>
                              <div style="font-size: medium;"><h3 class="pad-head">Rs.{{ $rows->amount }}</h3></div>
                              @endif
                          </td>
                      </tr>

                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>                      
                      <tr>
                          <td class="address-cell">
                              Product :
                          </td>
                          <td class="text-left">
                              {{ $rows->proname }}
                          </td>
                      </tr>
                      <tr>
                          <td class="address-cell">
                              Invoice Value:
                          </td>
                          <td class="text-center">
                              Rs. {{ $rows->amount }}
                          </td>
                      </tr>
                      <tr>
                          <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                              <table cellpadding="0" cellspacing="0" width="100%">
                                  <tr>
                                      <td width="40%" style="border-right: solid 1px #ddd;">
                                          <center>
                                              <p style="font-size: 20px; font-weight: bold;">{{ $rows->product_code }}</p>
                                              <div style="border-top: solid 1px #ddd; margin-top: 15px;"></div>
                                              <br />
                                              <h2>DG - {{ $rows->is_dg }}</h2>
                                          </center>
                                      </td>
                                      <td width="40%" style="border-right: solid 1px #ddd;" align="center">
                                          <br />
                                          ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                          <p>
                                              <br />
                                          ORDER ID : {{ $rows->order_no }} </p>
                                          <p>
                                              <br />
                                              <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                          </p>
                                      </td>
                                      <td width="40%" align="center">
                                          <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                      </td>
                                  </tr>
                              </table>
                          </td>
                      </tr>
                      <tr>
                          <td class="address-cell" colspan="2" style="position: relative; text-align: center; padding-left: 45px; padding-right: 45px;">
                              <p>If undelivered please return to {{ $rows->vendor }}</p>
                          </td>
                      </tr>
                  </tbody>
              </table>
          </div>
          @elseif($key==2)
          <div class="mantu">
              <table cellpadding="0" cellspacing="0">
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd; padding: 0px;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-align: center;">
                                      <div style="font-size: small;">{{ $rows->courier }}</div>
                                      <div>
                                          <svg id="barcode{{ $rows->waybill }}"></svg>
                                          <script>
                                              JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                          </script>
                                      </div>
                                  </td>

                                  <td width="40%" style="vertical-align: middle; border-left: solid 1px #dddd;">
                                      @if($rows->route!='N/A')
                                      <center><div style="font-size: small;">{{ $rows->route }}</div></center>
                                      @endif @if($rows->payment_mode=='PREPAID')
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">PREPAID</div>
                                      </div>
                                      @else
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">Cash On Delivery</div>
                                          <div style="margin: 5px 0px;">Please collect</div>
                                          <div style="font-size: medium;">Rs.{{ $rows->amount }}</div>
                                      </div>
                                      @endif
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-transform: uppercase;">
                                      <h3>Ship To:</h3>
                                      <div style="font-size: 14px; margin-top: 10px;">
                                          <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                          <br />
                                          <strong>Address :</strong> {{ $rows->address }},
                                          <strong>
                                              {{ $rows->city }}, {{ $rows->state }} <br />
                                              Pincode : {{ $rows->pincode }}
                                          </strong>
                                          <br />
                                          <strong>Mobile : {{ $rows->mobile }}</strong>
                                      </div>
                                  </td>
                                  <td width="40%" style="border-left: solid 1px #ddd;" align="center">
                                      <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                      <p><b>{{ $rows->order_no }}</b></p>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>
                  <tr>
                      <td colspan="5" style="padding: 0px;">
                          <table width="100%" cellpadding="0" cellspacing="0" class="tbody">
                              <thead>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0" style="border-bottom: solid 1px #ddd;">
                                              <tr>
                                                  <th width="60%" style="border-right: solid 1px #ddd;">Product</th>
                                                  <th width="10%" style="border-right: solid 1px #ddd;">Qty</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Price</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Subtotal</th>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                                  <tr></tr>
                              </thead>

                              <tbody>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0">
                                              <tr>
                                                  <td align="center" width="60%" style="border-right: solid 1px #ddd;"><strong>{{ $rows->proname }}</strong></td>
                                                  <td align="center" width="10%" style="border-right: solid 1px #ddd;">1</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                              </tbody>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="border-right: solid 1px #ddd;">
                                      <center><p style="font-size: 20px; font-weight: bold;">{{ $rows->product_code }}</p></center>
                                      <div style="border-top: solid 1px #ddd; margin-top: 15px;"></div>
                                      <br />
                                      <p align="center">If undelivered please return to {{ $rows->vendor }}</p>
                                  </td>
                                  <td width="40%" style="border-right: solid 1px #ddd;" align="left">
                                      <br />
                                      ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                      <p>
                                          <br />
                                          <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                      </p>
                                      <div style="border-top: solid 1px #ddd; margin-top: 15px;"></div>
                                      <center><h2>DG - {{ $rows->is_dg }}</h2></center>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
              </table>
          </div>

          @elseif($key==3)

          <div class="mantu">
              <style type="text/css">
                  table.pic-table {
                      border-collapse: collapse;
                      width: 600px;
                      page-break-inside: avoid;
                  }
                  @font-face {
                      font-family: Basawa;
                      src: url(/static/fonts/B39MHR.ttf);
                  }
                  .barcode {
                      font-family: Basawa;
                      font-size: 72px;
                  }
                  .barcode-inside {
                      font-size: 48px;
                      text-align: center;
                      display: block;
                  }
                  .heading > td {
                      padding: 10px;
                  }
                  .brand-icon {
                      height: 30px;
                      vertical-align: middle;
                  }
                  .loc-code {
                      position: absolute;
                      right: 5px;
                      bottom: 5px;
                      font-size: 20px;
                  }
                  .address-cell {
                      padding: 5px;
                  }
                  .top-head {
                      margin-top: 5px;
                      margin-bottom: 8px;
                  }

                  .small-head {
                      font-weight: bold;
                      margin: 16px 0;
                  }
                  .barcode-head {
                      text-align: center;
                      margin-bottom: 4px;
                      margin-top: 6px;
                  }
                  .address-cell > h3 {
                      margin-top: 6px;
                      margin-bottom: 6px;
                      font-size: 25px;
                  }
                  .address-cell > p {
                      margin: 0 8px;
                  }
                  .pad-head {
                      font-size: 22px;
                  }
                  .text-center {
                      text-align: center;
                  }
                  .rotate270 {
                      -webkit-transform: rotate(270deg);
                      -moz-transform: rotate(270deg);
                      -o-transform: rotate(270deg);
                      -ms-transform: rotate(270deg);
                      transform: rotate(270deg);
                  }
                  .clearfix:after {
                      content: "";
                      display: table;
                      clear: both;
                  }
                  @media print {
                  }
              </style>
              <table border="0" class="pic-table">
                  <tbody>
                      <tr>
                          <td class="address-cell">
                              <h4 class="top-head">Shipping Address :</h4>
                              <div style="font-size: 14px; margin-top: 10px;">
                                  <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                  <strong>Address :</strong> {{ $rows->address }},
                                  <strong>
                                      {{ $rows->city }}, {{ $rows->state }} <br />
                                      Pincode : {{ $rows->pincode }}
                                  </strong>
                                  <br />
                                  <strong>Mobile : {{ $rows->mobile }}</strong>
                              </div>
                          </td>
                          <td style="width: 200px; text-align: center;">
                              @if($rows->payment_mode=='PREPAID')
                              <div style="font-size: medium;"><h3 class="pad-head">PREPAID</h3></div>
                              @else
                              <div style="font-size: medium;"><h3 class="pad-head">AMOUNT TO BE COLLECTED (COD)</h3></div>
                              <div style="font-size: medium;"><h3 class="pad-head">Rs.{{ $rows->amount }}</h3></div>
                              @endif
                          </td>
                      </tr>
                      <tr class="heading" style="text-align: center;">
                          <td style="font-size: 20px;">
                              {{ $rows->courier }}
                          </td>
                          <td>
                              {{$rows->route}}
                          </td>
                      </tr>
                      <tr>
                          <td style="position: relative; text-align: center; padding-left: 45px; padding-right: 45px;">
                              <span class="barcode">
                                  <svg id="barcode{{ $rows->waybill }}"></svg>
                                  <script>
                                      JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                  </script>
                              </span>
                          </td>
                          <td>
                              <br />
                              <br />
                              <center><h2>DG - {{ $rows->is_dg }}</h2></center>
                          </td>
                      </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>

                      <tr>
                          <td class="address-cell">
                              Product :
                          </td>
                          <td class="text-center">
                              {{ $rows->proname }}
                          </td>
                      </tr>
                      <tr>
                          <td class="address-cell">
                              Invoice Value:
                          </td>
                          <td class="text-center">
                              Rs. {{ $rows->amount }}
                          </td>
                      </tr>
                      <tr>
                          <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                              <table cellpadding="0" cellspacing="0" width="100%">
                                  <tr>
                                      <td width="40%" style="border-right: solid 1px #ddd;">
                                          <center>
                                              <p style="font-size: 20px; font-weight: bold;">
                                                  <br />
                                                  {{ $rows->product_code }}
                                              </p>
                                          </center>
                                      </td>
                                      <td width="40%" style="border-right: solid 1px #ddd;" align="center">
                                          <br />
                                          ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                          <p>
                                              <br />ORDER ID : {{ $rows->order_no }}</p>
                                          <p>
                                              <br />
                                              <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                          </p>
                                      </td>
                                      <td width="40%" align="center">
                                          <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                      </td>
                                  </tr>
                              </table>
                          </td>
                      </tr>
                      <tr>
                          <td class="address-cell" colspan="2" style="position: relative; text-align: center; padding-left: 45px; padding-right: 45px;">
                              <p>If undelivered please return to {{ $rows->vendor }}</p>
                          </td>
                      </tr>
                  </tbody>
              </table>
          </div>
          @elseif($key==4)
          <div class="mantu">
              <table cellpadding="0" cellspacing="0">
                  <tr>
                      <td colspan="5">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-transform: uppercase;">
                                      <h3>Ship To:</h3>
                                      <div style="font-size: 14px; margin-top: 10px;">
                                          <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                          <br />
                                          <strong>Address :</strong> {{ $rows->address }},
                                          <strong>
                                              {{ $rows->city }}, {{ $rows->state }} <br />
                                              Pincode : {{ $rows->pincode }}
                                          </strong>
                                          <br />
                                          <strong>Mobile : {{ $rows->mobile }}</strong>
                                      </div>
                                  </td>
                                  <td width="40%" style="border-left: solid 1px #ddd;" align="center">
                                      <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                      <p><b>{{ $rows->order_no }}</b></p>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>
                  <tr>
                      <td colspan="5" style="padding: 0px;">
                          <table width="100%" cellpadding="0" cellspacing="0" class="tbody">
                              <thead>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0" style="border-bottom: solid 1px #ddd;">
                                              <tr>
                                                  <th width="60%" style="border-right: solid 1px #ddd;">Product</th>
                                                  <th width="10%" style="border-right: solid 1px #ddd;">Qty</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Price</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Subtotal</th>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                                  <tr></tr>
                              </thead>

                              <tbody>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0" style="border-bottom: solid 1px #ddd;"> 
                                              <tr>
                                                  <td align="center" width="60%" style="border-right: solid 1px #ddd;"><strong>{{ $rows->proname }}</strong></td>
                                                  <td align="center" width="10%" style="border-right: solid 1px #ddd;">1</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                              </tbody>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd; padding: 0px;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-align: center;">
                                      <div style="font-size: small;">{{ $rows->courier }}</div>
                                      <div>
                                          <svg id="barcode{{ $rows->waybill }}"></svg>
                                          <script>
                                              JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                          </script>
                                      </div>
                                  </td>

                                  <td width="40%" style="vertical-align: middle; border-left: solid 1px #dddd;">
                                      @if($rows->route!='N/A')
                                      <center><div style="font-size: small;">{{ $rows->route }}</div></center>
                                      @endif @if($rows->payment_mode=='PREPAID')
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">PREPAID</div>
                                      </div>
                                      @else
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">Cash On Delivery</div>
                                          <div style="margin: 5px 0px;">Please collect</div>
                                          <div style="font-size: medium;">Rs.{{ $rows->amount }}</div>
                                      </div>
                                      @endif
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="40%" style="border-right: solid 1px #ddd;">
                                      <br />
                                      <center><p style="font-size: 20px; font-weight: bold;">{{ $rows->product_code }}</p></center>
                                  </td>
                                  <td width="20%" style="border-right: solid 1px #ddd;">
                                      <center>
                                          <br />
                                          <h2>DG - {{ $rows->is_dg }}</h2>
                                      </center>
                                  </td>

                                  <td width="40%" style="border-right: solid 1px #ddd;" align="center">
                                      <br />
                                      ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                      <p>
                                          <br />
                                          <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                      </p>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td>
                          <p align="center">If undelivered please return to {{ $rows->vendor }}</p>
                      </td>
                  </tr>
              </table>
          </div>
          @elseif($key==5)
          <div class="mantu">
              <table cellpadding="0" cellspacing="0">
                  <tr>
                      <td colspan="5">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-transform: uppercase;">
                                      <h3>Ship To:</h3>
                                      <div style="font-size: 14px; margin-top: 10px;">
                                          <strong style="font-size: 15px;">{{ $rows->name }}</strong><br />
                                          <br />
                                          <strong>Address :</strong> {{ $rows->address }},
                                          <strong>
                                              {{ $rows->city }}, {{ $rows->state }} <br />
                                              Pincode : {{ $rows->pincode }}
                                          </strong>
                                          <br />
                                          <strong>Mobile : {{ $rows->mobile }}</strong>
                                      </div>
                                  </td>
                                  <td width="40%" style="border-left: solid 1px #ddd;" align="center">
                                      <img src="https://chart.googleapis.com/chart?cht=qr&chl={{ $rows->order_no }}&chs=80x80&choe=UTF-8&chld=L|2" rel="nofollow" alt="{{ $rows->order_no }}" />
                                      <p><b>{{ $rows->order_no }}</b></p>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd;border-top: solid 1px #ddd;">&nbsp;@if(strlen($rows->address)>50)<br>@else <br><br><br><br><br><br><br> @endif</td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-bottom: solid 1px #ddd; padding: 0px;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="60%" style="text-align: center;">
                                      <div style="font-size: small;">{{ $rows->courier }}</div>
                                      <div>
                                          <svg id="barcode{{ $rows->waybill }}"></svg>
                                          <script>
                                              JsBarcode("#barcode{{ $rows->waybill }}", "{{ $rows->waybill }}");
                                          </script>
                                      </div>
                                  </td>

                                  <td width="40%" style="vertical-align: middle; border-left: solid 1px #dddd;">
                                      @if($rows->route!='N/A')
                                      <center><div style="font-size: small;">{{ $rows->route }}</div></center>
                                      @endif @if($rows->payment_mode=='PREPAID')
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">PREPAID</div>
                                      </div>
                                      @else
                                      <div style="border: solid 2px #212121; text-align: center; margin: 10px; padding: 5px 10px;">
                                          <div style="font-size: medium;">Cash On Delivery</div>
                                          <div style="margin: 5px 0px;">Please collect</div>
                                          <div style="font-size: medium;">Rs.{{ $rows->amount }}</div>
                                      </div>
                                      @endif
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="padding: 0px;">
                          <table width="100%" cellpadding="0" cellspacing="0" class="tbody">
                              <thead>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0" style="border-bottom: solid 1px #ddd;">
                                              <tr>
                                                  <th width="60%" style="border-right: solid 1px #ddd;">Product</th>
                                                  <th width="10%" style="border-right: solid 1px #ddd;">Qty</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Price</th>
                                                  <th width="15%" style="border-right: solid 1px #ddd;">Subtotal</th>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                                  <tr></tr>
                              </thead>

                              <tbody>
                                  <tr>
                                      <td colspan="5" style="padding: 0px;">
                                          <table width="100%" cellpadding="0" cellspacing="0">
                                              <tr>
                                                  <td align="center" width="60%" style="border-right: solid 1px #ddd;"><strong>{{ $rows->proname }}</strong></td>
                                                  <td align="center" width="10%" style="border-right: solid 1px #ddd;">1</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                                  <td align="center" width="15%" style="border-right: solid 1px #ddd;">Rs.{{ $rows->amount }}</td>
                                              </tr>
                                          </table>
                                      </td>
                                  </tr>
                              </tbody>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td colspan="5" style="border-top: solid 1px #ddd; border-bottom: solid 1px #ddd; font-weight: 700;">
                          <table cellpadding="0" cellspacing="0" width="100%">
                              <tr>
                                  <td width="40%" style="border-right: solid 1px #ddd;">
                                      <br />
                                      <center><p style="font-size: 20px; font-weight: bold;">{{ $rows->product_code }}</p></center>
                                  </td>
                                  <td width="20%" style="border-right: solid 1px #ddd;">
                                      <center>
                                          <br />
                                          <h2>DG - {{ $rows->is_dg }}</h2>
                                      </center>
                                  </td>

                                  <td width="40%" style="border-right: solid 1px #ddd;" align="center">
                                      <br />
                                      ORDER DATE : {{ date('d M, Y',strtotime($rows->order_date)) }}
                                      <p>
                                          <br />
                                          <span style="font-size: 10px;">FOR SUPPORT : 09311826073</span>
                                      </p>
                                  </td>
                              </tr>
                          </table>
                      </td>
                  </tr>
                  <tr>
                      <td>
                          <p align="center">If undelivered please return to {{ $rows->vendor }}</p>
                      </td>
                  </tr>
              </table>
          </div>
          @endif 
      @endforeach
    @endforeach
    </body>
</html>
