@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <form method="get" action="{{ route('fetch-all-orders') }}">
                            <div class="btn-group btn-group-sm" role="group">
                                <input type="text" class="form-control form-control-sm" style="width: 320px;" name="custom_search" placeholder="Search Order Id">&nbsp;&nbsp;
                                <input type="text" value="{{ Request::get('daterange') }}" class="form-control form-control-sm" style="width: 320px;" name="daterange" id="reportrange" onclick="daterange(start,end)" placeholder="Search By YYYY-MM-DD">
                                <button type="submit" class="btn btn-primary btn-sm has-icon"><i class="fa fa-search"></i> search</button>        
                            </div>
                        </form>
                    </div>
                    <h4 class="page-title">{{ $all_result->total() }} Orders</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-xl-12">
                <div class="card-box">
                    <h4 class="header-title mb-3">Recently Orders</h4>
                                            <table class="table table-centered table-nowrap mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th style="width: 20px;">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                                                <label class="custom-control-label" for="customCheck1">&nbsp;</label>
                                                            </div>
                                                        </th>
                                                        <th>Order ID</th>
                                                        <th>Products</th>
                                                        <th>Date</th>
                                                        <th>Payment Status</th>
                                                        <th>Total</th>
                                                        <th>Order Status</th>
                                                        <th>Calling Status</th>
                                                        <th style="width: 125px;">Action</th>
                                                    </tr>
                                                </thead>
                            <tbody>
                          @foreach($all_result as $key=>$rows)      
                            <tr>
                                <td>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="customCheck2">
                                        <label class="custom-control-label" for="customCheck2">&nbsp;</label>
                                    </div>
                                </td>
                                <td><b class="text-body font-weight-bold">#{{ $rows->order_no }}</b></td>
                                <td><img src="{{ $rows->src }}" height="40" width="40" /></td>
                                <td>{{ Helper::ParseTime($rows->created_at) }}</td>
                                <td>@if($rows->pmode=='PREPAID')
                                    <span class="badge badge-success">PREPAID</span>
                                    @else
                                    <span class="badge badge-danger">CASH ON DELIVERY</span>
                                    @endif
                                </td>
                                <td><i class="fa fa-inr"></i> {{ number_format($rows->amount,2) }}</td>
                                <td>@if($rows->pmode=='PREPAID')
                                    <span class="badge badge-info">Shipped</span>
                                    @else
                                    <span class="badge badge-warning">Processing</span>
                                    @endif
                                </td>
                                <td><b class="text-body badge badge-success text-white font-weight-bold">Confirmed</b></td>
                                <td><a href="{{ route('fetch-single-orders',encrypt($rows->id)) }}" title="Get More Details" class="btn btn-sm btn-secondary"><i class="fa fa-eye"></i> View Details</a></td>
                            </tr>
                          @endforeach      
                            </tbody>
                        </table>
                    </div>
                </div>
                    @include('theme.layouts.pagination')
            </div><!-- end col-->

        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div>

@endsection
