@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                  </ol>
                    </div>
                    <h4 class="page-title">{{ 'Reports' }}</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-xl-12">
                <div class="card-box">

                        <form method="get" action="{{ route('fetch-reports-orders') }}">
                            <div class="btn-group btn-group-sm" role="group">
                                <select class="form-control form-control-sm" style="width: 120px;" name="filter">
                                    <option value="All">All</option>
                                    <option value="Backup">Backup</option>
                                    <option value="Dispatched">Dispatched</option>
                                    <option value="Fresh">Fresh</option>
                                </select>    
                                        &nbsp;&nbsp;
                                <input type="text" class="form-control form-control-sm" style="width: 160px;" name="custom_search" placeholder="Search Order Id">&nbsp;&nbsp;
                                <input type="text" value="{{ Request::get('daterange') }}" class="form-control form-control-sm" style="width: 220px;" name="daterange" id="reportrange" onclick="daterange(start,end)" placeholder="Search By YYYY-MM-DD">
                                <button type="submit" class="btn btn-primary btn-sm has-icon"><i class="fa fa-search"></i> search</button>        
                                &nbsp;
                                        
                            </div>
                        </form>
                    <hr>
                    <h4 class="header-title mb-3">Serach Orders</h4>
                    <table class="table table-centered table-nowrap table-sm mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>TOTAL</th>
                                <th>FILENAME</th>
                                <th style="width: 125px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>#</td>
                                <td>{{ count($all_result) }}</td>
                                <td>@if(!Request::has('filter')) {{ date('d-m-Y').'.csv' }} @else {{ Request::get('filter').'.csv' }}  @endif</td>
                                <td><a href="{{ route('fetch-reports-orders',['filter'=>Request::get('filter'),'export'=>'true','daterange'=>Request::get('daterange')]) }}" class="btn btn-success btn-sm"><i class="fa fa-download"> Download</i></td>
                            </tr>
                        </tbody>
                    </table>
                    </div>
                </div>
                    @include('theme.layouts.pagination')
            </div><!-- end col-->

        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div>

@endsection
