@extends('theme.layouts.app') @section('content')

<style type="text/css">
    fieldset.scheduler-border {
        border: 1px groove #ddd !important;

        padding: 0 1.4em 1.4em 1.4em !important;

        margin: 0 0 1.5em 0 !important;

        -webkit-box-shadow: 0px 0px 0px 0px #000;

        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border {
        font-size: 1.2em !important;

        font-weight: bold !important;

        text-align: left !important;

        width: auto;

        padding: 0 10px;

        border-bottom: none;
    }
</style>

<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Site</a></li>
                            <li class="breadcrumb-item active">Site</li>
                        </ol>
                    </div>
                    <h4 class="page-title">Site Config</h4>
                </div>
            </div>
        </div>

        <form class="needs-validation parsley-examples" data-parsley-validate action="{{route('site.store')}}" method="POST" enctype="multipart/form-data" novalidate>
            @csrf
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                                <div class="form-group">
                                    <label for="input-1">Site Name *</label>
                                    <input type="text" class="form-control" name="name" placeholder="Product Name *" value="{{ $rows->name }}" required />
                                    <div class="invalid-feedback">
                                        Please Enter Name.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Email *</label>
                                    <input type="text" class="form-control" name="secondary_email" placeholder="Secondary Email *" value="{{ $rows->secondary_email }}" required />
                                    <div class="invalid-feedback">
                                        Please Enter Email.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Mobile *</label>
                                    <input type="text" class="form-control" name="mobile" placeholder="Mobile *" value="{{ $rows->mobile }}" />
                                    <div class="invalid-feedback">
                                        Please Enter mobile.
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Address</label>
                                    <textarea type="text" class="form-control" name="address" id="address" placeholder="Address ">{{ $rows->address }}</textarea>
                                    <div class="invalid-feedback">
                                        Please Enter address.
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Analatics</i></legend>
                                <div class="form-group">
                                    <label for="input-1">Analytics code</label>
                                    <textarea type="text" class="form-control" name="pixle_code" id="pixle_code"  placeholder="Analytics code " style="height: 233px;">{{ $rows->pixle_code }}</textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Code.
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Social Media</i></legend>
                                <div class="form-group">
                                    <label for="input-1">facebook</label>
                                    <textarea type="text" class="form-control" name="facebook" placeholder="facebook"></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Twitter</label>
                                    <textarea type="text" class="form-control" name="twitter" placeholder="twitter"></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">Instagram</label>
                                    <textarea type="text" class="form-control" name="instagram" placeholder="Instagram"></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="input-1">YouTube</label>
                                    <textarea type="text" class="form-control" name="youtube" placeholder="YouTube"></textarea>
                                </div>
                            </fieldset>

                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Image</i></legend>
                                <div class="form-group" style="display: none;">
                                    <label for="input-1">Image Cdn Link</label>
                                    <textarea type="text" class="form-control" name="image_path" placeholder="Image Cdn Link"></textarea>
                                    <div class="invalid-feedback">
                                        Please Enter Image cdn Link.
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="input-1">Choose Logo Images *</label>
                                    <input type="hidden" value="{{ $rows->logo }}" name="logo" />

                                    <input type="file" class="form-control" name="image" accept=".png,.jpg,.jpeg,.gif" />
                                </div>
                            </fieldset>
                            <fieldset class="scheduler-border">
                                <legend align="left" class="scheduler-border"><i>Other info.</i></legend>

                                <div class="form-group">
                                    <label for="input-3">Status</label>
                                    <select name="is_active" required class="form-control">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </fieldset>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary shadow-primary px-5 pull-right" name="submit" value="Save">Save</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    @endsection
    <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
    <script>
        window.onload = function () {
            CKEDITOR.replace("description");
            setTimeout(CKEDITOR.instances.description.resize(300, 400), 300);
        };
    </script>
<script>
  function productSlug(val)
  {   
    var slugname = val.toLowerCase().trim();
    var slug_name = slugname.replace(/ /g,"-");
    var slug_name1 = slug_name.replace(/([.*+%?^=!:${}&'()|\[\]\/\\#])/g,"");
    document.getElementById("meta_title").value = ''+val; 
  

  //alert(slug_name);
}

</script>


