@extends('theme.layouts.app') @section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                         <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                         <li class="breadcrumb-item">Settings</li>
                         <li class="breadcrumb-item active">Add Warehouse</li>
                        </ol>
                    </div>
                    <h4 class="page-title">Add Warehouse</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
      <form action="{{ route('warehouse.store') }}" method = "post" class = "needs-business-validation was-validated" role="form" novalidate>    
        @csrf
        <div class="row row-sm">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                      <fieldset class="scheduler-border">
                        <legend class="scheduler-border">Warehouse Details.</legend>
                         <div class="form-block">
                          <div class="form-block-body">
                            <div class="row gutters">
                              <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="form-group">
                                  <label for="nikname" class="font-size-sm">Hubs Name <span class="text-danger"> *</span></label>
                                  <input type="text" class="form-control" placeholder="Hubs Name *" name="name"  required="required" value="{{ old('name') }}">
                                  @error('name')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                              <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="form-group">
                                  <label for="contact_name" class="font-size-sm">Address <span class="text-danger"> *</span></label>
                                  <textarea class="form-control" placeholder="Address *" name="address_1" required>{{ old('address_1') }}</textarea>
                                  @error('address_1')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                              <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="form-group">
                                  <label for="contact_name" class="font-size-sm">Address 2<span class="text-danger"> *</span></label>
                                  <textarea class="form-control" placeholder="Address 2*" name="address_2" required>{{ old('address_2') }}</textarea>
                                  @error('address_2')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>

                            </div>
                            <div class="form-group">
                              <label for="nikname" class="font-size-sm">Contact Person <span class="text-danger"> *</span></label>
                              <input type="text" class="form-control" placeholder="Contact Person *" name="contact_name" required="required" value="{{ old('contact_name') }}">
                              @error('contact_name')
                                <strong class="text-danger">{{ $message }}</strong>
                              @enderror
                            </div>
                          </div>
                         </div>
                      </fieldset>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-body">
                      <fieldset class="scheduler-border">
                        <legend class="scheduler-border">Other Details.</legend>
                         <div class="form-block">
                          <div class="form-block-body">
                            <div class="row gutters">
                              <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                <div class="form-group">
                                  <label>Mobile <span class="text-danger"> *</span></label>
                                  <input type="number" class="form-control" name="mobile" placeholder="Mobile Number *" required="required" value="{{ old('mobile') }}" />
                                  @error('mobile')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                              <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                <div class="form-group">
                                  <label>Email <span class="text-danger"> *</span></label>
                                  <input type="email" class="form-control" name="email" placeholder="Email ID *" required="required" value="{{ old('email') }}" />
                                  @error('email')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                            </div>
                            <div class="row gutters">
                              <div class="col-xl-4 col-lg-6 col-md-4 col-sm-12 col-12">
                                <div class="form-group">
                                  <label>Pincode <span class="text-danger"> *</span></label>
                                  <input type="number" class="form-control" name="pincode" placeholder="Pincode  *" value="{{ old('pincode') }}" required />
                                  @error('pincode')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                              <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                <div class="form-group">
                                  <label>City <span class="text-danger"> *</span></label>
                                  <input type="text" class="form-control" name="city" placeholder="City *" value="{{ old('city') }}" required />
                                  @error('city')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                              <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                                <div class="form-group">
                                  <label>State <span class="text-danger"> *</span></label>
                                  <input type="text" class="form-control" name="state" value="{{ old('state') }}" placeholder="State *" required/>
                                  @error('state')
                                    <strong class="text-danger">{{ $message }}</strong>
                                  @enderror
                                </div>
                              </div>
                            </div>
                            <hr>
                            <div class="form-group pull-right">
                              <button type="button" class="btn btn-secondary shadow-primary" onclick="javascript:history.back();">Cancel</button>
                              <button type="submit" name="submit" value="Save" class="btn btn-primary shadow-primary">Add Warehouse</button>
                            </div>
                          </div>
                         </div>
                      </fieldset>
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
    <!-- end container-fluid -->
</div>
@endsection
