<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Config;
use App\Models\Backup;
use App\Models\Integration;
use App\Models\User;
use Str;

class WebhookController extends Controller
{
    


	public function shopify_response(Request $request)
	{
       //  Storage::disk('public')->put(strtotime(date('Y-m-d H:i:s')).'-orders-shopify.json', file_get_contents('php://input'));
//        $rows = json_decode(file_get_contents('https://codverify.com/apps/storage/app/public/1611051930-orders-shopify.json'),true);
     if(!empty(file_get_contents('php://input')))
     {    
		$rows = json_decode(file_get_contents('php://input'),true);
        $api = Integration::whereToken($request->segment(4))->first();
        $mobile1 = str_replace(' ', '', $rows['billing_address']['phone']);
        $mobile = substr($mobile1, -10); //'8920085387';//
        $backups = Backup::where('order_id',$rows['id'])->take(1)->first();
            if (is_null($backups)) 
            {	
                    $cust_data['user_id'] 		 = $api->user_id;
                    $cust_data['integration_id'] = $api->id;
                    $cust_data['order_id']       = $rows['id'];
                    $cust_data['vendor']         = $rows['line_items'][0]['vendor'];
                    $cust_data['product_id']     = $rows['line_items'][0]['product_id'];
                    $cust_data['variant_id']     = $rows['line_items'][0]['variant_id'];
                    $cust_data['order_no']       = str_replace("'", "", $rows['name']);
                    $cust_data['email']          = $rows['email'];
                    $cust_data['mobile']         = $mobile;
                    $cust_data['name']           = str_replace("'", "", strtolower(str_replace(' ', '', $rows['billing_address']['first_name'])) . ' ' . strtolower(str_replace(' ', '', $rows['billing_address']['last_name'])));
                    $cust_data['address']        = str_replace("'", "", $rows['billing_address']['address1'] . ' ,' . $rows['billing_address']['address2']);
                    $cust_data['city']           = str_replace("'", "", $rows['billing_address']['city']);
                    $cust_data['state']          = str_replace("'", "", $rows['billing_address']['province']);
                    $cust_data['pincode']        = $rows['billing_address']['zip'];
                    $cust_data['payment_mode']   = $rows['gateway'];

                    if ($rows['financial_status'] == 'pending') {
                    $cust_data['pmode']          = 'COD';
                            } else {
                    $cust_data['pmode']   = 'PREPAID';
                            }

                    $cust_data['amount']         = (float) $rows['total_price'];
                    $cust_data['subtotal_price']         = (float) $rows['order']['subtotal_price'];
                    $cust_data['total_tax']         = (float) $rows['order']['total_tax'];
                    $cust_data['shipping_amount']         = (float) $rows['order']['shipping_lines'][0]['price'];
                    $cust_data['product']        = $rows['line_items'][0]['title'];
                    $cust_data['quantity']       = $rows['line_items'][0]['quantity'];
                    $cust_data['variant_title']  = $rows['line_items'][0]['variant_title'];
                    $cust_data['order_date']     = date('Y-m-d H:i:s', strtotime($rows['created_at']));
                    $cust_data['pcount']         = $rows['customer']['orders_count'];
                    $cust_data['ip_address']     = $rows['browser_ip'];
    //                print_r($cust_data); die();
                    Backup::insert($cust_data);
             /*
                    $backup_id = DB::getPdo()->lastInsertId();        


    #-------------------------------All Orders Variables -----------------------------------

                    $orderid       = $rows['id'];
                    $vendor         = $rows['line_items'][0]['vendor'];
                    $order_no       = str_replace("'", "", $rows['name']);
                    $email          = $rows['email'];
                    $mobile         = $mobile;
                    $name           = str_replace("'", "", strtolower(str_replace(' ', '', $rows['billing_address']['first_name'])) . ' ' . strtolower(str_replace(' ', '', $rows['billing_address']['last_name'])));
                    $address        = str_replace("'", "", $rows['billing_address']['address1'] . ' ,' . $rows['billing_address']['address2']);
                    $city           = str_replace("'", "", $rows['billing_address']['city']);
                    $state          = str_replace("'", "", $rows['billing_address']['province']);
                    $pincode        = $rows['billing_address']['zip'];
                    $amount         = (float) $rows['total_price'];
                    $product        = $rows['line_items'][0]['title'];
                    $quantity       = $rows['line_items'][0]['quantity'];
                    $order_date     = date('Y-m-d');
                    $pcount         = $rows['customer']['orders_count'];
                    $browser_ip     = $rows['browser_ip'];        
                    $user_agent     = $rows['client_details']['user_agent'];        
                    
                    if ($rows['financial_status'] == 'pending') {
                        $payment_mode = 'COD';
                            } else {
                        $payment_mode = 'PREPAID';
                            }

                    if (Client_detail::where('backup_id',$backup_id)->count()==0) 
                    {   
                        Client_detail::create(['backup_id'=>$backup_id,'browser_ip'=>$browser_ip,'user_agent'=>$user_agent]);
                    }                        
            //--------------------------------Mobile---------------------------------------------

                    if (Mobile::whereMobile($mobile)->count()==0) 
                    {   
                       $mobiles =  Mobile::create(['mobile'=>$mobile,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);
                       $mobile_id = $mobiles->id;
                    }else{
                        $mobile_id = Mobile::whereMobile($mobile)->value('id');            
                    }        
            //--------------------------------E-mail---------------------------------------------

                    if (Email::whereEmail($email)->count()==0) 
                    {   
                        $emails = Email::create(['email'=>$email,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);
                        $email_id = $emails->id;
                    }else{
                        $email_id = Email::whereEmail($email)->value('id');            
                    }       
            //--------------------------------Vendor---------------------------------------------

                    if (Vendor::whereVendor($vendor)->count()==0) 
                    {   
                        $vendors = Vendor::create(['vendor'=>$vendor,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);
                         $vendor_id =  $vendors->id;
                    }else{
                        $vendor_id = Vendor::whereVendor($vendor)->value('id');            
                    }     

            //--------------------------------Vendor---------------------------------------------

                    if (Product::whereProduct($product)->count()==0) 
                    {   
                       $products = Product::create(['product'=>$product,'is_active'=>1,'created_at'=>date('Y-m-d H:i:s')]);
                       $product_id = $products->id; 
                    }else{
                        $product_id = Product::whereProduct($product)->value('id');            
                    }     

            //--------------------------------Vendor---------------------------------------------

                    if (Address::whereAddress($address)->count()==0) 
                    {   
                        $addresses = Address::create(['name'=>$name,'address'=>$address,'city'=>$city,'state'=>$state,'pincode'=>$pincode,'created_at'=>date('Y-m-d H:i:s')]);
                        $address_id = $addresses->id;

                    }else{
                        $address_id = Address::whereAddress($address)->value('id');            
                    }  

                    if (Order::where('orderid',$orderid)->count()==0) 
                    {   
                        $orders_data = ['backup_id'=>$backup_id,'order_no'=>$order_no,'orderid'=>$orderid,'user_id'=>$api->user_id,'vendor_id'=>$vendor_id,'mobile_id'=>$mobile_id,'email_id'=>$email_id,'product_id'=>$product_id,'address_id'=>$address_id,'amount'=>$amount,'quantity'=>$quantity,'order_date'=>$order_date,'created_at'=>date('Y-m-d H:i:s')];
                        $orders = Order::create($orders_data);
                        $order_id = $orders->id;

                       if(Notification::whereUser_id($api->user_id)->value('is_ship')==1)
                       {
                            if (Shipment::whereOrder_id($order_id)->take(1)->count()==0) 
                            {
                                $shipment_data = ['user_id'=>$api->user_id,'order_id'=>$order_id,'waybill'=>$order_id,'created_at'=>date('Y-m-d H:i:s')];
                                Shipment::create($shipment_data);            
                            }
                       } 

                    }



               $wallet = Wallet::whereUser_id($api->user_id)->first();  
            
               if($wallet->amount>1.4 && !empty($order_id))
               {    
             
                    $data_Call = [
                                  'From' => $mobile,
                                  'CallerId' => '01141186210',
                                  'Url' => 'http://my.exotel.com/Exotel/exoml/start_voice/342397',
                                ];
                    $ivr_url = 'https://0d17a7e8f848e28d1cd3c5ae06afd84d5aef0bce8c02f6dd:f2b6a6948dc4b33bb1697ad1a61b86d3695fda01178e8468@api.exotel.com/v1/Accounts/trendydealsecommerce1/Calls/connect';
                    $ch = curl_init();
                          curl_setopt($ch, CURLOPT_URL, $ivr_url);
                          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                          curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data_Call));
                    $calling_response = curl_exec($ch);
                          curl_close($ch); // Close t
                    $xml = simplexml_load_string($calling_response);
                    $Sid = $xml->Call->Sid;
                    $DateCreated = $xml->Call->DateCreated;
                    $DateUpdated = $xml->Call->DateUpdated;
                    $To = $xml->Call->To;
                    $From = $xml->Call->From;
                    $Status = $xml->Call->Status;
                    $StartTime = $xml->Call->StartTime;
                    $Uri = $xml->Call->Uri;

                   if(!empty($Sid))
                   {
                    $call_array_response['user_id'] = $api->user_id;
                    $call_array_response['order_id'] = $order_id;
                    $call_array_response['Sid'] = (string) $Sid;
                    $call_array_response['From'] = (string) $To;
                    $call_array_response['To'] = (string) $mobile;
                    $call_array_response['Digit'] = 0;
                    $call_array_response['created_at'] = date('Y-m-d H:i:s');
                    $call_response = Callresponse::create($call_array_response);
                    $callresponse_id = $call_response->id;
                    $call_charge = Config('constants.CALL_TOTAL_CHARGE');
                    $wallet_latest_amount = $wallet->amount-$call_charge;
                    Orders_transaction::create(['user_id'=>$api->user_id,'callresponse_id'=>$callresponse_id,'order_id'=>$order_id,'amount'=>$call_charge,'created_at'=>date('Y-m-d H:i:s')]);
                    Wallet::whereUser_id($api->user_id)->update(['amount'=>$wallet_latest_amount]);
                }
                */           
            }   
           die(json_encode(['success'=>true],true));
         } else{
           die(json_encode(['success'=>false],true));
      }
    }

//------------------------------------------------- Jobs ----------------------------------------------------------------------


    public function apis_update(Request $request)
    {
        $response = DB::table('webhooks_apis')
        ->update(['api_key'=>Str::uuid(),'secret_key'=>Str::uuid(),'password'=>uniqid()]);
        return back()->with('success','Updated successful.');
    }



    public function apis_webhook_update(Request $request)
    {
        if($request->is_webhook==1)
        {
            $msg = 'Api Activated Succecssful.';
        }else{
            $msg = 'Api Inactivated Succecssful.';
        }    
        $response = DB::table('webhooks_apis')
        ->update(['is_webhook'=>$request->is_webhook]);
        return back()->with('success',$msg);
    }


    public function apis_active_update(Request $request)
    {
        if($request->is_active==1)
        {
            $msg = 'Api Activated Succecssful.';
        }else{
            $msg = 'Api Inactivated Succecssful.';
        }    

        $response = DB::table('webhooks_apis')
        ->update(['is_active'=>$request->is_active]);
        return back()->with('success',$msg);
    }


    

    public function apis_response(Request $request)
    {   
        $response = DB::table('webhooks_apis')->latest()->take(1)->first();
        return view('theme.api.api',['response'=>$response]);
    }


    public function webhook_create(Request $request)
    {   
        $get_response = file_get_contents('php://input');
        $input = json_decode($get_response,true);

        $response = DB::table('webhooks_apis')
        ->update(['webhook'=>$input['address'],'is_webhook'=>1]);
        die(json_encode(['success'=>true],true));
    }



}
