<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Helper;
use App\Models\Backup;

class CallController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function fetch_call_order1()
    {
         $all_result = Backup::join('shopify_products','backups.productId','=','shopify_products.productId')
                             ->join('shopify_product_images','shopify_products.id','=','shopify_product_images.product_id')
                             ->when(!empty(request()->get('custom_search')), function ($query) {
                                return $query->where('backups.order_no',request()->get('custom_search'))
                                             ->orWhere('backups.mobile',request()->get('custom_search'))
                                             ->orWhere('backups.email',request()->get('custom_search'));
                            })->when(empty(request()->get('daterange')), function ($query) {
                                return $query->whereDate('backups.order_date', date('Y-m-d'));
                            })
                            ->when(!empty(request()->get('daterange')), function ($query) {
                                $arr = Helper::DATERANGEARR(request()->daterange);
                                return $query->whereDate('backups.order_date', '>=', $arr[0])->whereDate('backups.order_date', '<=', $arr[1]);
                            })->select('backups.*','shopify_product_images.src')->paginate(10);   
        return view('theme.call.calling-form',['all_result'=>$all_result]);
    }

//------------------------------ fetch_single_shopify_orders 

    public function fetch_call_order(Request $request)
    {     $id = decrypt($request->segment(2));   
          $single_result = Backup::join('shopify_products','backups.productId','=','shopify_products.productId')
                             ->join('shopify_product_images','shopify_products.id','=','shopify_product_images.product_id')
                             ->join('shopify_product_variants','shopify_products.id','=','shopify_product_variants.product_id')
                             ->where('backups.id',$id)->select('backups.*','shopify_product_images.src','shopify_product_variants.title as count_quantity','shopify_product_variants.price as variant_price')->first(); 

         $all_pending_result = Backup::join('shopify_products','backups.productId','=','shopify_products.productId')
                             ->join('shopify_product_images','shopify_products.id','=','shopify_product_images.product_id')
                             ->join('shopify_product_variants','shopify_products.id','=','shopify_product_variants.product_id')
                             ->where('backups.id','!=',$id)
                             ->where('backups.mobile',$single_result->mobile)
                            ->select('backups.*','shopify_product_images.src','shopify_product_variants.title as count_quantity','shopify_product_variants.price as variant_price')->get(); 
        return view('theme.call.calling-form',['rows'=>$single_result,'all_pending_result'=>$all_pending_result]);
    }


}
