<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Models\Backup;
use App\Models\Collection;
use App\Models\Apiresponse;
use App\Models\Product;
use App\Models\Product_detail;
use App\Models\Product_image;
use App\Models\Product_json;
use App\Models\Shopify_product;
use App\Models\Shopify_product_variant;
use App\Models\Shopify_product_image;
use App\Models\Shopify_product_variant_image;
use Exception;
use Curl;

class CollectionController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {

        $result = Collection::whereUser_id(Auth::id())
                              ->latest()
                              ->paginate(16);
        return view('theme.inventory.collection.index',['response'=>$result]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Inventory / Add Collection']; 
        return view('theme.inventory.collection.add',['breadcrumbs'=>$breadcrumbs]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->submit=='Save' && $request->isMethod('post') && $request->has('submit'))
        {
            if($request->is_parent==0){
                $parent_id = 0;
            }else{
                $parent_id = $request->parent_id;
            }
            $request->validate(['name'=>'required']);
            $fillable_collection_data = ['parent_id' =>$parent_id,
                                         'user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                         'slug' =>Str::slug($request->name,'-'),
                                         'is_active'=>$request->is_active,
                                         'created_at'=>date('Y-m-d H:i:s')];
            Collection::create($fillable_collection_data);                             
            return redirect()->route('collection.index')->with('message','Collection Created Successful.');
        }else{
            return redirect()->route('collection.index')->with('error','Invalid Arguments!');
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        if($request->has('action') && $request->action==0)
        {
           Collection::where('id',$id)->update(['is_active'=>0]);
           return redirect()->route('collection.index')->with('error','Collection Inactivated Successful.');
        } if($request->has('action') && $request->action==1){
           Collection::where('id',$id)->update(['is_active'=>1]);
           return redirect()->route('collection.index')->with('success','Collection Activated Successful.');
        }
        $response = Collection::findOrFail($id);
        $breadcrumbs = ['home'=>'Dashboard','javascript:void(0)'=>'Inventory / Edit Collection']; 
        return view('theme.inventory.collection.edit',['breadcrumbs'=>$breadcrumbs,'rows'=>$response]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->submit=='Save' && $request->isMethod('put') && $request->has('submit'))
        {
            if(empty($request->is_parent)){
                $parent_id = 0;
            }else{
                $parent_id = $request->parent_id;
            }
            $request->validate(['name'=>'required']);
            $fillable_collection_data = ['parent_id' =>0,
                                         'user_id' =>Auth::id(),
                                         'name' =>$request->name,
                                         'slug' =>Str::slug($request->name,'-'),
                                         'is_active'=>$request->is_active,
                                         'updated_at'=>date('Y-m-d H:i:s')];
            Collection::whereId($id)->update($fillable_collection_data);                             
            return redirect()->route('collection.index')->with('message','Collection Saved Successful.');
        }else{
                return redirect()->route('collection.index')->with('error','Invalid Arguments!');
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Collection::where('id',$id)->delete();
        return redirect()->route('collection.index')->with('error','Collection Deleted Successful.');
    }
}
