<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\Product;
use App\Models\Collection;
use App\Models\Slider;
use App\Models\User;
use App\Models\Page;
use App\Models\Review;
use App\Models\Service;
use App\Models\Testimonial;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();
        $sliders = Slider::whereIs_active(1)->where('upload_type', 'slider')->latest()->first();
        $pages = Page::whereIs_active(1)->where('slug', 'about-us')->where('is_active',1)->first();
        $bottom_slider = Slider::whereIs_active(1)->where('upload_type', 'slider_bottom')->latest()->get();
        $footer_slider = Slider::whereIs_active(1)->where('upload_type', 'slider_footer')->latest()->get();
        $clients = Slider::whereIs_active(1)->where('upload_type', 'Client')->latest()->paginate(1000);

        $services = Service::whereIs_active(1)->latest()->paginate(6);
        $testimonial = Testimonial::whereIs_active(1)->where('is_active',1)->get();
        $slider_footer_top_3 = Slider::whereIs_active(1)->where('upload_type', 'slider_footer_top_3')->first();

        return view('storefront.home.home', ['pages'=>$pages,'services'=>$services,'clients' => $clients, 'users' => $users, 'collections' => $collections, 'sliders' => $sliders, 'bottom_slider' => $bottom_slider, 'footer_slider' => $footer_slider, 'testimonial' => $testimonial, 'slider_footer_top_3' => $slider_footer_top_3]);
    }
    //------------------------------------------------Search
    public function fetch_search_products(Request $request)
    {
        $result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
            ->select('products.*', 'product_details.image')
            ->where('products.name', 'LIKE', $_GET['searchkeyword'] . '%')
            ->where('products.is_active', 1)->offset(0)->limit(10)->inRandomOrder()->get();
        if (count($result) > 0) {
            return view('storefront.search.search', ['response' => $result]);
        } else {
            return redirect('/')->with('error', 'Data Not found.');
        }
    }


    //------------------------------------------------------    Ajax Load More-----------------
    public function ajax_load_more(Request $request)
    {
        $limit = $request->limit;
        $offset = $request->offset;
        if ($request->has('collections')) {
            $result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
                ->select('products.*', 'product_details.image')->where('products.is_active', 1)->offset($offset)->limit($limit)->inRandomOrder()->get();
            if (count($result) > 0) {
                return view('storefront.partials.ajax-load')->with(['response' => $result]);
            } else {
                die('');
            }
        } elseif ($request->has('q')) {

            $result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
                ->select('products.*', 'product_details.image')->where('products.is_active', 1)->offset($offset)->limit($limit)->inRandomOrder()->where('products', 'LIKE', '%$request->q%')->get();
            if (count($result) > 0) {
                return view('storefront.partials.ajax-load')->with(['response' => $result]);
            } else {
                die('');
            }

        } else {
            $result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
                ->select('products.*', 'product_details.image')->where('products.is_active', 1)->offset($offset)->limit($limit)->inRandomOrder()->get();
            if (count($result) > 0) {
                return view('storefront.partials.ajax-load')->with(['response' => $result]);
            } else {
                die('');
            }
        }
    }

    //--------------------------Products

    public function fetch_single_products(Request $request)
    {
        $collections = Collection::whereIs_active(1)->latest()->get();
        $users = User::take(1)->latest()->first();
        $recently_result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
            ->select('products.*', 'product_details.image')
            ->where('products.is_active', 1)
            ->offset(0)
            ->limit(10)
            ->inRandomOrder()->get();

        if ($request->segment(1) == 'products') {
            $slug = $request->segment(2);
            $result = Product::join('product_details', 'products.id', '=', 'product_details.product_id')
                ->select('products.*', 'product_details.sku', 'product_details.image', 'product_details.description', 'product_details.meta_title', 'product_details.meta_description', 'product_details.meta_keywords')->where('products.is_active', 1)->where('slug', $slug)->first();

            $reviews = Review::where('product_id', $result->id)->get();
            if (!is_null($result)) {
                if ($request->d == 1) {

                    return view('storefront.product.p', ['reviews' => $reviews, 'rows' => $result, 'collections' => $collections, 'users' => $users]);
                } else {
                    return view('storefront.product.product', ['reviews' => $reviews, 'recently_result' => $recently_result, 'rows' => $result, 'collections' => $collections, 'users' => $users]);
                }
            } else {
                abort(404, 'Not Found');
            }
        } else {
            abort(404, 'Not Found');
        }
    }
}