<?php

namespace App\Imports;
use Illuminate\Support\Facades\Auth;
use App\Models\Invoice;
use Maatwebsite\Excel\Concerns\ToModel;


class InvoiceImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        return new Invoice(['user_id'=>Auth::id(),
                                     'sold_by'=>$row[0],
                                     'sold_by_address'=>$row[1],
                                     'gst'=>trim($row[2]),
                                     'pan'=>trim($row[3]),
                                     'order_id'=>trim($row[4]),
                                     'order_date'=>date('Y-m-d',strtotime($row[5])),
                                     'invoice_number'=>trim($row[6]),
                                     'invoice_details'=>$row[7],
                                     'invoice_date'=>date('Y-m-d',strtotime($row[8])),
                                     'billing_customer'=>$row[9],
                                     'billing_address'=>$row[10],
                                     'billing_city'=>$row[11],
                                     'billing_state'=>$row[12],
                                     'billing_pincode'=>$row[13],
                                     'state_code'=>$row[14],
                                     'product'=>$row[15],
                                     'hsn'=>trim($row[16]),
                                     'quantity'=>trim($row[17]),
                                     'price'=>trim(str_replace(',','',$row[18])),
                                     'tax_rate'=>trim(str_replace(',','',$row[19])),
                                     'cgst'=>trim(str_replace(',','',$row[20])),
                                     'sgst'=>trim(str_replace(',','',$row[21])),
                                     'igst'=>trim(str_replace(',','',$row[22])),
                                     'tax_amount'=>trim(str_replace(',','',$row[23])),
                                     'total_amount'=>trim(str_replace(',','',$row[24])),
                                     'single_price'=>trim(str_replace(',','',$row[25])),
                                     'created_at'=>date('Y-m-d H:i:s')
                                    ]);
    }
    public function headingRow(): int
    {
        return 2;
    }
}
