<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouriersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('couriers', function (Blueprint $table) 
        {
            $table->id()->comment('AUTO_INC_ID');
            $table->foreignId('user_id')->comment('USER_LOGIN_ID');
            $table->foreign('user_id')->references('id')->on('users'); 
            $table->foreignId('warehouse_id');
            $table->foreign('warehouse_id')->references('id')->on('warehouses'); 
            $table->string('appid')->nullable()->comment('APP_ID');
            $table->string('sellerid')->nullable()->comment('SELLER_ID');
            $table->string('api')->nullable()->comment('API_PATH');
            $table->string('courier')->nullable()->comment('COURIER');
            $table->string('account_name')->nullable()->comment('COURIER_A/C_NAME');
            $table->string('token')->nullable()->comment('TOKEN');
            $table->string('username')->nullable()->comment('USERNAME');
            $table->string('password')->nullable()->comment('PASSWORD');
            $table->string('country_code',22)->nullable()->comment('COUNTRY_CODE');
            $table->string('entity',22)->nullable()->comment('ENTITY');
            $table->string('number',22)->nullable()->comment('BD_NUMBER');
            $table->string('customerid')->nullable()->comment('BD_CUSTOMER_ID');
            $table->integer('priority')->default(0)->comment('PRIORITY');
            $table->string('pin')->nullable()->comment('DB_PIN');
            $table->string('licencykey')->nullable()->comment('LICENCY_KEY');
            $table->string('vender_code')->nullable()->comment('BD_VENDOR_CODE');
            $table->string('sender')->nullable()->comment('BD_SENDER_NAME');
            $table->string('batchId')->nullable()->comment('BATCH_ID');
            $table->string('origin_area')->nullable()->comment('BD_ORIGIN_AREA');
            $table->string('customer_telephone')->nullable()->comment('CUSTOMER_TELEPHONE');
            $table->string('customer_pincode')->nullable()->comment('CUSTOMER_PINCODE');
            $table->string('customer_name')->nullable()->comment('CUSTOMER_NAME');
            $table->string('customer_mobile')->nullable()->comment('CUSTOMER_MOBILE');
            $table->string('customer_email')->nullable()->comment('customer_EMAIL');
            $table->string('customer_code')->nullable()->comment('CUSTOMER_CODE');
            $table->string('customer_address')->nullable()->comment('CUSTOMER_ADDRESS');
            $table->string('customer_address2')->nullable()->comment('CUSTOMER_ADDRESS_2');
            $table->string('customer_address3')->nullable()->comment('CUSTOMER_ADDRESS_3');
            $table->string('version',22)->nullable()->comment('VERSION');
            $table->string('CustomerGSTNumber')->nullable()->comment('CUSTOMER_GST_NUMBER');
            $table->tinyInteger('awb_type')->default(0)->comment('AWB_GENERATION_TYPE');
            $table->integer('air_mode')->default(0)->comment('AIR_MODE');
            $table->integer('surface_mode')->default(0)->comment('SURFACE_MODE');
            $table->integer('limit')->default(0)->comment('AWB_LIMIT');
            $table->tinyInteger('is_active')->default(0)->comment('CLIENT_CHECK_STATUS');
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'))->comment('CREATED_AT');
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'))->comment('UPDATED_AT');
            $table->index('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('couriers');
    }
}
