<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIntegrationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('integrations', function (Blueprint $table) 
        {
            $table->id();
            $table->foreignId('user_id');
            $table->foreign('user_id')->references('id')->on('users'); 
            $table->enum('api_type',['ORDER','PRODUCT'])->default('ORDER');
            $table->string('account_name')->unique();
            $table->string('api_key')->unique();
            $table->string('token')->unique();
            $table->string('secret')->unique();
            $table->string('account_password')->unique();
            $table->string('account_url')->unique();
            $table->string('api_name')->unique();
            $table->string('emergency_developer_email')->nullable();
            $table->string('store')->nullable();
            $table->boolean('is_active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('integrations');
    }
}
