<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBackupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('backups', function (Blueprint $table) {

            $table->bigIncrements('id');
            $table->foreignId('user_id');
            $table->foreign('user_id')->references('id')->on('users');             
            $table->foreignId('integration_id');
            $table->foreign('integration_id')->references('id')->on('integrations');             
            $table->string('vendor');
            $table->string('order_id')->unique();
            $table->string('order_no')->unique();
            $table->string('email');
            $table->string('mobile');
            $table->binary('name');
            $table->binary('address');
            $table->binary('city');
            $table->binary('state');
            $table->string('pincode');
            $table->string('payment_mode');
            $table->enum('pmode',['PREPAID','COD','N/A'])->default('N/A');
            $table->double('amount',10,2);
            $table->text('product');
            $table->integer('quantity');
            $table->string('variant_title');
            $table->tinyInteger('pcount');
            $table->timestamp('order_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->ipAddress('ip_address');
            $table->tinyInteger('is_move')->default(0);
            $table->tinyInteger('status')->default(0);
            $table->tinyInteger('is_call')->default(0);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
            $table->index('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('backups');
    }
}
