<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Tracking Details -  {{ config('app.name') }}</title>
        <meta name="og_title" property="og:title" content="Tracking Details - {{ config('app.name') }}" />
        <meta name="Description" property="og:description" content=" Tracking Details - {{ config('app.name') }}" />
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        <meta name="og_site_name" property="og:site_name" content="{{ config('app.name') }}" />
        <meta property="og:image" itemprop="image primaryImageOfPage" content="{{ asset('storefront/images/icon.png')}}" />
        <meta name="og:title" content="Online Shopping Site for Mobiles, Electronics, Books &amp; More. Best Offers!" />
        <link rel="icon" href="{{ asset('storefront/images/icon.png')}}" type="image/png" />
        <meta property="og:url" content="{{ url('/') }}" />
        <link rel="canonical" href="{{ url('/') }}" />
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="prefetch" as="style" onload="this.rel='stylesheet'" />
        <link rel="stylesheet" href="{{ asset('storefront/css/plugins.css')}}">
        <link rel="stylesheet" href="{{ asset('storefront/css/style.css')}}">
        <link rel="stylesheet" href="{{ asset('storefront/css/responsive.css')}}">    

<style>
/*------ Order Traking------*/

.Traking-Order {
  padding: 24px 0 35px 0;
  margin: 0;
  position: relative;
}

.Traking-Order:before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
}

.Traking-Order h2 {
  font-size: 15px;
  color: #000;
  font-weight: 500;
}

.Traking-Order h3 {
  font-size: 18px;
  color: #000;
  font-weight: 600;
  margin-bottom: 17px;
}

.Traking-Order h5 {
  font-size: 70px;
  color: #000;
  font-weight: 600;
  margin-bottom: 17px;
  text-align: left;
  padding-top: 90px;
  text-shadow: 0 0 13px BLACK;
}

.Traking-Order h4 {
  font-size: 19px;
  color: #000;
  font-weight: 600;
  line-height: 27px;
}

.Traking-Order p {
  font-size: 16px;
  color: #000;
  font-weight: 400;
  line-height: 27px;
}

.Traking-Order .trak-box {
  background: #ffffff3d;
  padding: 5px 20px 20px 20px;
  border-radius: 2px;
  box-shadow: 0 0 12px #000;
  border-top-left-radius: 20px;
  border-bottom-right-radius: 30px;
}

.Traking-Order .trak-box .input-trak {
  border: 1px solid #d8d8d8;
  padding: 29px 11px;
  border-radius: 0;
  width: 100%;
}

.Traking-Order .trak-box .submit {
  padding: 15px 11px;
  border-radius: 0;
  width: 100%;
  background: #d62327;
  color: #FFF;
  height: 50px;
}

.Traking-Order .trak-box .content-box {
  padding: 7px 12px;
  margin: 0;
  background: #ffffff4d;
  border-bottom-right-radius: 20px;
}

/*-----Shipment-traking----*/

.shipment-traking {
  padding: 24px 0 35px 0;
  margin: 0;
  position: relative;
}

.shipment-traking h2 {
  font-size: 15px;
  color: #000;
  font-weight: 500;
}

.shipment-traking .rowshow {
  border-bottom: 1px solid #e7e4e4;
}

.shipment-traking .row-001 {
  margin-top: 10px;
  border-bottom: 1px solid #e7e4e4;
  padding-bottom: 13px;
}

.shipment-traking .row004 {
  border-bottom: 1px solid #e7e4e4;
  padding-bottom: 4px;
  margin-bottom: 11px;
}

.shipment-traking .logo-top-obsessions {
  width: 26%;
  margin-bottom: 10px;
}

.shipment-traking .lineheight {
  line-height: 40px;
  font-size: 13px;
}

.shipment-traking .share-button {
  width: 40px;
  height: 40px;
  border-radius: 24px;
  background: linear-gradient(to top left, #0000cc 0%, #037aff 100%);
  color: #fff;
  text-transform: uppercase;
  border-style: none;
  float: right;
  margin-bottom: 12px;
  font-size: 19px;
  font-weight: 600;
  letter-spacing: 0px;
}

.shipment-traking .share-button:hover {
  background: #a29898;
}

.shipment-traking .i-fa {
  margin-right: 6px;
}

.shipment-traking p {
  color: #333333;
  font-weight: 500;
  font-size: 14px;
  font-family: Roboto, sans-serif;
}

.shipment-traking .pro-box {
  padding: 7px;
  box-shadow: 0 0 2px #000;
  border-radius: 6px;
}

.shipment-traking .pro-box img {
  width: 100%;
  border-radius: 10px;
  height: auto;
  max-height: 98px;
}

.shipment-traking .content-box-id {
  padding: 13px 0 0 0;
}

.shipment-traking .content-box-id p {
  margin-bottom: 6px;
  font-size: 12px;
}

.shipment-traking .content-box-id .trak-id {
  color: #a1a1a1;
  margin: 0;
}

.shipment-traking .timeline-card {
  padding: 16px 8px;
  margin: 0;
  font-family: Roboto, sans-serif;
  border-bottom: 1px solid #e7e4e4;
}

.shipment-traking .timeline-card ul.vertical-timeline {
  list-style: none;
  margin: 0;
  padding-left: 15px;
}

.shipment-traking .timeline-card ul.vertical-timeline li {
  padding-bottom: 25px;
  padding-left: 25px;
  position: relative;
}

.shipment-traking .timeline-card ul.vertical-timeline li.exchange {
  padding: 0 0 25px 25px;
}

.shipment-traking .timeline-card ul.vertical-timeline li.exchange:last-child {
  padding-bottom: 0;
}

.shipment-traking .timeline-card ul.vertical-timeline li:first-child:before {
  top: 10px;
}

.shipment-traking .timeline-card ul.vertical-timeline li:last-child:before {
  height: 5px;
}

.shipment-traking .timeline-card ul.vertical-timeline li:before {
  content: "";
  width: 1px;
  height: 100%;
  left: -1px;
  top: 6%;
  position: absolute;
  border-left: 1px dashed #8c8c8c;
}

.shipment-traking .timeline-card ul.vertical-timeline li.active:before {
  border-left: 1px dashed #20c591;
}

.shipment-traking .timeline-card ul.vertical-timeline li.active.failed-timeline:before {
  border-left-color: #f98178;
}

.shipment-traking .timeline-card ul.vertical-timeline li.active.returned:before {
  border-left: 1px dashed #20c591;
}

.shipment-traking .timeline-card ul.vertical-timeline li .circle {
  width: 16px;
  height: 16px;
  background-color: #fff;
  border: 1px solid #8c8c8c;
  border-radius: 100%;
  position: absolute;
  left: -9px;
  top: 4px;
}

.shipment-traking .timeline-card ul.vertical-timeline li .onTheWay {
  width: 32px;
  height: 32px;
  position: absolute;
  left: -17px;
  background-image: url("../images/arrow-circle.svg");
}

.shipment-traking .timeline-card ul.vertical-timeline li .onTheWay.exchange {
  width: 20px;
  height: 20px;
  background-position: 50%;
  border-radius: 50%;
  left: -11px;
}

.shipment-traking .timeline-card ul.vertical-timeline li .returned {
  position: absolute;
  background-image: url("../images/arrow-circle.svg");
}

.shipment-traking .timeline-card ul.vertical-timeline li .status-title {
  font-size: 16px;
  line-height: 24px;
  font-family: Roboto, sans-serif;
}

.shipment-traking .timeline-card ul.vertical-timeline li .status-title.bold {
  font-weight: 600;
  font-family: Roboto, sans-serif;
}

.shipment-traking .timeline-card ul.vertical-timeline li .label {
  color: #8c8c8c;
  font-size: 14px;
  line-height: 5px;
  font-family: Roboto, sans-serif;
  font-weight: 300;
  display: flex;
  padding-left: 0;
}

.shipment-traking .timeline-card ul.vertical-timeline li .show-all {
  font-family: Roboto, sans-serif;
  text-transform: uppercase;
  font-size: 12px;
  line-height: 1.67;
  color: #d62327;
  cursor: pointer;
}

.shipment-traking .timeline-card ul.vertical-timeline li:last-child {
  padding-bottom: 0;
}

.shipment-traking .address-card {
  color: #404040;
  font-size: 12px;
  padding: 16px 16px 8px;
  line-height: 20px;
}

.shipment-traking .timeline-statuses {
  padding: 10px 0 0;
}

.shipment-traking .timeline {
  -webkit-transition: all .2s ease-in-out;
  color: #404040;
  max-height: 300px;
  min-height: 50px;
  overflow-x: hidden;
  overflow-y: auto;
  position: relative;
  transition: all .2s ease-in-out;
  font-family: roboto;
  font-size: 12px;
  text-align: left
}

.shipment-traking .timeline .date-list {
  margin-bottom: 40px;
}

.shipment-traking .timeline .date-list .date-label {
  margin-bottom: 16px;
  margin-left: 6px;
  font-size: 14px;
  line-height: 22px;
}

.shipment-traking .timeline .date-list:last-child {
  margin-bottom: 0
}

.shipment-traking .timeline .date-list ul.date {
  color: #4a4a4a;
  list-style: none;
  margin: 0;
  padding-left: 50px;
}

.shipment-traking .timeline .date-list ul.date li {
  border-left: 1px solid #d9d9d9;
  padding-left: 16px;
  position: relative;
  margin-left: 16px;
  margin-bottom: 16px;
}

.shipment-traking .timeline .date-list ul.date li .location,
.compact-theme .timeline .date-list ul.date li .remark,
.compact-theme .shipment-traking .timeline .date-list ul.date li .time {
  display: block;
  line-height: 20px;
}

.shipment-traking .timeline .date-list ul.date li .time {
  text-align: right;
  position: absolute;
  left: -76px;
  width: 60px;
  -webkit-transform: translateY(-50%);
  transform: translateY(-50%);
  top: 50%;
}

</style>


</head>
    <body class="template-index index-demo1">
    <div class="page-wrapper">
    @include('storefront.partials.header')
    <div id="page-content">

<section class="Traking-Order">
        <div class="container">
            <div class="row">
                <div class="col-md-6" style="margin:auto;float: none;">
                    <div class="trak-box">
                        <h4>Track Order</h4>
                        <form method="get" action="{{ Route('trackdata') }}">
                            
                        <p><input type="text" placeholder="Enter Mobile *" required name="trackingId" class="input-trak form-control"> </p>
                        <p> <button type="submit" class="btn btn-defalt submit"> TRACK YOUR ORDER </button> </p>
                        </form>

                        @if(count($response)>0 && !is_null($response[0]->name))

                        <div class="content-box">
                            @foreach($response as $rows)


                                <h3> Customer Details </h3>
                                <p>Name : {{$rows->name}} </p>
                                <p>Order No: {{$rows->order_no}} </p>
                                <p>Order Date:  {{date('d M, Y',strtotime($rows->order_date))}} </p>

                                <p>Courier: {{$rows->courier}} </p>
                                <p>Tracking no:  {{$rows->tracking_no}} </p>

                                @if($rows->pending_amount>0)
                                <p>Pending Amount:  {{$rows->pending_amount}} </p>
                                @endif
                            @endforeach    
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>

     </div>   
    @include('storefront.partials.footer')
     <!-- Including Jquery -->
     <script src="{{ asset('storefront/js/vendor/jquery-min.js')}}"></script>
     <script src="{{ asset('storefront/js/vendor/js.cookie.js')}}"></script>
     <!--Including Javascript-->
     <script src="{{ asset('storefront/js/plugins.js')}}"></script>
     <script src="{{ asset('storefront/js/main.js')}}"></script>
    </body>
</html>
