<!DOCTYPE html>
<html class="no-js" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="x-ua-compatible" content="ie=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="shortcut icon" href="{{ $rows->image }}" />
<title>{{ $rows->name }} Online at Best Price On {{ config('app.name') }}</title>
<meta name="Keywords" content="Buy {{ $rows->name }}" />
<meta name="Description" property="description" content=" {{ $rows->name }} performance to shop at {{ config('app.name') }}" />
<meta name="og:title" property="og:title" content="{{ $rows->name }} Online at Best Price on {{ config('app.name') }}" />
<meta property="og:image" content="{{ $rows->image }}" />
<meta name="Description" property="og:description" content=" {{ $rows->name }} performance to shop at {{ config('app.name') }}" />
<meta name="csrf-token" content="{{ csrf_token() }}" />
<link rel="stylesheet" href="{{ asset('css/plugins.css')}}">
<link rel="stylesheet" href="{{ asset('css/style.css')}}">
<link rel="stylesheet" href="{{ asset('css/responsive.css')}}">
</head>
<body class="template-index index-demo1">
<div class="page-wrapper">
    @include('storefront.partials.header2')
    @php
        $product_images = App\Models\Product_image::where('product_id',$rows->id)->get();
     @endphp   
    <div id="page-content">
        <div class="breadcrumbs-wrapper">
        	<div class="container">
            	<div class="breadcrumbs"><a href="{{ url('/') }}" title="Back to the home page">Home</a> <span aria-hidden="true">|</span> <span>{{$rows->name }} </span></div>
            </div>
        </div>
        <!--End Breadcrumbs-->
        <div class="container">
            <div class="product-detail-container">
				<div class="product-single">
					<div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                <div class="product-details-img">
                                    <div class="product-thumb">
                                        <div id="gallery" class="product-dec-slider-2 product-tab-left">
                                            @foreach ($product_images as $key=>$img)
                                            <a data-image="{{$img->mainimage }}" data-zoom-image="{{$img->mainimage }}" class="slick-slide" data-slick-index="1" aria-hidden="true" tabindex="-1">
                                                <img class="blur-up lazyload" data-src="{{$img->mainimage }}" src="{{$img->mainimage }}" alt="{{$rows->name }}" />
                                            </a>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="zoompro-wrap product-zoom-right pl-20">
                                        <div class="zoompro-span">
                                            <img id="zoompro" class="zoompro" src="{{$product_images[0]->mainimage }}" data-zoom-image="{{$product_images[0]->mainimage }}" alt="{{$rows->name }}" />
                                        </div>
                                        <div class="product-buttons">
                                            <a href="#" class="btn prlightbox" title="Zoom">
												<i class="icon anm anm-expand-l-arrows" aria-hidden="true"></i>
												<span class="tooltip-label">Zoom Image</span>
											</a>
                                        </div>
                                    </div>
                                    <div class="lightboximages">
                                        @foreach ($product_images as $key=>$img)
                                            <a href="{{$img->mainimage }}" data-size="1000x1280"></a>
                                        @endforeach    
                                    </div>
                                </div>
                            </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="product-single__meta">
                                <h1 class="product-single__title">{{$rows->name }}</h1>
                                <div class="prInfoRow">
                                    <div class="product-review"><span><span style="font-size: 13px;background-color: #086608;color: #fff;" class="in_stock badge badge-success" style="background-color:green !important;color: #fff;">4.{{ rand(1,5) }} <i class="fa fa-star text-white" style="font-size:13px;"></i></span> ({{ rand(111,999) }} Ratings & {{ rand(444,999)}} Reviews)</span></div>
                                    <div class="product-sku">SKU: <span class="variant-sku">{{$rows->sku }}</span></div>
                                    <div class="product-stock"> <span class="instock ">In Stock</span> <span class="outstock hide">Unavailable</span> </div>
                                </div>
                                <p class="product-single__price product-single__price-product-template">
                                    <span class="visually-hidden">Regular price</span>
                                    <s id="ComparePrice-product-template"><span class="money"><i class="fa fa-inr"></i>{{ number_format($rows->actual_price,0) }}</span></s>
                                    <span class="product-price__price product-price__price-product-template product-price__sale product-price__sale--single">
                                        <span id="ProductPrice-product-template"><span class="money"><i class="fa fa-inr"></i>{{ number_format($rows->prepaid_amount,0) }}</span></span></span>
                                    </span>
                                    <span class="discount-badge"> <span class="devider">|</span>&nbsp;
                                        <span>You Save</span>
                                        <span class="product-single__save-amount"><span class="money">{{ number_format((($rows->prepaid_amount/$rows->actual_price)*100),0) }}% off</span></span>
                                    </span>  
                                </p>
                            </div>
                            <hr>
                            <div class="userViewMsg" data-user="20" data-time="11000">
                                <i class="fa fa-users" aria-hidden="true"></i> <strong class="uersView">14</strong> People are Looking for this Product
                            </div>

                            <div id="quantity_message">EASY PAYMENT OPTIONS</div>
                            <form method="POST" action="{{ route('store.add-to-cart',$rows->id) }}" id="add-to-cart">
                                @csrf                            
                                <div class="product-single__description rte">
                                        @if($rows->prepaid_amount>0 && $rows->is_prepaid==1)
                                            <div class="cardSection addonOffer">
                                                <label for="EMIoption4">                                                
                                                    <span>
                                                        <h4>
                                                            <input name="EasyPaymentOptGroup" id="EMIoption4" data-id="3" data-ptype="3" value="PREPAID" required="required" type="radio" checked="checked" /> <img src="{{asset('images/A-EasyPaymentOptionImage-69-A8kIa.SVG')}}" class="img-responsive" alt="Special Offer" /> Special Offer <span></span>
                                                        </h4>
                                                        <div class="addressDetails">
                                                            <p>Get Additional Discount up to Rs.{{$rows->selling_price-$rows->prepaid_amount}}/- on Debit / Credit Card / UPI / Net Banking</p>
                                                            <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->prepaid_amount,0) }}</p>
                                                        </div>
                                                    </span>
                                                </label>
                                            </div>
                                            @endif
                                            @if($rows->token_amount>0 && $rows->is_partial==1)
                                            <div class="cardSection addonOffer">
                                                <label for="EMIoption2">
                                                    
                                                    <span>
                                                        <h4><input name="EasyPaymentOptGroup" id="EMIoption2" data-id="2" data-ptype="2" value="TOKEN" required="required" type="radio" checked="checked" />
                                                            Book Now @ <i class="fa fa-inr"></i> {{ number_format($rows->token_amount,0) }} <span><img src="{{asset('images/A-EasyPaymentOptionImage-69-1tkhw.SVG')}}" class="img-responsive" alt="Book Now" /></span>
                                                        </h4>
                                                        <div class="addressDetails">
                                                            <p>Pay rest amount on delivery<!-- &amp; Save up to Rs. {{ number_format($rows->selling_price-$rows->partial_amount,0) }}/---></p>
                                                            <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->partial_amount,0) }}</p>
                                                        </div>
                                                    </span>
                                                </label>
                                            </div>
                                            @endif
                                            @if($rows->cod_amount>0 && $rows->is_cod==1)
                                            <div class="cardSection addonOffer">
                                                <label for="EMIoption1">
                                                    
                                                    <h4>
                                                    <input name="EasyPaymentOptGroup" id="EMIoption1" value="COD" data-id="1" data-ptype="1" required="required" type="radio" checked="checked" /> <img src="{{asset('images/A-EasyPaymentOptionImage-69-a6fXs.SVG')}}" class="img-responsive" alt="Cash On Delivery" /> Cash On Delivery <span></span>
                                                    </h4>
                                                    <span>

                                                        <div class="addressDetails">
                                                            <p>Pay On Delivery is available. Delivery is available across all major Pin Code.</p>
                                                            <p class="price"><i class="fa fa-inr"></i> {{ number_format($rows->cod_amount,0) }}</p>
                                                        </div>
                                                    </span>
                                                </label>
                                            </div>
                                            @endif
                                </div>
                                <!-- Product Action -->
                                <div class="product-action clearfix">

                                    <div class="buy-it-btn">
                                        <button type="submit" class="btn"><i class="fa fa-bolt"></i> Buy it now</button>
                                    </div>
                                    @if(!is_null($rows->whatsapp))
                                    <div class="buy-it-btn">
                                        <a href="https://wa.me/91{{$rows->whatsapp}}?text={{url()->full()}}" class="btn btn-success" style="background:green;"><i class="fa fa-whatsapp"></i> {{$rows->btnName}}</a>
                                    </div>
                                    @endif

                                </div>
                                <!-- End Product Action -->
                            </form>
                        </div>
                    </div>
				</div>
			</div>
            <!--Product Tabs-->
            <div class="tabs-listing">
                <div class="tab-container">
                    <div id="tab1" class="tab-content">
                        <div class="product-description rte">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-md-8 col-lg-8 mb-4">
                                    <h3>Specification</h3>
                                    {!! $rows->description !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 mb-4 d-none">
                                <div class="spr-form clearfix">
                                    <form method="post" action="#" id="new-review-form" class="new-review-form">
                                        <h3 class="spr-form-title">Write Your Own Review</h3>
                                        <fieldset class="spr-form-contact">
                                            <div class="spr-form-review-rating">
                                                <label class="spr-form-label">How do you rate this product?<span class="required">*</span></label>
                                                <div class="spr-form-input spr-starrating">
                                                  <div class="product-review"><a class="reviewLink" href="#"><i class="fa fa-star-o"></i><i class="font-13 fa fa-star-o"></i><i class="font-13 fa fa-star-o"></i><i class="font-13 fa fa-star-o"></i><i class="font-13 fa fa-star-o"></i></a></div>
                                                </div>
                                            </div>
                                            <div class="spr-form-contact-name">
                                              <label class="spr-form-label" for="nickname">What's your nickname?<span class="required">*</span></label>
                                              <input class="spr-form-input spr-form-input-text" type="text" id="nickname" name="nickname" value="">
                                            </div>
                                            <div class="spr-form-contact-email">
                                              <label class="spr-form-label" for="email">Email Address<span class="required">*</span></label>
                                              <input class="spr-form-input spr-form-input-email " id="email" type="email" name="email" value="">
                                            </div>
                                        </fieldset>
                                        <fieldset class="spr-form-review">
                                          <div class="spr-form-review-title">
                                            <label class="spr-form-label" for="review">Review Title</label>
                                            <input class="spr-form-input spr-form-input-text " id="review" type="text" name="review" value="">
                                          </div>

                                          <div class="spr-form-review-body">
                                            <label class="spr-form-label" for="message">Body of Review <span class="spr-form-review-body-charactersremaining">(1500) characters remaining</span></label>
                                            <div class="spr-form-input">
                                              <textarea class="spr-form-input spr-form-input-textarea " id="message" name="message" rows="5"></textarea>
                                            </div>
                                          </div>
                                        </fieldset>
                                        <div class="spr-form-actions">
                                            <input type="submit" class="spr-button spr-button-primary button button-primary btn btn-primary" value="Submit Review">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            @if(!is_null($reviews))
                            <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                                <div class="spr-reviews">
                                    <h3 class="spr-form-title">Customer Reviews</h3>
                                    <div class="review-inner">
                                @foreach($reviews as $rkey=>$r_rows)        
                                    <div class="spr-review">
                                        <div class="spr-review-header">
                                            <span class="product-review spr-starratings spr-review-header-starratings">
                                                <span class="reviewLink">
                                                    @if($r_rows->star==1)
                                                    <i class="fa fa-star"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>

                                                    @elseif($r_rows->star==2)
                                                    <i class="fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>

                                                    @elseif($r_rows->star==3)
                                                    <i class="fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star-o"></i>
                                                    <i class="font-13 fa fa-star-o"></i>

                                                    @elseif($r_rows->star==4)
                                                    <i class="fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star-o"></i>

                                                    @else
                                                    <i class="fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>
                                                    <i class="font-13 fa fa-star"></i>


                                                    @endif                
                                                </span>
                                            </span>
                                            <h3 class="spr-review-header-title">{!! $r_rows->heading !!}</h3>
                                            <span class="spr-review-header-byline"><strong>{!! $r_rows->name !!}</strong> on <strong>{!! $r_rows->review_datetime !!}</strong></span>
                                        </div>
                                        <div class="spr-review-content">
                                            <p class="spr-review-content-body">{!! $r_rows->description !!}.</p>
                                        </div>
                                    </div>
                                @endforeach    
     
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                </div>
            </div>
            <!--End Product Tabs-->
            
            <!--Related Product Slider-->
            <div class="related-product grid-products">
                <div class="section-header">
                    <h2 class="section-header__title text-center h2"><span>Related Products</span></h2>
                    <p class="sub-heading">You can stop autoplay, increase/decrease aniamtion speed and number of grid to show and products from store admin.</p>
                </div>
                <div class="productPageSlider">
                    @foreach($recently_result as $key=>$recent_rows)
                        <div class="col-12 item">
                            <!-- start product image -->
                            <div class="product-image">
                                <!-- start product image -->
                                <a href="{{ route('store.fetch-single-pro',$recent_rows->slug) }}" target="_blank" class="product-img">
                                    <!-- image -->
                                    <img class="primary blur-up lazyload" data-src="{{ $recent_rows->image }}" src="{{ $recent_rows->image }}" alt="{{ $recent_rows->name }}" title="{{ $recent_rows->name }}">
                                    <!-- End image -->
                                    <!-- Hover image -->
                                    <img class="hover blur-up lazyload" data-src="{{ $recent_rows->image }}" src="{{ $recent_rows->image }}" alt="{{ $recent_rows->name }}" title="{{ $recent_rows->name }}">
                                    <!-- End hover image -->
                                    <!-- product label -->
                                    <!-- End product label -->
                                </a>
                                <!-- end product image -->
                            </div>
                            <!-- end product image -->
                            <!--start product details -->
                            <div class="product-details text-center">
                                <!-- product name -->
                                <div class="product-name">
                                    <a href="{{ route('store.fetch-single-pro',$recent_rows->slug) }}">{{ $recent_rows->name }}</a>
                                </div>
                                <!-- End product name -->
                                <!-- product price -->
                                <div class="product-price">
                                    <p class="product-price grid-view-item__meta">
                                        <span class="old-price"><i class="fa fa-inr"></i>{{ number_format($recent_rows->actual_price,0) }}/-</span>
                                        <span class="product-price__price product-price__sale"><span class="money"><i class="fa fa-inr"></i>{{ number_format($recent_rows->prepaid_amount,0) }}</span></span></span>
                                    </p>
                                </div>
                                <!-- End product price -->

                                <div class="product-review">
                                    <span>
                                    <span style="font-size: 11px; background-color: #086608; color: #fff;" class="in_stock badge badge-success">4.{{ rand(1,5) }} <i class="fa fa-star text-white" style="font-size: 11px;"></i></span> ({{ rand(111,999) }} Ratings & {{ rand(444,999)}} Reviews)</span>
                                </div>
                            </div>
                            <!-- End product details -->
                        </div>
                    @endforeach
                </div>
            </div>
            <!--End Related Product Slider-->
        </div><!--End Body Container-->
    </div><!--End Page Wrapper-->
    
    @include('storefront.partials.footer')
        <!--Sticky Cart-->
        <div class="stickyCart d-none">
        <div class="container">
            <form method="post" action="{{ route('store.add-to-cart',$rows->id) }}" id="sticky-cart">
            @csrf   
                <div class="img"><img src="{{$product_images[0]->mainimage }}" class="product-featured-img" alt=""></div>
                <div class="sticky-title">{{$rows->name }}</div>
                <div class="stickyOptions">
                @if($rows->prepaid_amount>0 && $rows->is_prepaid==1)
                    <div class="selectedOpt"><input name="EasyPaymentOptGroup" id="EMIoption4" data-id="3" data-ptype="3" value="PREPAID" required="required" type="radio" checked="checked" /> Special Offer <span class="money"><i class="fa fa-inr"></i> {{ number_format($rows->prepaid_amount,0) }}</span></div>
                @endif    
                    <ul>
                        <li class="vrOpt">Red / S - <span class="money">Rs. 35,643.51</span></li>
                        <li class="soldout">Blue / S - Sold out</li><li class="vrOpt">Black / S - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Pink / S - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Red / M - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Blue / M - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Pink / M - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Red / L - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Blue / L - <span class="money">Rs. 35,643.51</span></li>
                        <li class="vrOpt">Black / L - <span class="money">Rs. 35,643.51</span></li>
                    </ul>
                </div>
                <select name="id" id="variantOptions1" class="product-form__variants selectbox no-js">
                @if($rows->prepaid_amount>0 && $rows->is_prepaid==1)
                    <option value="PREPAID" selected="selected">Special Offer</option>
                @endif    
                    <option disabled="disabled">Blue / S - Sold out</option>
                    <option>Black / S</option>
                    <option>Pink / S</option>
                    <option>Red / M</option>
                    <option>Blue / M</option>
                    <option>Pink / M</option>
                    <option>Red / L</option>
                    <option>Blue / L</option>
                    <option>Black / L</option>
                </select>
                <button type="submit" name="add" class="btn product-form__cart-submit"><span>Quick Buy</span></button>
            </form>
        </div>
    </div>
    <!--End Sticky Cart-->

     <!-- Including Jquery -->
     <script src="{{ asset('js/vendor/jquery-min.js')}}"></script>
     <script src="{{ asset('js/vendor/js.cookie.js')}}"></script>
     <!--Including Javascript-->
     <script src="{{ asset('js/plugins.js')}}"></script>
     <script src="{{ asset('js/main.js')}}"></script>
	<!-- Photoswipe Gallery -->
    <script src="{{ asset('js/vendor/photoswipe.min.js')}}"></script>
	<script>
        $(function(){
            var $pswp = $('.pswp')[0],
                image = [],
                getItems = function() {
                    var items = [];
                    $('.lightboximages a').each(function() {
                        var $href   = $(this).attr('href'),
                            $size   = $(this).data('size').split('x'),
                            item = {
                                src : $href,
                                w: $size[0],
                                h: $size[1]
                            }
                            items.push(item);
                    });
                    return items;
                }
            var items = getItems();
        
            $.each(items, function(index, value) {
                image[index]     = new Image();
                image[index].src = value['src'];
            });
            $('.prlightbox').on('click', function (event) {
                event.preventDefault();
              
                var $index = $(".active-thumb").parent().attr('data-slick-index');
                $index++;
                $index = $index-1;
        
                var options = {
                    index: $index,
                    bgOpacity: 0.9,
                    showHideOpacity: true
                }
                var lightBox = new PhotoSwipe($pswp, PhotoSwipeUI_Default, items, options);
                lightBox.init();
            });
        });
        </script>
    <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="pswp__bg"></div>
        <div class="pswp__scroll-wrap">
            <div class="pswp__container">
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
            </div>
        <div class="pswp__ui pswp__ui--hidden">
            <div class="pswp__top-bar">
                <div class="pswp__counter"></div>
                <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
                <button class="pswp__button pswp__button--share" title="Share"></button>
                <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
                <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
                <div class="pswp__preloader">
                    <div class="pswp__preloader__icn">
                        <div class="pswp__preloader__cut">
                            <div class="pswp__preloader__donut"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                <div class="pswp__share-tooltip"></div>
            </div>
            <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button>
            <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>
            <div class="pswp__caption"><div class="pswp__caption__center"></div></div>
        </div>
     </div>
  </div>

    </body>
</html>