@extends('theme.layouts.app') 
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Home">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);" title="Settings">Settings</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="API">API</a></li>
                        </ol>
                    </div>
                    <h4 class="page-title">Web API</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border">
                                API Details
                            </legend>
                            <form action="{{ route('api.update') }}" method="post" class="parsley-examples" data-parsley-validate validate>
                                @csrf
                                <div class="row">
                                    <div class="col-lg-5">
                                        <div class="form-group">
                                            <label for="account_name">Account Name <span class="text-danger">*</span></label>
                                            <input type="text" name="account_name" value="{{ Config('app.name') }}" required class="form-control" id="name" />
                                        </div>
                                        <div class="form-group">
                                            <label for="api_key">Account api Key<span class="text-danger">*</span></label>
                                            <input type="text" name="api_key" value="{{ $response->api_key }}" required class="form-control" />
                                        </div>
                                        <div class="form-group">
                                            <label for="password">Account Password<span class="text-danger">*</span></label>
                                            <input id="password" value="{{ $response->password }}" name="password" type="text" required class="form-control" />
                                        </div>
                                        <div class="form-group">
                                            <label for="secret_key">Secret Key<span class="text-danger">*</span></label>
                                            <input id="secret_key" value="{{ $response->secret_key }}" name="secret_key" type="text" required class="form-control" />
                                        </div>
                                    </div>
                                    <div class="col-lg-7">
                                        <div class="form-group">
                                            <label for="pan">API URL<span class="text-danger">*</span></label>
                                            <input name="service_api" required rows="9" class="form-control" id="address" value="{{ url('/') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="pan">Webhook URL<span class="text-danger">*</span></label>
                                            <div class="input-group mb-3">

                                              <input type="text" disabled="disabled" class="form-control" value="{{ $response->webhook  }}" aria-describedby="basic-addon2">
                                              <div class="input-group-append">
                                                @if($response->is_webhook==1)
                                                <a href="{{ route('api.webhook',['is_webhook'=>0]) }}" onclick="return confirm('Do you want to Inactive Webhook?');" id="basic-addon2" class="btn btn-success waves-effect">
                                                    Active
                                                </a>
                                                @else
                                                <a href="{{ route('api.webhook',['is_webhook'=>1]) }}" onclick="return confirm('Do you want to Active Webhook?');" id="basic-addon2" class="btn btn-danger waves-effect">
                                                    Inactive
                                                </a>
                                                @endif
                                              </div>
                                            </div>                                        
                                        </div>

                                        <div class="form-group text-right mb-0">
                                            <button class="btn btn-primary waves-effect waves-light mr-1" onclick="return confirm('Do you want to Re-generate Keys?');" type="submit" name="submit" value="Save">
                                                Generate Key
                                            </button>

                                            @if($response->is_active==1)
                                            <a href="{{ route('api.action',['is_active'=>0]) }}" onclick="return confirm('Do you want to Inactive?');" class="btn btn-success waves-effect">
                                                Active
                                            </a>
                                            @else
                                            <a href="{{ route('api.action',['is_active'=>1]) }}" onclick="return confirm('Do you want to Active?');" class="btn btn-danger waves-effect">
                                                Inactive
                                            </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </div>
    <!-- end container-fluid -->
</div>
@endsection
