@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                      <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="javascript:void(0);" title="Settings">Settings</a></li>
                        <li class="breadcrumb-item active"><a href="{{ route('courier') }}" title="Courier">Courier</a></li>
                      </ol>
                    </div>
                    <h4 class="page-title">Courier</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card-box" style="padding: 0.5rem;">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="custom-control custom-control-inline custom-switch mt-1 ml-2">
                                    <input type="checkbox" value="1" @if(App\Models\Notification::whereUser_id(Auth::id())->whereIs_ship(1)->value('is_ship')==1){{ 'checked' }} @endif onclick="getval()" class="custom-control-input" id="is_ship" style="font-size: 20px;" />
                                    <label class="custom-control-label" for="is_ship">Auto Shipping</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="text-lg-right mt-3 mt-lg-0">
                                    <a href="{{ route('servicable.index') }}" title="Manage Pincode" class="btn btn-success btn-sm mr-1"><i class="fa fa-map-marker"></i> Manage Pincode</a>
                                    <a href="{{ route('warehouse.index') }}" title="Manage Warehouse" class="btn btn-primary btn-sm mr-1"><i class="fa fa-bank"></i> Manage Warehouse</a>
                                </div>
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row -->
                    </div>
                    <!-- end card-box -->
                </div>
                <!-- end col-->
            </div>
            @if(App\Models\Courier::select('courier')->whereUser_id(Auth::id())->whereIs_active(1)->count()>0)
                      <fieldset class="scheduler-border">
                        <legend class="scheduler-border"><i class="fa fa-arrows"></i> DRAG TO SET YOUR PRIORITY</legend>
            <!-- end page title -->
            <div class="row" id="sortable" class="connectedSortable">


               @foreach(App\Models\Courier::select('courier')->whereUser_id(Auth::id())->whereIs_active(1)->distinct()->orderBy('priority','Asc')->get() as $key=>$rows) 
                <div class="col-lg-6 col-xl-3" id="bluedart">
                     <input type="hidden" class="courier_id" name="courier_id" value="{{ strtolower($rows->courier) }}" />
                    <div class="card-box bg-pattern">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('bluedart.index') }}" title="strtolower($rows->courier)"> <img src="{{ asset('courier/'.strtolower($rows->courier)) }}.png" alt="strtolower($rows->courier)" class="img-fluid" style="height:55px;" /></a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                @endforeach
            </div>  
            <!-- end row-->

            <div class="row">
                <div class="col-12">
                    <div class="card-box1">
                        <div class="row">
                            <div class="col-lg-8">
                            </div>
                            <div class="col-lg-4">
                                <div class="text-lg-right mt-3 mt-lg-0">
                                    <button type="button" title="Set Priority" onclick="submit()" class="btn btn-dark btn-sm mr-1"><i class="fa fa-arrows"></i> SAVE PRIORITY</button>
                                </div>
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row -->
                    </div>
                    <!-- end card-box -->
                </div>
                <!-- end col-->
            </div>
        </fieldset>
        @endif
                      <fieldset class="scheduler-border">
                        <legend class="scheduler-border"><i class="fa fa-plus"></i>Add New Courier Click on Logo Box</legend>
            <!-- end page title -->
            <div class="row" id="sortable1" class="connectedSortable">
                <div class="col-lg-6 col-xl-3">
                    <div class="card-box bg-pattern">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('ecomexpress.index') }}" title="Ecomexpress">
                                    <img src="https://ecomexpress.in/ecom-assets/uploads/2017/01/ecom-logo.png" alt="Ecomexpress" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="bluedart">
                    <div class="card-box bg-pattern">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('bluedart.index') }}" title="Bluedart"> <img src="https://www.phoeniixx.com/wp-content/uploads/2014/11/blue-dart-logo-300x66.png" alt="BLUEDART" class="img-fluid" /></a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="shadowfax">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('shadowfax.index') }}" title="SHADOWFAX">
                                    <img src="https://global-uploads.webflow.com/5f2ab1ee99df40ee3a680460/5f31488f01607c1e9e0827c0_img_logo.svg" alt="SHADOWFAX" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="delhivery">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('delhivery.index') }}" title="Delhivery">
                                    <img src="https://www.delhivery.com/assets/images/logo.jpg" alt="Delhivery" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="xpressbees">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('xpressbees.index') }}" title="XPRESSBEES">
                                    <img src="https://www.xpressbees.com/images/logo.png" alt="XPRESSBEES" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end col -->
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="ekart">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('ekart.index') }}" title="E-KART">
                                    <img src="https://ekartlogistics.com/static/xpec/img/logo.png" alt="E-KART" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="shiprocket">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12">
                                <a href="{{ route('shiprocket.index') }}" title="shiprocket">
                                    <img src="https://1z1r78459bkr48akfe48y2pb-wpengine.netdna-ssl.com/wp-content/uploads/2013/08/shiprocket_logo.png" alt="shiprocket" class="img-fluid" />
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- end card-box-->
                </div>
                <!-- end col -->
                <!-- end col -->
                <div class="col-lg-6 col-xl-3" id="shyplite">

                    <div class="card-box bg-pattern" style="height: 110px;">
                        <div class="row">
                            <div class="col-12"><img src="https://docs.ongoingwarehouse.com/Content/Images/Logos/Original/shyplite.png" alt="XPRESSBEES" style="width: 220px;" class="img-fluid" /></div>
                        </div>
                    </div>
                </div>
                <!-- end col -->
            </div>
            <!-- end row-->
        </fieldset>

        </div>


        <!-- end row -->
    </div> <!-- end container-fluid -->
</div>

@endsection
