@extends('theme.layouts.app') @section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                        </ol>
                    </div>
                    <h4 class="page-title">Collection</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

    <form class="needs-validation parsley-examples" data-parsley-validate action="{{ route('collection.store')}}" method="POST" novalidate>
        @csrf
        <div class="row row-sm">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                            <div class="form-group">
                                <label for="input-3">Parent ID</label>
                                <select name="is_parent" class="form-control">
                                    <option value="0">Collection</option>
                                @foreach(App\Models\Collection::orderBy('name')->get() as $key=>$collection_rows)    
                                    <option value="{{ $collection_rows->id }}">{{ $collection_rows->name }}</option>
                                @endforeach    
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Collection Name *</label>
                                <input type="text" class="form-control" name="name" value="{{ old('name') }}" placeholder="Name *" required  />
                                @error('name')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter Account Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-3">Status</label>
                                <select name="is_active" required class="form-control">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        <div class="form-group">
                            <button type="submit" style="font-size: 18px;" class="btn btn-primary shadow-primary btn-block pull-right" name="submit" value="Save">Save</button>
                        </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </form>    
    </div>
    <!-- end container-fluid -->
</div>
@endsection
