@extends('theme.layouts.app') @section('content')
<div class="wrapper">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                          @foreach($breadcrumbs as $key=>$bcumbs_rows)
                            @if($key!='javascript:void(0)')
                            <li class="breadcrumb-item"><a href="{{ route($key) }}" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @else
                            <li class="breadcrumb-item"><a href="javascript:void(0);" style="color: #88928c;" title="{{ $bcumbs_rows }}">{{ $bcumbs_rows }}</a></li>
                            @endif
                          @endforeach  
                        </ol>
                    </div>
                    <h4 class="page-title">Review</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

    <form class="needs-validation parsley-examples" data-parsley-validate action="{{ route('review.store')}}" method="POST" novalidate>
        @csrf
        <div class="row row-sm">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <fieldset class="scheduler-border">
                            <legend align="left" class="scheduler-border"><i>Basic Info.</i></legend>
                            <div class="form-group">
                                <label for="input-3">Product</label>
                                <select name="product_id" class="form-control">
                                    <option value="0">Product</option>
                                @foreach(App\Models\Product::orderBy('name')->get() as $key=>$collection_rows)    
                                    <option value="{{ $collection_rows->id }}">{{ $collection_rows->name }}</option>
                                @endforeach    
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Star *</label>
                                <select name="star" required class="form-control">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                </select>                                
                                @error('heading')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter Star Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Heading *</label>
                                <input type="text" class="form-control" name="heading" value="{{ old('heading') }}" placeholder="Heading *" required  />
                                @error('heading')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter heading Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Name *</label>
                                <input type="text" class="form-control" name="name" value="{{ old('name') }}" placeholder="name *" required  />
                                @error('heading')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter heading Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Review Date *</label>
                                <input type="date" class="form-control" name="review_datetime" value="{{ old('review_datetime') }}"  required  />
                                @error('review_datetime')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter heading Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Description *</label>
                                <textarea type="text" class="form-control" name="description" placeholder="description *" required>{{old('description')}}</textarea>
                                @error('description')
                                 <span class="text-danger">{{ $message }}</span>
                                @enderror
                                <div class="invalid-feedback" role="alert">
                                    Please Enter description Name.
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="input-3">Status</label>
                                <select name="is_active" required class="form-control">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        <div class="form-group">
                            <button type="submit" style="font-size: 18px;" class="btn btn-primary shadow-primary btn-block pull-right" name="submit" value="Save">Save</button>
                        </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </form>    
    </div>
    <!-- end container-fluid -->
</div>
@endsection
