@extends('theme.layouts.app')
@section('content')
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                     <li class="breadcrumb-item"><a href="{{ route('home') }}" title="Dashboard">Dashboard</a></li>
                     <li class="breadcrumb-item">Settings</li>
                     <li class="breadcrumb-item active">Warehouse</li>
                  </ol>
               </div>
               <h4 class="page-title">Warehouse</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->
      <div class="row">
         <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
               <div class="card-body">
                  <fieldset class="scheduler-border">
                     <legend align="left" class="scheduler-border">
                       {{  $response->total()  }} - TOTAL <a href="{{ route('warehouse.create') }}" style="font-size:12px;" titile="">Add New</a>
                     </legend>
                            <div class="table-responsive">
                                <table class="table table-centered table-striped dt-responsive nowrap w-100 table-sm" id="products-datatable">
                                    <thead class="text-left thead-info">
                                        <th>S.No.</th>
                                        <th>Account</th>
                                        <th>Address</th>
                                        <th>Contact info</th>
                                        <th>Status</th>
                                        <th>Created at</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @foreach($response as $key=>$rows)
                                        <form action="{{ route('warehouse.destroy',$rows->id) }}" method="POST">
                                            @csrf @method('DELETE')
                                            <tr>
                                                <td>{{ $key+1 }}</td>
                                                <td><b>{{ $rows->name }}</b></td>
                                                <td>{{ $rows->address_1.', '.$rows->address_2.', '.$rows->city.'-'.$rows->state.', '.$rows->pincode }}</td>
                                                <td><b>{{ $rows->contact_name }}</b><br>{{ $rows->mobile }}<br>{{ $rows->email }}</td>
                                                <td>
                                                    @if($rows->is_active==1)
                                                    <a href="{{ route('warehouse.edit',$rows->id) }}?action=0" title="Inactive" onclick="return confirm('Do you want to Inactive?');">
                                                        <span class="badge badge-success shadow-success m-1">Active</span>
                                                    </a>
                                                    @else
                                                    <a href="{{ route('warehouse.edit',$rows->id) }}?action=1" title="Active" onclick="return confirm('Do you want to Active?');">
                                                        <span class="badge badge-danger shadow-danger m-1">Inactive</span>
                                                    </a>
                                                    @endif
                                                </td>
                                                <td>{{ $rows->created_at }}</td>
                                                <td>
                                                    <a href="{{ route('warehouse.edit',$rows->id) }}" class="btn-sm btn btn-warning btn-rounded waves-effect waves-light" title="Edit Warehouse"><i class="fa fa-edit"></i></a>
                                                    <button type="submit" class="btn-sm btn btn-danger btn-rounded waves-effect waves-light" title="Delete Links" onclick="return confirm('Do You want to Delete?')"><i class="fa fa-trash"></i></button>

                                                </td>
                                            </tr>
                                        </form>
                                        @endforeach
                                    </tbody>
                                </table>
                                <hr />
                                {!! $response->links() !!}
                            </div>
                  </fieldset>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
@endsection