<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Resources\BackupResource;
use App\Models\Backup;
use App\Models\Pincode;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

#------------------------------------Webhooks-------------------------

Route::prefix('webhooks')->group(function () {

   // $response = Http::get();
	Route::any('/order-response/{token}/{auth_id}', [App\Http\Controllers\Api\WebhookController::class,'shopify_response']);
//    Route::any('/outgoing-call-response','Api\ApiController@out_going_calling_response');

    Route::any('/create', [App\Http\Controllers\Api\WebhookController::class,'webhook_create']);



});



Route::any('ajax-check-service-avaliability', function()
{
        if(request()->has('pincode'))
        {
            $response = Pincode::wherePincode($_GET['pincode'])->whereIs_active(1)->first();
            if(!is_null($response))
            {
                die('<i class="fa fa-check-circle" aria-hidden="true" style="color:#060;"></i> <font color="#060"> Delivery in 4-5 days</font>');
            }else{
                die('<i class="fa fa-times-circle" aria-hidden="true" style="color:red;"></i> <font color="red"> Currently out of stock in this area.</font>');
            }
        }
});

    Route::any('ajax-check-service', function(){

        if(request()->has('pincode'))
        {
            $response = Pincode::wherePincode($_GET['pincode'])->whereIs_active(1)->first();
            if(!is_null($response))
            {
                 die($response->city.'-'.$response->state);
            }else{
                die('error404');
            }
        }

    });


Route::get('/orders/{limit}/{token}', function (Request $request) 
{
    return BackupResource::collection(Backup::latest()->take($request->limit)->get());
});

Route::get('/fetch-orders/{token}', function (Request $request) {

    $api_rows = DB::table('webhooks_apis')->where('secret_key',$request->token)->take(1)->latest()->first();
    if(!is_null($api_rows))
    {    
        if($api_rows->is_active==1)
        {    
            if($api_rows->secret_key==$request->token)
            {
                return BackupResource::collection(Backup::latest()->take(50)->get());
            }else{
                die(json_encode(['success'=>false,'response'=>'Invalid Token.']));
            }    
        }else{
                die(json_encode(['success'=>false,'response'=>'Inactive Account.']));
           }
    }else{
                die(json_encode(['success'=>false,'response'=>'credential mismatch.']));
    }        
});