<?php $__env->startSection('content'); ?>
<div class="wrapper">
   <div class="container-fluid">
      <!-- start page title -->
      <div class="row">
         <div class="col-12">
            <div class="page-title-box">
               <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                     <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" title="Dashboard">Dashboard</a></li>
                     <li class="breadcrumb-item">Inventory</li>
                     <li class="breadcrumb-item active">Collection</li>
                  </ol>
               </div>
               <h4 class="page-title">Collection</h4>
            </div>
         </div>
      </div>
      <!-- end page title -->
      <div class="row">
         <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
               <div class="card-body">

               <div class="row mb-2">
               <div class="col-lg-12">
                  <div class="text-lg-end pull-right">
                        <a href="<?php echo e(route('collection.create')); ?>" class="btn btn-sm btn-primary waves-effect waves-light mb-2 me-2"><i class="mdi mdi-basket me-1"></i> Add New</a>
                  </div>
               </div>
               <!-- end col-->
            </div>


                  <fieldset class="scheduler-border">
                     <legend align="left" class="scheduler-border">Collection</legend>
                            <div class="table-responsive">
                                <table class="table table-centered table-striped dt-responsive nowrap w-100 table-sm" id="products-datatable">
                                    <thead class="text-left thead-info">
                                        <th>S.No.</th>
                                        <th>Name</th>
                                        <th>Parent</th>
                                        <th>Status</th>
                                        <th>Created at</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $response; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <form action="<?php echo e(route('collection.destroy',$rows->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <tr>
                                                <td><?php echo e($key+1); ?></td>
                                                <td><?php echo e($rows->name); ?></td>
                                                <td><?php echo e(App\Models\Collection::whereId($rows->parent_id)->value('name')); ?></td>
                                                <td>
                                                    <?php if($rows->is_active==1): ?>
                                                    <a href="<?php echo e(route('collection.edit',$rows->id)); ?>?action=0" title="Inactive" onclick="return confirm('Do you want to Inactive?');">
                                                        <span class="badge badge-success shadow-success m-1">Active</span>
                                                    </a>
                                                    <?php else: ?>
                                                    <a href="<?php echo e(route('collection.edit',$rows->id)); ?>?action=1" title="Active" onclick="return confirm('Do you want to Active?');">
                                                        <span class="badge badge-danger shadow-danger m-1">Inactive</span>
                                                    </a>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($rows->created_at); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('collection.edit',$rows->id)); ?>" class="btn-sm btn btn-primary btn-rounded waves-effect waves-light" title="Edit"><i class="fa fa-edit"></i></a>

                                                    <button type="submit" class="btn-sm btn btn-danger btn-rounded waves-effect waves-light" title="Delete" onclick="return confirm('Do You want to Delete?')"><i class="fa fa-trash"></i></button>

                                                </td>
                                            </tr>
                                        </form>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <hr />
                                <?php echo $response->links(); ?>

                            </div>

                  </fieldset>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\php8.2\htdocs\advance\cmsweb\resources\views/theme/inventory/collection/index.blade.php ENDPATH**/ ?>