<?php

require('admin/inc/db_config.php');
require('admin/inc/essentials.php');
require('inc/razorpay-php/Razorpay.php');

use Razorpay\Api\Api;

// define('CALLBACK_URL', 'http://localhost/hbwebsite/pay_response.php');
// require('inc/paytm/config_paytm.php');
// require('inc/paytm/encdec_paytm.php');

date_default_timezone_set("Asia/Kolkata");

session_start();

if (!(isset($_SESSION['login']) && $_SESSION['login'] == true)) {
  redirect('index.php');
}

if (isset($_POST['pay_now'])) {
  header("Pragma: no-cache");
  header("Cache-Control: no-cache");
  header("Expires: 0");
  //   echo '<pre>'.var_dump($_SESSION).'</pre>';

  // die;
  $checkSum = "";

  $ORDER_ID = 'ORD_' . $_SESSION['uId'] . random_int(11111, 9999999);
  $CUST_ID = $_SESSION['uId'];
  // $INDUSTRY_TYPE_ID = INDUSTRY_TYPE_ID;
  // $CHANNEL_ID = CHANNEL_ID;
  $TXN_AMOUNT = $_SESSION['room']['payment'];

  $user_q = select("SELECT * FROM `user_cred` WHERE `id`=? LIMIT 1", [$_SESSION['uId']], 'i');
  $user_fetch = mysqli_fetch_assoc($user_q);

  $_SESSION['login'] = true;
  $_SESSION['uId'] = $user_fetch['id'];
  $_SESSION['uName'] = $user_fetch['name'];
  $_SESSION['uEmail'] = $user_fetch['email'];
  $_SESSION['uPic'] = $user_fetch['profile'];
  $_SESSION['uPhone'] = $user_fetch['phonenum'];

  // Create an array having all required parameters for creating checksum.

  $api = new Api(RAZOR_PAY_KEY_ID, RAZOR_PAY_KEY_SECRET);
  $order = $api->order->create(['receipt' =>  $ORDER_ID, 'amount' => ($TXN_AMOUNT * 100), 'currency' => 'INR']);

  // $paramList = array();
  // $paramList["KEY_ID"] =  $keyId;
  // $paramList["ORDER_ID"] = $order['id'];
  // $paramList["CUST_ID"] = $CUST_ID;
  // $paramList["TXN_AMOUNT"] = $TXN_AMOUNT;
  $CALLBACK_URL = CALLBACK_URL;


  //Here checksum string will return by getChecksumFromArray() function.
  // $checkSum = getChecksumFromArray($paramList, $keySecret);

  $order_id  =  $order['id'];
  $order_receipt = $order['receipt'];
  $order_amount = $order['amount'];
  $order_currency = $order['currency'];
  $order_created_at = $order['created_at'];
  // Insert payment data into database

  $_SESSION['razorpay_order_id'] =  $order_id;
  $_SESSION['room']['razorpay_order_id'] =  $order_id;

  $frm_data = filteration($_POST);

  $query1 = "INSERT INTO `booking_order`(`user_id`, `room_id`, `check_in`, `check_out`,`order_id`) VALUES (?,?,?,?,?)";

  insert($query1, [
    $CUST_ID, $_SESSION['room']['id'], $frm_data['checkin'],
    $frm_data['checkout'], $order_id
  ], 'issss');

  $booking_id = mysqli_insert_id($con);

  $query2 = "INSERT INTO `booking_details`(`booking_id`, `room_name`, `price`, `total_pay`,
      `user_name`, `phonenum`, `address`) VALUES (?,?,?,?,?,?,?)";

  insert($query2, [
    $booking_id, $_SESSION['room']['name'], $_SESSION['room']['price'],
    $TXN_AMOUNT, $frm_data['name'], $frm_data['phonenum'], $frm_data['address']
  ], 'issssss');
}

?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link href="https://fonts.googleapis.com/css2?family=Merienda:wght@400;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
  <link rel="stylesheet" href="css/common.css">
  <title>Processing</title>
</head>

<body class="bg-light">


  <div class="container">
    <div class="row">

      <div class="col-12 my-5 mb-3 px-4">
        <h2 class="fw-bold">Please do not refresh this page...</h2>
      </div>

      <!-- <form action="< ?= CALLBACK_URL ?>" method="POST"> -->
      <!-- < ?php foreach ($paramList as $name => $value) {
          echo '<input type="hidden" name="' . $name . '" value="' . $value . '">';
        }
        ?> -->
      <!-- <input type="hidden" name="CHECKSUMHASH" value="< ?php echo $checkSum ?>"> -->

      <!-- <button id="rzp-button1">Pay</button> -->
      <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
      <script>
        var options = {
          "key": "<?= $keyId ?>", // Enter the Key ID generated from the Dashboard
          "amount": "<?= $order_amount ?>", // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
          "currency": "<?= $order_currency ?>",
          "name": "Radisson Towers",
          "description": "Test Transaction",
          "image": "",
          "order_id": "<?= $order_id ?>",
          "callback_url": "<?= $CALLBACK_URL ?>",
          "prefill": {
            "name": "<?= $user_fetch['name'] ?>",
            "email": "<?= $user_fetch['email'] ?>",
            "contact": "<?= $user_fetch['phonenum'] ?>"
          },
          "theme": {
            "color": "#3399cc"
          }
        };
        var rzp1 = new Razorpay(options);
        // document.getElementById("rzp-button1").click();

        pp = function() {
          rzp1.open();
        }
        pp();
      </script>
      <!-- </form> -->

      <div class="col-12 px-4">
        <p class="fw-bold alert alert-danger">
          <a href='bookings.php' class="btn btn-primary">Back to Bookings</a>
        </p>
      </div>
    </div>
  </div>
</body>

</html>