<?php

require('admin/inc/db_config.php');
require('admin/inc/essentials.php');

require('inc/razorpay-php/Razorpay.php');

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

// require('inc/paytm/config_paytm.php');
require('inc/paytm/encdec_paytm.php');

date_default_timezone_set("Asia/Kolkata");

session_start();

function regenrate_session($uid)
{
  $user_q = select("SELECT * FROM `user_cred` WHERE `id`=? LIMIT 1", [$uid], 'i');
  $user_fetch = mysqli_fetch_assoc($user_q);

  $_SESSION['login'] = true;
  $_SESSION['uId'] = $user_fetch['id'];
  $_SESSION['uName'] = $user_fetch['name'];
  $_SESSION['uPic'] = $user_fetch['profile'];
  $_SESSION['uPhone'] = $user_fetch['phonenum'];
}

header("Pragma: no-cache");
header("Cache-Control: no-cache");
header("Expires: 0");

$success = true;


$error = "Payment Failed";
$order_id = $_SESSION['razorpay_order_id'];
$_SESSION['room']['razorpay_order_id'];
if (empty($order_id) === false) {


  $api = new Api(RAZOR_PAY_KEY_ID, RAZOR_PAY_KEY_SECRET);

  $transaction_id = $_POST['razorpay_payment_id'];
  $razorpay_signature = $_POST['razorpay_signature'];


  $slct_query = "SELECT `booking_id`, `user_id` FROM `booking_order`  WHERE `order_id`='$order_id'";

  $slct_res = mysqli_query($con, $slct_query);

  // if (mysqli_num_rows($slct_res) == 0) {
  //   redirect('index.php');
  // }
  $slct_fetch = mysqli_fetch_assoc($slct_res);

  if (empty($slct_fetch['user_id']) === false) {
    if (!(isset($_SESSION['login']) && $_SESSION['login'] == true)) {
      regenrate_session($slct_fetch['user_id']);
    }

    if (empty($transaction_id) === false) {

      try {
        // Please note that the razorpay order ID must
        // come from a trusted source (session here, but
        // could be database or something else)
        $attributes = array(
          'razorpay_order_id' => $order_id,
          'razorpay_payment_id' => $transaction_id,
          'razorpay_signature' =>    $razorpay_signature
        );

       
        $api->utility->verifyPaymentSignature($attributes);

        $upd_query = "UPDATE `booking_order` SET
         `booking_status`='booked',
          `trans_id`='$transaction_id',
          `trans_amt`='$_SESSION[room][payment]',
           `trans_status`='TXN_SUCCESS',
           `trans_resp_msg`='Txn Success' 
      WHERE `booking_id`='$slct_fetch[booking_id]'";

        mysqli_query($con, $upd_query);
        
     
      } catch (SignatureVerificationError $e) {
        $success = false;
        $error = 'Razorpay Error : ' . $e->getMessage();
      }
    } else {
      $upd_query = "UPDATE `booking_order` SET `booking_status`='payment failed',`trans_amt`='$_SESSION[room][payment]',
          `trans_status`='TXN_FAILURE',`trans_resp_msg`='$_POST[error][reason]' 
          WHERE `booking_id`='$slct_fetch[booking_id]'";
    }
  }



  redirect('pay_status.php?order=' . $order_id);
} else {
  redirect('index.php');
}
