<div class="sidebar sidebar-style-2"
    data-background-color="<?php echo e(Session::get('vendor_theme_version') == 'light' ? 'white' : 'dark2'); ?>">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    <?php if(Auth::guard('vendor')->user()->photo != null): ?>
                        <img src="<?php echo e(asset('assets/admin/img/vendor-photo/' . Auth::guard('vendor')->user()->photo)); ?>"
                            alt="Vendor Image" class="avatar-img rounded-circle">
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>" alt=""
                            class="avatar-img rounded-circle">
                    <?php endif; ?>
                </div>

                <div class="info">
                    <a data-toggle="collapse" href="#adminProfileMenu" aria-expanded="true">
                        <span>
                            <?php echo e(Auth::guard('vendor')->user()->username); ?>

                            <span class="user-level"><?php echo e(__('Vendor')); ?></span>
                            <span class="caret"></span>
                        </span>
                    </a>

                    <div class="clearfix"></div>

                    <div class="collapse in" id="adminProfileMenu">
                        <ul class="nav">
                            <li>
                                <a href="<?php echo e(route('vendor.edit.profile')); ?>">
                                    <span class="link-collapse"><?php echo e(__('Edit Profile')); ?></span>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('vendor.change_password')); ?>">
                                    <span class="link-collapse"><?php echo e(__('Change Password')); ?></span>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('vendor.logout')); ?>">
                                    <span class="link-collapse"><?php echo e(__('Logout')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>


            <ul class="nav nav-primary">
                
                <div class="row mb-3">
                    <div class="col-12">
                        <form>
                            <div class="form-group py-0">
                                <input name="term" type="text" class="form-control sidebar-search ltr"
                                    placeholder="Search Menu Here...">
                            </div>
                        </form>
                    </div>
                </div>

                
                <li class="nav-item <?php if(request()->routeIs('vendor.dashboard')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.dashboard')); ?>">
                        <i class="la flaticon-paint-palette"></i>
                        <p><?php echo e(__('Dashboard')); ?></p>
                    </a>
                </li>


                <?php if($userCurrentPackage): ?>
                    <li
                        class="nav-item
                     <?php if(request()->routeIs('vendor.property_management.properties')): ?> active 
                     <?php elseif(request()->routeIs('vendor.featured_property.index')): ?> active
                      <?php elseif(request()->routeIs('vendor.property_management.create_property')): ?> active 
                      <?php elseif(request()->routeIs('vendor.property_management.type')): ?> active
                      <?php elseif(request()->routeIs('vendor.property_management.edit')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#propertyManagement">
                            <i class="fas fa-home"></i>
                            <p><?php echo e(__('Property Management')); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="propertyManagement"
                            class="collapse 
              <?php if(request()->routeIs('vendor.property_management.properties')): ?> show 
              <?php elseif(request()->routeIs('vendor.property_management.type')): ?> show
              <?php elseif(request()->routeIs('vendor.property_management.create_property')): ?> show
              <?php elseif(request()->routeIs('vendor.property_management.edit')): ?> show <?php endif; ?>
              ">
                            <ul class="nav nav-collapse">

                                <li
                                    class="<?php echo e(request()->routeIs('vendor.property_management.create_property') || request()->routeIs('vendor.property_management.type') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('vendor.property_management.type')); ?>">
                                        <span class="sub-item"><?php echo e(__('Add Property')); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('vendor.property_management.properties') || request()->routeIs('vendor.property_management.edit') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('vendor.property_management.properties', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Manage Properties')); ?> </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                <?php if($userCurrentPackage): ?>
                    
                    <li class="nav-item  <?php if(request()->routeIs('vendor.property_message.index')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('vendor.property_message.index')); ?>">
                            <i class="fas fa-comment"></i>
                            <p><?php echo e(__('Property Messages')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if($userCurrentPackage): ?>
                    <li
                        class="nav-item
                     <?php if(request()->routeIs('vendor.project_management.projects')): ?> active
                     <?php elseif(request()->routeIs('vendor.project_management.create_project')): ?> active 
                     <?php elseif(request()->routeIs('vendor.project_management.edit')): ?> active <?php elseif(request()->routeIs('vendor.project_management.project_types')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#projectManagement">
                            <i class="fas fa-city"></i>
                            <p><?php echo e(__('Project Management')); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="projectManagement"
                            class="collapse 
              <?php if(request()->routeIs('vendor.project_management.create_project')): ?> show  
              <?php elseif(request()->routeIs('vendor.project_management.projects')): ?> show 
              <?php elseif(request()->routeIs('vendor.project_management.edit')): ?> show 
              <?php elseif(request()->routeIs('vendor.project_management.project_types')): ?> show <?php endif; ?>
              ">
                            <ul class="nav nav-collapse">

                                <li
                                    class="<?php echo e(request()->routeIs('vendor.project_management.create_project') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('vendor.project_management.create_project')); ?>">
                                        <span class="sub-item"><?php echo e(__('Add Project')); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('vendor.project_management.edit') || request()->routeIs('vendor.project_management.projects') || request()->routeIs('vendor.project_management.project_types') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('vendor.project_management.projects', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Manage Projects')); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>

                    



                    <li class="nav-item  <?php if(request()->routeIs('vendor.agent_management.index')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('vendor.agent_management.index')); ?>">
                            <i class="fal fa-users-cog"></i>
                            <p><?php echo e(__('Agents')); ?></p>
                        </a>
                    </li>
                    <?php
                        $support_status = DB::table('support_ticket_statuses')->first();
                    ?>
                    <?php if($support_status->support_ticket_status == 'active'): ?>
                        
                        <li
                            class="nav-item <?php if(request()->routeIs('vendor.support_tickets')): ?> active
            <?php elseif(request()->routeIs('vendor.support_tickets.message')): ?> active
            <?php elseif(request()->routeIs('vendor.support_ticket.create')): ?> active <?php endif; ?>">
                            <a data-toggle="collapse" href="#support_ticket">
                                <i class="la flaticon-web-1"></i>
                                <p><?php echo e(__('Support Tickets')); ?></p>
                                <span class="caret"></span>
                            </a>

                            <div id="support_ticket"
                                class="collapse
              <?php if(request()->routeIs('vendor.support_tickets')): ?> show
              <?php elseif(request()->routeIs('vendor.support_tickets.message')): ?> show
              <?php elseif(request()->routeIs('vendor.support_ticket.create')): ?> show <?php endif; ?>">
                                <ul class="nav nav-collapse">

                                    <li
                                        class="<?php echo e(request()->routeIs('vendor.support_tickets') && empty(request()->input('status')) ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('vendor.support_tickets')); ?>">
                                            <span class="sub-item"><?php echo e(__('All Tickets')); ?></span>
                                        </a>
                                    </li>
                                    <li
                                        class="<?php echo e(request()->routeIs('vendor.support_ticket.create') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('vendor.support_ticket.create')); ?>">
                                            <span class="sub-item"><?php echo e(__('Add a Ticket')); ?></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>


                
                <li
                    class="nav-item 
        <?php if(request()->routeIs('vendor.plan.extend.index')): ?> active 
        <?php elseif(request()->routeIs('vendor.plan.extend.checkout')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.plan.extend.index')); ?>">
                        <i class="fal fa-lightbulb-dollar"></i>
                        <p><?php echo e(__('Buy Plan')); ?></p>
                    </a>
                </li>

                <li class="nav-item <?php if(request()->routeIs('vendor.payment_log')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.payment_log')); ?>">
                        <i class="fas fa-list-ol"></i>
                        <p><?php echo e(__('Payment Logs')); ?></p>
                    </a>
                </li>
                <li class="nav-item <?php if(request()->routeIs('vendor.edit.profile')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.edit.profile')); ?>">
                        <i class="fal fa-user-edit"></i>
                        <p><?php echo e(__('Edit Profile')); ?></p>
                    </a>
                </li>
                <li class="nav-item <?php if(request()->routeIs('vendor.change_password')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.change_password')); ?>">
                        <i class="fal fa-key"></i>
                        <p><?php echo e(__('Change Password')); ?></p>
                    </a>
                </li>

                <li class="nav-item <?php if(request()->routeIs('vendor.logout')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('vendor.logout')); ?>">
                        <i class="fal fa-sign-out"></i>
                        <p><?php echo e(__('Logout')); ?></p>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/vendors/partials/side-navbar.blade.php ENDPATH**/ ?>