<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e($agent->username); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('metaKeywords'); ?>
    <?php echo e($agent->username); ?>, <?php echo e(!request()->filled('admin') ? @$agentInfo->first_name . ' ' . @$agentInfo->last_name : ''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php echo e(!request()->filled('admin') ? @$agentInfo->details : ''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->agent_page_title : __('Agent'),
        'subtitle' => __('Agent'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->agent_page_title : __('Agent'),
        'subtitle' => __('Agent'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="agent-single pt-100 pb-70">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-lg-9">
                    <div class="row agent-single-box align-items-center mb-10 gx-xl-5" data-aos="fade-up">
                        <figure class="agent-img col-lg-6 mb-30">
                            <a href="#" class="lazy-container radius-md ratio ratio-1-1">
                                <?php if($agent->image != null): ?>
                                    <img class="lazyload" src="<?php echo e(asset('assets/img/agents/' . $agent->image)); ?>"
                                        data-src="<?php echo e(asset('assets/img/agents/' . $agent->image)); ?>">
                                <?php else: ?>
                                    <img class="lazyload" data-src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>"
                                        src="<?php echo e(asset('assets/img/agents/' . $agent->image)); ?>">
                                <?php endif; ?>

                            </a>
                        </figure>
                        <div class="agent-details col-lg-6 mb-30">
                            <span class="label radius-sm"><?php echo e($agent->username); ?></span>
                            <div class="mb-15"></div>
                            <h2 class="agent-title m-0">
                                <?php echo e(@$agentInfo->first_name . ' ' . @$agentInfo->last_name); ?></h2>


                            <ul class="agent-info list-unstyled p-0">
                                <?php if($agent->show_phone_number == 1 && !is_null($agent->phone)): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-mobile-android"></i>
                                            <span><?php echo e(__('Phone') . ':'); ?></span>
                                        </div>
                                        <div> <a href="tel:<?php echo e($agent->phone); ?>"><?php echo e($agent->phone); ?></a>
                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if($agent->show_email_addresss == 1 && !is_null($agent->email)): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-envelope"></i>
                                            <span><?php echo e(__('Email') . ':'); ?></span>
                                        </div>
                                        <div>
                                            <a href="mailTo:<?php echo e($agent->email); ?>"><?php echo e($agent->email); ?>

                                            </a>
                                        </div>

                                    </li>
                                <?php endif; ?>

                                <?php if(!is_null(@$agentInfo->city)): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-map-marker-alt"></i>
                                            <span><?php echo e(__('City') . ':'); ?></span>
                                        </div>
                                        <div>
                                            <?php echo e(@$agentInfo->city); ?>

                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if(!is_null(@$agentInfo->state)): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-map-marker-alt"></i>
                                            <span><?php echo e(__('State') . ':'); ?></span>
                                        </div>
                                        <div>
                                            <?php echo e(@$agentInfo->state); ?>

                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if(!is_null(@$agentInfo->country)): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-map-marker-alt"></i>
                                            <span><?php echo e(__('Country') . ':'); ?></span>
                                        </div>
                                        <div>
                                            <?php echo e(@$agentInfo->country); ?>

                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if(!is_null(@$agentInfo->address)): ?>
                                    <li class="icon-start text-break">
                                        <div>
                                            <i class="fal fa-map-marker-alt"></i>
                                            <span><?php echo e(__('Address') . ' : '); ?></span>
                                        </div>
                                        <div>
                                            <?php echo e(@$agentInfo->address); ?>

                                        </div>

                                    </li>
                                <?php endif; ?>

                                <li class="icon-start">
                                    <div>
                                        <i class="fal fa-calendar-day"></i>
                                        <span><?php echo e(__('Member since') . ':'); ?></span>
                                    </div>
                                    <div>
                                        <?php echo e(\Carbon\Carbon::parse($agent->created_at)->format('F Y')); ?>

                                    </div>
                                </li>
                            </ul>

                            <div class="d-flex flex-wrap lign-items-center mt-20 gap-15">
                                <?php if($agent->show_phone_number == 1): ?>
                                    <a href="#" class="btn btn-lg btn-primary"><?php echo e(__('Send Email')); ?></a>
                                <?php endif; ?>
                                <?php if($agent->show_email_addresss == 1): ?>
                                    <a href="tel:<?php echo e($agent->phone); ?>"
                                        class="btn btn-lg btn-outline"><?php echo e(__('Call Now')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div><!-- agent-default -->
                    <div class="agent-single-details">
                        <?php if(!is_null(@$agentInfo->details)): ?>
                            <div class="mb-20"></div>
                            <div class="agent-desc mb-40">
                                <h3 class="mb-20"><?php echo e(__('About')); ?></h3>
                                <p>
                                    <?php echo e(@$agentInfo->details); ?>

                                </p>
                            </div>
                        <?php endif; ?>
                        <?php if(count($all_properties) > 0): ?>
                            <div class="agent-listing mb-40">
                                <h3 class="mb-20"><?php echo e(__('My Properties') . ' (' . count($all_properties) . ')'); ?></h3>

                                <div class="row ">
                                    <div class="col-lg-12">

                                        <div class="tabs-navigation tabs-navigation-2 mb-20">
                                            <ul class="nav nav-tabs">
                                                <li class="nav-item">
                                                    <button class="nav-link active btn-md" data-bs-toggle="tab"
                                                        data-bs-target="#tab_all"
                                                        type="button"><?php echo e(__('All Properties')); ?></button>
                                                </li>

                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($category->properties()->count() > 0 && $category->categoryContent): ?>
                                                        <li class="nav-item">
                                                            <button class="nav-link btn-md" data-bs-toggle="tab"
                                                                data-bs-target="#tab_<?php echo e($category->id); ?>"
                                                                type="button"><?php echo e($category->categoryContent?->name); ?></button>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                        <div class="tab-content" data-aos="fade-up">
                                            <div class="tab-pane fade show active" id="tab_all">
                                                <div class="row">
                                                    <?php if(count($all_properties) > 0): ?>
                                                        <?php $__currentLoopData = $all_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($property->propertyContent): ?>
                                                                <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        <h4 class="text-center mt-4 mb-4"><?php echo e(__('No Property Found')); ?>

                                                        </h4>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="tab-pane fade" id="tab_<?php echo e($category->id); ?>">

                                                    <div class="row">
                                                        <?php $__empty_1 = true; $__currentLoopData = $all_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <?php if($property->category_id == $category->id): ?>
                                                                <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <div class="col-12 text-center">
                                                                <h3><?php echo e(__('No Properties Found')); ?></h3>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        <?php endif; ?>
                        <div class="agent-listing projects-area mb-40">
                            <h3 class="mb-20"><?php echo e(__('My Projects') . ' (' . count($all_projects) . ')'); ?></h3>
                            <div class="row">
                                <?php $__empty_1 = true; $__currentLoopData = $all_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="col-lg-4 col-sm-6" data-aos="fade-up" data-aos-delay="100">
                                        <a href="<?php echo e(route('frontend.projects.details', ['slug' => $project->slug])); ?>">
                                            <div class="card mb-30">
                                                <div class="card-img">
                                                    <div class="lazy-container ratio ratio-1-3">
                                                        <img class="lazyload" src="assets/images/placeholder.png"
                                                            data-src="<?php echo e(asset('assets/img/project/featured/' . $project->featured_image)); ?>">
                                                    </div>
                                                    <span class="label">
                                                        <?php if($project->status == 0): ?>
                                                            <?php echo e(__('Under Construction')); ?>

                                                        <?php elseif($project->status == 1): ?>
                                                            <?php echo e(__('Complete')); ?>

                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                                <div class="card-text text-center">
                                                    <h3 class="card-title color-white mb-1">
                                                        <?php echo e(strlen($project->title) > 50 ? mb_substr($project->title, 0, 50, 'utf-8') . '...' : $project->title); ?>

                                                    </h3>
                                                    <span class="location icon-start"><i
                                                            class="fal fa-map-marker-alt"></i><?php echo e($project->address); ?></span>
                                                    <span class="price"> <?php echo e(symbolPrice($project->min_price)); ?>

                                                        <?php echo e(!empty($project->max_price) ? ' - ' . symbolPrice($project->max_price) : ''); ?>


                                                    </span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="col-lg-12">
                                        <h3 class="text-center mt-5"> <?php echo e(__('No Projects Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="col-lg-3">
                    <aside class="sidebar-widget-area" data-aos="fade-up">
                        <?php if($agent->show_contact_form == 1): ?>
                            <div class="widget widget-form radius-md mb-30">
                                <div class="user mb-20">
                                    <div class="user-img">
                                        <div class="lazy-container ratio ratio-1-1 rounded-pill">
                                            <img class="lazyload"
                                                src="<?php echo e(asset('assets/img/agents/' . $agent->image)); ?>">
                                        </div>
                                    </div>
                                    <div class="user-info">
                                        <h5 class="m-0">
                                            <?php echo e($agentInfo->first_name . ' ' . $agentInfo->last_name); ?>

                                        </h5>
                                        <a class="d-block" href="tel:<?php echo e($agent->phone); ?>"> <?php echo e($agent->phone); ?></a>
                                        <a href="mailto:<?php echo e($agent->email); ?>"> <?php echo e($agent->email); ?> </a>
                                    </div>
                                </div>
                                <form action="<?php echo e(route('contact_user')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="agent_id" value="<?php echo e($agent->id); ?>">
                                    <div class="form-group mb-20">
                                        <input type="text" class="form-control" name="name"
                                            placeholder="<?php echo e(__('Name')); ?>*" required value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <input type="email" class="form-control" required name="email"
                                            placeholder="<?php echo e(__('Email Address')); ?>*" value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <input type="number" class="form-control" name="phone" required
                                            value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Phone Number')); ?>*">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <textarea name="message" id="message" class="form-control" cols="30" rows="8" required=""
                                            data-error="Please enter your message" placeholder="<?php echo e(__('Write Your Message')); ?>"><?php echo e(old('message')); ?></textarea>

                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php if($info->google_recaptcha_status == 1): ?>
                                        <div class="form-group mb-30">
                                            <?php echo NoCaptcha::renderJs(); ?>

                                            <?php echo NoCaptcha::display(); ?>


                                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="mt-1 text-danger"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>
                                    <button type="submit" onsubmit="$('.request-loader').addClass('show');"
                                        class="btn btn-md btn-primary w-100"><?php echo e(__('Send message')); ?></button>
                                </form>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty(showAd(1))): ?>
                            <div class="text-center mb-40">
                                <?php echo showAd(1); ?>

                            </div>
                        <?php endif; ?>
                        <div class="widget widget-form radius-md mb-30">
                            <form action="<?php echo e(route('frontend.vendors')); ?>" method="GET">
                                <h3 class="title mb-20"><?php echo e(__('Find Vendor')); ?></h3>
                                <div class="form-group mb-20">

                                    <input type="text" name="name" value="<?php echo e(request()->input('name')); ?>"
                                        class="form-control " placeholder="<?php echo e(__('Vendor name/username')); ?>">
                                </div>
                                <div class="form-group mb-20">
                                    <select class="nice-select" aria-label="#" id="type" name="type">
                                        <option selected disabled><?php echo e(__('Select Project Type')); ?></option>

                                        <option value="residential"
                                            <?php echo e(request()->input('type') == 'residential' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Residential')); ?> </option>

                                        <option value="commercial"
                                            <?php echo e(request()->input('type') == 'commercial' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Commercial')); ?> </option>


                                    </select>
                                </div>
                                <div class="form-group mb-20">
                                    <input type="text" name="location" class="form-control"
                                        value="<?php echo e(request()->input('location')); ?>"
                                        placeholder="<?php echo e(__('Enter location')); ?>">
                                </div>
                                <button type="submit"
                                    class="btn btn-md btn-primary w-100"><?php echo e(__('Search Now')); ?></button>
                            </form>
                        </div>
                        <?php if(!empty(showAd(2))): ?>
                            <div class="text-center mb-40">
                                <?php echo showAd(2); ?>

                            </div>
                        <?php endif; ?>
                    </aside>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/agent/details.blade.php ENDPATH**/ ?>