<?php
     $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e($propertyContent->title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if($propertyContent): ?>
        <?php echo e($propertyContent->meta_keyword); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if($propertyContent): ?>
        <?php echo e($propertyContent->meta_description); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('og:tag'); ?>
    <meta property="og:title" content="<?php echo e($propertyContent->title); ?>">
    <meta property="og:image" content="<?php echo e(asset('assets/img/property/featureds/' . $propertyContent->featured_image)); ?>">
    <meta property="og:url" content="<?php echo e(route('frontend.property.details', $propertyContent->slug)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="product-single pt-100 pb-70 border-top header-next">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-lg-9 col-xl-8">
                    <div class="product-single-gallery mb-40">
                        <!-- Slider navigation buttons -->
                        <div class="slider-navigation">
                            <button type="button" title="Slide prev" class="slider-btn slider-btn-prev">
                                <i class="fal fa-angle-left"></i>
                            </button>
                            <button type="button" title="Slide next" class="slider-btn slider-btn-next">
                                <i class="fal fa-angle-right"></i>
                            </button>
                        </div>
                        <div class="swiper product-single-slider">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <figure class="radius-lg lazy-container ratio ratio-16-11">
                                            <a href="<?php echo e(asset('assets/img/property/slider-images/' . $slider->image)); ?>"
                                                class="lightbox-single">
                                                <img class="lazyload" src="assets/images/placeholder.png"
                                                    data-src="<?php echo e(asset('assets/img/property/slider-images/' . $slider->image)); ?>">
                                            </a>
                                        </figure>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>

                        <div class="swiper slider-thumbnails">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="thumbnail-img lazy-container radius-md ratio ratio-16-11">
                                            <img class="lazyload" src="assets/images/placeholder.png"
                                                data-src="<?php echo e(asset('assets/img/property/slider-images/' . $slider->image)); ?>">
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="product-single-details">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="d-flex align-items-center justify-content-between mb-10">
                                    <span class="product-category text-sm"> <a
                                            href="<?php echo e(route('frontend.properties', ['category' => $propertyContent->categoryContent?->slug])); ?>">
                                            <?php echo e($propertyContent->categoryContent?->name); ?></a></span>
                                </div>
                                <h3 class="product-title">
                                    <a href="#"><?php echo e($propertyContent->title); ?></a>
                                </h3>
                                <div class="product-location icon-start">
                                    <i class="fal fa-map-marker-alt"></i>
                                    <span>
                                        <?php echo e($propertyContent->address); ?>

                                    </span>
                                    <span>
                                        <?php echo e($propertyContent->property->city?->getContent($propertyContent->language_id)?->name); ?>

                                        <?php echo e($propertyContent->property->isStateActive ? ', ' . $propertyContent->property->state?->getContent($propertyContent->language_id)?->name : ''); ?>

                                        <?php echo e($propertyContent->property->isCountryActive ? ', ' . $propertyContent->property->country?->getContent($propertyContent->language_id)?->name : ''); ?>

                                    </span>
                                </div>
                                <ul class="product-info p-0 list-unstyled d-flex align-items-center mt-10 mb-30">
                                    <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                        title="<?php echo e(__('Area')); ?>">
                                        <i class="fal fa-vector-square"></i>
                                        <span><?php echo e($propertyContent->area); ?> <?php echo e(__('Sqft')); ?></span>
                                    </li>
                                    <?php if($propertyContent->type == 'residential'): ?>
                                        <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                            title="<?php echo e(__('Beds')); ?>">
                                            <i class="fal fa-bed"></i>
                                            <span><?php echo e($propertyContent->beds); ?> <?php echo e(__('Beds')); ?></span>
                                        </li>
                                        <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                            title="<?php echo e(__('Baths')); ?>">
                                            <i class="fal fa-bath"></i>
                                            <span><?php echo e($propertyContent->bath); ?> <?php echo e(__('Baths')); ?></span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="product-price mb-10">
                                    <span class="new-price"><?php echo e(__('Price:')); ?>

                                        <?php echo e($propertyContent->price ? symbolPrice($propertyContent->price) : __('Negotiable')); ?></span>
                                </div>
                                <a <?php if(!empty($agent)): ?> href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>">
                                        <?php elseif(!empty($vendor)): ?>
                                             href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>">
                                            <?php else: ?>
                                              href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>"> <?php endif; ?>
                                    <div class="user mb-20">
                                    <div class="user-img">
                                        <div class="lazy-container ratio ratio-1-1 rounded-pill">
                                            <img class="lazyload" src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>"
                                                data-src="<?php if(!empty($agent)): ?> <?php echo e($agent->image ? asset('assets/img/agents/' . $agent->image) : asset('assets/img/blank-user.jpg')); ?>

                                            <?php elseif(!empty($vendor)): ?>
                                                <?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>

                                                <?php else: ?>
                                                 <?php echo e(asset('assets/img/admins/' . $admin->image)); ?> <?php endif; ?>">

                                        </div>
                                    </div>
                                    <div class="user-info">
                                        <h5 class="m-0">
                                            <?php if(!empty($agent)): ?>
                                                <?php echo e($agent->agent_info?->first_name . ' ' . $agent->agent_info?->last_name); ?>

                                            <?php elseif(!empty($vendor)): ?>
                                                <?php echo e($vendor->vendor_info?->name); ?>

                                            <?php else: ?>
                                                <?php echo e($admin->first_name . ' ' . $admin->last_name); ?>

                                            <?php endif; ?>
                                        </h5>

                                    </div>
                            </div>
                            </a>

                            <ul class="share-link list-unstyled mb-30">
                                <li>
                                    <a class="btn blue" href="#" data-bs-toggle="modal"
                                        data-bs-target="#socialMediaModal">
                                        <i class="far fa-share-alt"></i>
                                    </a>
                                    <span><?php echo e(__('Share')); ?></span>

                                </li>

                                <li>
                                    <?php if(Auth::guard('web')->check()): ?>
                                        <?php
                                            $user_id = Auth::guard('web')->user()->id;
                                            $checkWishList = checkWishList($propertyContent->propertyId, $user_id);
                                        ?>
                                    <?php else: ?>
                                        <?php
                                            $checkWishList = false;
                                        ?>
                                    <?php endif; ?>
                                    <a href="<?php echo e($checkWishList == false ? route('addto.wishlist', $propertyContent->propertyId) : route('remove.wishlist', $propertyContent->propertyId)); ?>"
                                        class="btn red " data-tooltip="tooltip" data-bs-placement="top"
                                        title="<?php echo e($checkWishList == false ? __('Add to Wishlist') : __('Saved')); ?>">

                                        <?php if($checkWishList == false): ?>
                                            <i class="fal fa-heart"></i>
                                        <?php else: ?>
                                            <i class="fas fa-heart"></i>
                                        <?php endif; ?>
                                    </a>
                                    <span><?php echo e($checkWishList == false ? __('Save') : __('Saved')); ?></span>

                                </li>

                            </ul>
                        </div>
                    </div>
                    <div class="mb-20"></div>
                    <div class="product-desc mb-40">
                        <h3 class="mb-20"><?php echo e(__('Property Description')); ?></h3>
                        <p class=" summernote-content"><?php echo $propertyContent->description; ?></p>
                    </div>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mb-3 mt-3">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(count($propertyContent->propertySpacifications) > 0): ?>
                        <div class="row" class="mb-20">
                            <div class="col-12">
                                <h3 class="mb-20"> <?php echo e(__('Features')); ?></h3>
                            </div>

                            <?php $__currentLoopData = $propertyContent->propertySpacifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $property_specification_content = App\Models\Property\SpacificationCotent::where([
                                        ['property_spacification_id', $specification->id],
                                        ['language_id', $language->id],
                                    ])->first();
                                ?>
                                <div class="col-lg-3 col-sm-6 col-md-4 mb-20">
                                    <strong
                                        class="mb-1 text-dark d-block"><?php echo e($property_specification_content?->label); ?></strong>
                                    <span><?php echo e($property_specification_content?->value); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="pb-20"></div>
                    <?php endif; ?>

                    <div class="product-featured mb-40">
                        <h3 class="mb-20"><?php echo e(__('Amenities')); ?></h3>
                        <ul class="featured-list list-unstyled p-0 m-0">
                            <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="d-inline-block icon-start">
                                    <i class="<?php echo e($amenity->amenity->icon); ?>"></i>
                                    <span><?php echo e($amenity->amenityContent?->name); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                    <?php if(!empty($propertyContent->video_url)): ?>
                        <div class="product-video mb-40">
                            <h3 class="mb-20"> <?php echo e(__('Video')); ?></h3>
                            <div class="lazy-container radius-lg ratio ratio-16-11">
                                <img class="lazyload" src="<?php echo e(asset('assets/front/images/placeholder.png')); ?>"
                                    data-src="<?php echo e($propertyContent->video_image ? asset('assets/img/property/video/' . $propertyContent->video_image) : asset('assets/front/images/placeholder.png')); ?>">
                                <a href="<?php echo e($propertyContent->video_url); ?>" class="video-btn youtube-popup p-absolute">
                                    <i class="fas fa-play"></i>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($propertyContent->floor_planning_image)): ?>
                        <div class="product-planning mb-40">
                            <h3 class="mb-20"><?php echo e(__('Floor Planning')); ?></h3>
                            <div class="lazy-container radius-lg ratio ratio-16-11 border">
                                <img class="lazyload" src="assets/images/placeholder.png"
                                    data-src="<?php echo e(asset('assets/img/property/plannings/' . $propertyContent->floor_planning_image)); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($propertyContent->latitude) && !empty($propertyContent->longitude)): ?>
                        <div class="product-location mb-40">
                            <h3 class="mb-20"><?php echo e(__('Location')); ?></h3>
                            <div class="lazy-container radius-lg ratio ratio-21-9 border">
                                <iframe class="lazyload"
                                    src="https://maps.google.com/maps?q=<?php echo e($propertyContent->latitude); ?>,<?php echo e($propertyContent->longitude); ?>&hl=<?php echo e($currentLanguageInfo->code); ?>&z=14&amp;output=embed"></iframe>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mb-3 mt-3">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-3 col-xl-4">
                <aside class="sidebar-widget-area mb-10" data-aos="fade-up">
                    <div class="widget widget-form radius-md mb-30">
                        <div class="user mb-20">
                            <div class="user-img">
                                <div class="lazy-container ratio ratio-1-1 rounded-pill">
                                    <?php if(!empty($agent)): ?>
                                        <a href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>">
                                            <img class="lazyload" src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>"
                                                data-src="<?php echo e($agent->image ? asset('assets/img/agents/' . $agent->image) : asset('assets/img/blank-user.jpg')); ?>">
                                        </a>
                                    <?php elseif(!empty($vendor)): ?>
                                        <a
                                            href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>">
                                            <img class="lazyload" src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>"
                                                data-src=" <?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>">
                                        </a>
                                    <?php else: ?>
                                        <a
                                            href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>">
                                            <img class="lazyload" src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>"
                                                data-src=" <?php echo e(asset('assets/img/admins/' . $admin->image)); ?> ">
                                        </a>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="user-info">
                                <h4 class="mb-0">
                                    <a <?php if(!empty($agent)): ?> href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>"> <?php echo e($agent->agent_info?->first_name . ' ' . $agent->agent_info?->last_name); ?>

                                            <?php elseif(!empty($vendor)): ?>
                                             href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>">   <?php echo e($vendor->vendor_info?->name); ?>

                                            <?php else: ?>
                                              href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>">   <?php echo e($admin->first_name . ' ' . $admin->last_name); ?> <?php endif; ?>
                                        </a>
                                </h4>
                                <a class="d-block"
                                    href="tel:<?php if(!empty($agent)): ?> <?php echo e($agent->phone); ?>

                                        <?php elseif(!empty($vendor)): ?>
                                            <?php echo e($vendor->phone); ?>

                                        <?php else: ?>
                                            <?php if($admin->show_contact_form && !empty($admin->phone)): ?>
                                            <?php echo e($admin->phone); ?> <?php endif; ?>
                                        <?php endif; ?>">
                                    <?php if(!empty($agent)): ?>
                                        <?php echo e($agent->phone); ?>

                                    <?php elseif(!empty($vendor)): ?>
                                        <?php echo e($vendor->phone); ?>

                                    <?php else: ?>
                                        <?php if($admin->show_contact_form && !empty($admin->phone)): ?>
                                            <?php echo e($admin->phone); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </a>
                                <a
                                    href="mailto:<?php if(!empty($agent)): ?> <?php echo e($agent->email); ?>

                                        <?php elseif(!empty($vendor)): ?>
                                            <?php echo e($vendor->email); ?> <?php else: ?> <?php echo e($admin->email); ?> <?php endif; ?>">
                                    <?php if(!empty($agent)): ?>
                                        <?php echo e($agent->email); ?>

                                    <?php elseif(!empty($vendor)): ?>
                                        <?php echo e($vendor->email); ?>

                                    <?php else: ?>
                                        <?php if($admin->show_email_addresss): ?>
                                            <?php echo e($admin->email); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </a>
                            </div>
                        </div>

                        <form action="<?php echo e(route('property_contact')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php if(!empty($agent)): ?>
                                <input type="hidden" name="vendor_id" value="<?php echo e($agent->vendor_id); ?>">
                                <input type="hidden" name="agent_id" value="<?php echo e(!empty($agent) ? $agent->id : ''); ?>">
                            <?php elseif(!empty($vendor) && empty($agent)): ?>
                                <input type="hidden" name="vendor_id" value="<?php echo e($vendor->id); ?>">
                            <?php else: ?>
                                <input type="hidden" name="vendor_id" value="0">
                            <?php endif; ?>
                            <input type="hidden" name="property_id" value="<?php echo e($propertyContent->propertyId); ?>">
                            <div class="form-group mb-20">
                                <input type="text" class="form-control" name="name"
                                    placeholder="<?php echo e(__('Name')); ?>*" required value="<?php echo e(old('name')); ?>">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class=" text-danger"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group mb-20">
                                <input type="email" class="form-control" required name="email"
                                    placeholder="<?php echo e(__('Email Address')); ?>*" value="<?php echo e(old('email')); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class=" text-danger"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group mb-20">
                                <input type="number" class="form-control" name="phone" required
                                    value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Phone Number')); ?>*">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class=" text-danger"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group mb-20">
                                <textarea name="message" id="message" class="form-control" cols="30" rows="8" required=""
                                    data-error="Please enter your message" placeholder="<?php echo e(__('Message')); ?>..."><?php echo e(old('message')); ?></textarea>

                                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class=" text-danger"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php if($info->google_recaptcha_status == 1): ?>
                                <div class="form-group mb-30">
                                    <?php echo NoCaptcha::renderJs(); ?>

                                    <?php echo NoCaptcha::display(); ?>


                                    <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-danger"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            <?php endif; ?>
                            <button type="submit"
                                class="btn btn-md btn-primary w-100"><?php echo e(__('Send message')); ?></button>
                        </form>
                    </div>

                    <div class="widget widget-recent radius-md mb-30 ">
                        <h3 class="title">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#products" aria-expanded="true" aria-controls="products">
                                <?php echo e(__('Related Property')); ?>

                            </button>
                        </h3>
                        <div id="products" class="collapse show">
                            <div class="accordion-body p-0">
                                <?php $__currentLoopData = $relatedProperty; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="product-default product-inline mt-20">
                                        <figure class="product-img">
                                            <a href="<?php echo e(route('frontend.property.details', $property->slug)); ?>"
                                                class="lazy-container ratio ratio-1-1 radius-md">
                                                <img class="lazyload" src="assets/images/placeholder.png"
                                                    data-src="<?php echo e(asset('assets/img/property/featureds/' . $property->featured_image)); ?>">
                                            </a>
                                        </figure>
                                        <div class="product-details">
                                            <h6 class="product-title"><a
                                                    href="<?php echo e(route('frontend.property.details', $property->slug)); ?>"><?php echo e($property->title); ?></a>
                                            </h6>
                                            <span class="product-location icon-start"> <i
                                                    class="fal fa-map-marker-alt"></i>
                                                <?php echo e($property->city->getContent($property->language_id)?->name); ?>

                                                <?php echo e($property->isStateActive ? ', ' . $property->state?->getContent($property->language_id)?->name : ''); ?>

                                                <?php echo e($property->isCountryActive ? ', ' . $property->country?->getContent($property->language_id)?->name : ''); ?></span>
                                            <div class="product-price">

                                                <span class="new-price"><?php echo e(__('Price:')); ?>

                                                    <?php echo e($property->price ? symbolPrice($property->price) : __('Negotiable')); ?></span>
                                            </div>
                                            <ul class="product-info p-0 list-unstyled d-flex align-items-center">
                                                <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                                    title="<?php echo e(__('Area')); ?>">
                                                    <i class="fal fa-vector-square"></i>
                                                    <span><?php echo e($property->area); ?></span>
                                                </li>
                                                <?php if($property->type == 'residential'): ?>
                                                    <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Bed')); ?>">
                                                        <i class="fal fa-bed"></i>
                                                        <span><?php echo e($property->beds); ?> </span>
                                                    </li>
                                                    <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Bath')); ?>">
                                                        <i class="fal fa-bath"></i>
                                                        <span><?php echo e($property->bath); ?> </span>
                                                    </li>
                                                <?php endif; ?>

                                            </ul>
                                        </div>
                                    </div><!-- product-default -->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <?php if(!empty(showAd(2))): ?>
                        <div class="text-center mb-3 mt-3">
                            <?php echo showAd(2); ?>

                        </div>
                    <?php endif; ?>
                </aside>
            </div>
        </div>
    </div>
    </div>

    
    <div class="modal fade" id="socialMediaModal" tabindex="-1" role="dialog" aria-labelledby="socialMediaModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"> <?php echo e(__('Share On')); ?> </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="actions d-flex justify-content-around">
                        <div class="action-btn">
                            <a class="facebook btn"
                                href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(url()->current()); ?>&src=sdkpreparse"><i
                                    class="fab fa-facebook-f"></i></a>
                            <br>
                            <span> <?php echo e(__('Facebook')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>"
                                class="linkedin btn"><i class="fab fa-linkedin-in"></i></a>
                            <br>
                            <span> <?php echo e(__('Linkedin')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="twitter btn"
                                href="https://twitter.com/intent/tweet?text=<?php echo e(url()->current()); ?>"><i
                                    class="fab fa-twitter"></i></a>
                            <br>
                            <span> <?php echo e(__('Twitter')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="whatsapp btn" href="whatsapp://send?text=<?php echo e(url()->current()); ?>"><i
                                    class="fab fa-whatsapp"></i></a>
                            <br>
                            <span> <?php echo e(__('Whatsapp')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="sms btn" href="sms:?body=<?php echo e(url()->current()); ?>" class="sms"><i
                                    class="fas fa-sms"></i></a>
                            <br>
                            <span> <?php echo e(__('SMS')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="mail btn"
                                href="mailto:?subject=Digital Card&body=Check out this digital card <?php echo e(url()->current()); ?>."><i
                                    class="fas fa-at"></i></a>
                            <br>
                            <span> <?php echo e(__('Mail')); ?> </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/property/details.blade.php ENDPATH**/ ?>