<?php
     $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(!empty($pageHeading) ? $pageHeading->property_page_title : __('Property')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_properties); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_properties); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <meta http-equiv="Cache-Control" content="no-store" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Map Start-->
    <div class="map-area border-top header-next pt-30">
        <!-- Background Image -->
        <div class="container">
            <div class="lazy-container radius-md ratio border">
                <div id="main-map"></div>
            </div>
        </div>
    </div>
    <!-- Map End-->

    <!-- Listing Start -->
    <div class="listing-grid pt-40 pb-70">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-xl-3">
                    <div class="widget-offcanvas offcanvas-xl offcanvas-start" tabindex="-1" id="widgetOffcanvas"
                        aria-labelledby="widgetOffcanvas">
                        <div class="offcanvas-header px-20">
                            <h4 class="offcanvas-title"><?php echo e(__('Filter')); ?></h4>
                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                                data-bs-target="#widgetOffcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body p-3 p-xl-0">

                            <aside class="sidebar-widget-area" data-aos="fade-up">
                                <div class="widget widget-select radius-md mb-30">
                                    <h3 class="title">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#type" aria-expanded="true" aria-controls="type">
                                            <?php echo e(__('Property Type')); ?>

                                        </button>
                                    </h3>
                                    <div id="type" class="collapse show">
                                        <div class="accordion-body">
                                            <select name="type" id="" class="form-control form-select mb-20"
                                                onchange="updateURL('type='+$(this).val())">
                                                <option selected disabled><?php echo e(__('Select Type')); ?></option>
                                                <option value="all"
                                                    <?php echo e(request()->filled('type') && request()->input('type') == 'all' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('All')); ?></option>
                                                <option value="residential"
                                                    <?php echo e(request()->filled('type') && request()->input('type') == 'residential' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Residential')); ?></option>
                                                <option value="commercial"
                                                    <?php echo e(request()->filled('type') && request()->input('type') == 'commercial' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Commercial')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="widget widget-categories radius-md mb-30">
                                    <h3 class="title">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#categories" aria-expanded="true" aria-controls="categories">
                                            <?php echo e(__('Categories')); ?>

                                        </button>
                                    </h3>
                                    <div id="categories" class="collapse show">
                                        <div class="accordion-body">
                                            <ul class="list-group">
                                                <li class="list-item">

                                                    <a class="<?php echo e(request()->filled('category') && request()->input('category') == 'all' ? 'active' : ''); ?>"
                                                        onclick="updateURL('category=all')">
                                                        <?php echo e(__('All')); ?> </a>
                                                </li>
                                                <div id="catogoryul">
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($category->categoryContent): ?>
                                                            <li class="list-item">

                                                                <a class="<?php echo e(request()->filled('category') && request()->input('category') == $category->categoryContent?->slug ? 'active' : ''); ?>"
                                                                    onclick="updateURL('category=<?php echo e($category->categoryContent?->slug); ?>');">
                                                                    <?php echo e($category->categoryContent?->name); ?></a>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <form action="<?php echo e(route('frontend.properties')); ?>" method="get" id="searchForm"
                                    class="w-100">
                                    <div class="widget widget-select radius-md mb-30">
                                        <h3 class="title">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#purpose" aria-expanded="true" aria-controls="purpose">
                                                <?php echo e(__('Purpose')); ?>

                                        </h3>
                                        <div id="purpose" class="collapse show">
                                            <div class="accordion-body">
                                                <!-- Add class .list-dropdown form dropdown-menu -->
                                                <select name="purpose" onchange="updateURL('purpose='+$(this).val())"
                                                    id="" class="form-control form-select mb-20">
                                                    <option selected disabled><?php echo e(__('Select Purpose')); ?></option>
                                                    <option value="all"
                                                        <?php echo e(request()->filled('purpose') && request()->input('purpose') == 'all' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('All')); ?></option>
                                                    <option value="rent"
                                                        <?php echo e(request()->filled('purpose') && request()->input('purpose') == 'rent' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Rent')); ?></option>
                                                    <option value="sale"
                                                        <?php echo e(request()->filled('purpose') && request()->input('purpose') == 'sale' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Sale')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="widget widget-select radius-md mb-30">
                                        <h3 class="title">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#select" aria-expanded="true" aria-controls="select">
                                                <?php echo e(__('Property Info')); ?>

                                            </button>
                                        </h3>
                                        <div id="select" class="collapse show">
                                            <div class="accordion-body">
                                                <div class="form-group mb-20">
                                                    <label class="mb-10"><?php echo e(__('Title')); ?></label>
                                                    <input type="text" class="form-control" name="title"
                                                        placeholder="<?php echo e(__('Enter title')); ?>"
                                                        onkeydown="if (event.keyCode == 13) updateURL('title='+$(this).val())">
                                                </div>
                                                <?php if($basicInfo->property_country_status == 1): ?>
                                                    <div class="form-group mb-20">
                                                        <label class="mb-10"><?php echo e(__('Country')); ?></label>
                                                        <select name="country" id=""
                                                            class="form-control country form-select "
                                                            onchange="updateURL('country='+$(this).val())">
                                                            <option selected disabled><?php echo e(__('Select Country')); ?></option>
                                                            <option value="all" data-id="0"><?php echo e(__('All')); ?>

                                                            </option>
                                                            <?php $__currentLoopData = $all_countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option data-id="<?php echo e($country->id); ?>"
                                                                    value="<?php echo e($country->countryContent?->name); ?>">
                                                                    <?php echo e($country->countryContent?->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($basicInfo->property_state_status == 1): ?>
                                                    <div class="form-group mb-20 state">
                                                        <label class="mb-10"><?php echo e(__('State')); ?></label>
                                                        <select name="state_id" id=""
                                                            class="form-control form-select  state_id states"
                                                            onchange="updateURL('state='+$(this).val());getCities(this)">
                                                            <option><?php echo e(__('Select State')); ?></option>
                                                            <?php if($basicInfo->property_country_status != 1 && $basicInfo->property_state_status == 1): ?>
                                                                <?php $__currentLoopData = $all_states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option data-id="<?php echo e($state->id); ?>"
                                                                        value="<?php echo e($state->stateContent?->name); ?>">
                                                                        <?php echo e($state->stateContent?->name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="form-group mb-20 city">
                                                    <label class="mb-10"><?php echo e(__('City')); ?></label>
                                                    <select name="city_id" id=""
                                                        class="form-control form-select  city_id"
                                                        onchange="updateURL('city='+$(this).val())">
                                                        <option><?php echo e(__('Select City')); ?></option>
                                                        <?php if($basicInfo->property_country_status != 1 && $basicInfo->property_state_status != 1): ?>
                                                            <?php $__currentLoopData = $all_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option data-id="<?php echo e($city->id); ?>"
                                                                    value="<?php echo e($city->cityContent?->name); ?>">
                                                                    <?php echo e($city->cityContent?->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </select>
                                                </div>
                                                <div class="form-group mb-20">
                                                    <label class="mb-10"><?php echo e(__('Location')); ?></label>
                                                    <input type="text" class="form-control" name="location"
                                                        placeholder="<?php echo e(__('Enter location')); ?>"
                                                        onkeydown="if (event.keyCode == 13) updateURL('location='+$(this).val())">
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-20">
                                                            <label class="mb-10"> <?php echo e(__('Beds')); ?></label>
                                                            <input type="text" class="form-control" name="beds"
                                                                placeholder="<?php echo e(__('No. of bed')); ?>"
                                                                onkeydown="if (event.keyCode == 13) updateURL('beds='+$(this).val())">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-20">
                                                            <label class="mb-10"> <?php echo e(__('Baths')); ?></label>
                                                            <input type="text" class="form-control" name="baths"
                                                                placeholder="<?php echo e(__('No. of bath')); ?>"
                                                                onkeydown="if (event.keyCode == 13) updateURL('baths='+$(this).val())">
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="form-group mb-20">
                                                    <label class="mb-10"> <?php echo e(__('Area')); ?>

                                                        (<?php echo e(__('Sqft')); ?>.)</label>
                                                    <input type="text" class="form-control"
                                                        placeholder="<?php echo e(__('Enter area')); ?>"
                                                        onkeydown="if (event.keyCode == 13) updateURL('area='+$(this).val())">
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="widget widget-amenities radius-md mb-30">
                                        <h3 class="title">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#amenities" aria-expanded="true"
                                                aria-controls="amenities">
                                                <?php echo e(__('Amenities')); ?>

                                            </button>
                                        </h3>
                                        <div id="amenities" class="collapse show">
                                            <div class="accordion-body">
                                                <ul class="list-group custom-checkbox">
                                                    <?php
                                                        if (!empty(request()->input('amenities'))) {
                                                            $selected_amenities = [];
                                                            if (is_array(request()->input('amenities'))) {
                                                                $selected_amenities = request()->input('amenities');
                                                            } else {
                                                                array_push(
                                                                    $selected_amenities,
                                                                    request()->input('amenities'),
                                                                );
                                                            }
                                                        } else {
                                                            $selected_amenities = [];
                                                        }
                                                    ?>
                                                    <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($amenity->amenityContent): ?>
                                                            <li>
                                                                <input class="input-checkbox" type="checkbox"
                                                                    name="amenities[]" id="checkbox<?php echo e($amenity->id); ?>"
                                                                    value="<?php echo e($amenity->id); ?>"
                                                                    <?php echo e(in_array($amenity->amenityContent?->name, $selected_amenities) ? 'checked' : ''); ?>

                                                                    onchange="updateAmenities('amenities[]=<?php echo e($amenity->amenityContent?->name); ?>',this)">

                                                                <label class="form-check-label"
                                                                    for="checkbox<?php echo e($amenity->id); ?>"><span><?php echo e($amenity->amenityContent?->name); ?></span></label>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="widget widget-type radius-md mb-30">
                                        <h3 class="title">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#pricetype" aria-expanded="true" aria-controls="type">
                                                <?php echo e(__('Pricing Type')); ?>

                                            </button>
                                        </h3>
                                        <div id="pricetype" class="collapse show">
                                            <div class="accordion-body">
                                                <ul class="list-group">
                                                    <li class="list-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input  " type="radio"
                                                                name="price"
                                                                <?php echo e(request()->input('price') == 'all' ? 'checked' : ''); ?>

                                                                onchange="updateURL('price=all',this)" id="exampleRadios"
                                                                value="all" checked>
                                                            <label class="form-check-label" for="exampleRadios">
                                                                <?php echo e(__('All')); ?>

                                                            </label>
                                                        </div>
                                                    </li>

                                                    <li class="list-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input  " type="radio"
                                                                name="price"
                                                                <?php echo e(request()->input('price') == 'fixed' ? 'checked' : ''); ?>

                                                                onchange="updateURL('price=fixed',this)"
                                                                id="exampleRadios1" value="fixed">
                                                            <label class="form-check-label" for="exampleRadios1">
                                                                <?php echo e(__('Fixed Price')); ?>

                                                            </label>
                                                        </div>
                                                    </li>

                                                    <li class="list-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="radio" name="price"
                                                                <?php echo e(request()->input('price') == 'negotiable' ? 'checked' : ''); ?>

                                                                onchange="updateURL('price=negotiable',this)"
                                                                id="exampleRadios2" value="negotiable">
                                                            <label class="form-check-label" for="exampleRadios2">
                                                                <?php echo e(__('Negotiable')); ?>

                                                            </label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>



                                    <div class="widget widget-price radius-md mb-30">
                                        <h3 class="title">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#price" aria-expanded="true" aria-controls="price">
                                                <?php echo e(__('Pricing Filter')); ?>

                                            </button>
                                        </h3>
                                        <input class="form-control" type="hidden"
                                            value="<?php echo e(request()->filled('min') ? request()->input('min') : $min); ?>"
                                            name="min" id="min">
                                        <input class="form-control" type="hidden" value="<?php echo e($min); ?>"
                                            id="o_min">
                                        <input class="form-control" type="hidden" value="<?php echo e($max); ?>"
                                            id="o_max">

                                        <input class="form-control"
                                            value="<?php echo e(request()->filled('max') ? request()->input('max') : $max); ?>"
                                            type="hidden" name="max" id="max">
                                        <input type="hidden" id="currency_symbol"
                                            value="<?php echo e($basicInfo->base_currency_symbol); ?>">

                                        <div id="price" class="collapse show">
                                            <div class="accordion-body">
                                                <div class="price-item">
                                                    <div data-range-slider='priceSlider'></div>
                                                    <div class="price-value">
                                                        <span class="color-primary"><?php echo e(__('Price:')); ?> <span
                                                                data-range-value="priceSliderValue">
                                                                <?php echo e(symbolPrice($min)); ?>

                                                                -
                                                                <?php echo e(symbolPrice($max)); ?>

                                                            </span></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="cta">

                                        <div class="row">
                                            <div class="col-sm-12">
                                                <button onclick="resetURL()" type="button"
                                                    class="btn-text color-primary icon-start mt-10"><i
                                                        class="fal fa-redo"></i><?php echo e(__('Reset Search')); ?></button>
                                            </div>

                                        </div>
                                    </div>
                                </form>
                            </aside>
                        </div>
                    </div>
                </div>
                <div class="col-xl-9">
                    <div class="product-sort-area mb-10" data-aos="fade-up">
                        <div class="row justify-content-sm-end">
                            <div class="col-sm-5 d-xl-none">
                                <button class="btn btn-sm btn-outline icon-end radius-sm mb-15" type="button"
                                    data-bs-toggle="offcanvas" data-bs-target="#widgetOffcanvas"
                                    aria-controls="widgetOffcanvas">
                                    <?php echo e(__('Filter')); ?> <i class="fal fa-filter"></i>
                                </button>
                            </div>
                            <div class="col-sm-7">
                                <ul class="product-sort-list text-sm-end list-unstyled mb-15">
                                    <li class="item">
                                        <div class="sort-item d-flex align-items-center">
                                            <label class="color-dark me-2 font-sm flex-auto"><?php echo e(__('Sort By')); ?> :</label>
                                            <select class="form-select form_control" name="sort"
                                                onchange="updateURL('sort='+$(this).val())">
                                                <option
                                                    <?php echo e(request()->filled('sort') && request()->input('sort') == 'new' ? 'selected' : ''); ?>

                                                    value="new"><?php echo e(__('Newest')); ?></option>
                                                <option
                                                    <?php echo e(request()->filled('sort') && request()->input('sort') == 'old' ? 'selected' : ''); ?>

                                                    value="old"><?php echo e(__('Oldest')); ?></option>
                                                <option
                                                    <?php echo e(request()->filled('sort') && request()->input('sort') == 'low-to-high' ? 'selected' : ''); ?>

                                                    value="low-to-high">
                                                    <?php echo e(__('Price : Low to High')); ?></option>
                                                <option
                                                    <?php echo e(request()->filled('sort') && request()->input('sort') == 'high-to-low' ? 'selected' : ''); ?>

                                                    value="high-to-low"><?php echo e(__('Price : High to Low')); ?></option>
                                            </select>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="row properties">
                        <?php $__empty_1 = true; $__currentLoopData = $property_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property_content,'animate' => false] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-lg-12">
                                <h3 class="text-center mt-5"><?php echo e(__('NO PROPERTY FOUND') . '!'); ?></h3>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-lg-12 pagination justify-content-center customPaginagte">
                                <?php echo e($property_contents->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Listing End -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';
        var property_contents = <?php echo json_encode($property_contents, 15, 512) ?>;
        var properties = property_contents.data;
    </script>
    <!-- Leaflet Map JS -->
    <script src="<?php echo e(asset('/assets/front/js/vendors/leaflet.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/front/js/vendors/leaflet.markercluster.js')); ?>"></script>
    <!-- Map JS -->
    <script src="<?php echo e(asset('/assets/front/js/map.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/front/js/properties.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/property/index.blade.php ENDPATH**/ ?>