<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Edit Property')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Property Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Edit Property')); ?>

                    <?php if($property->type == 'residential'): ?>
                        <?php echo e('(Residential)'); ?>

                    <?php else: ?>
                        <?php echo e('(Commercial)'); ?>

                    <?php endif; ?>
                </a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block"><?php echo e(__('Edit Property')); ?></div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="<?php echo e(route('admin.property_management.properties', ['language' => $defaultLang->code])); ?>">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        <?php echo e(__('Back')); ?>

                    </a>
                    <?php
                        $dContent = App\Models\Property\Content::where('property_id', $property->id)
                            ->where('language_id', $defaultLang->id)
                            ->first();
                        $slug = !empty($dContent) ? $dContent->slug : '';
                    ?>
                    <?php if($dContent): ?>
                        <a class="btn btn-success btn-sm float-right mr-1 d-inline-block"
                            href="<?php echo e(route('frontend.property.details', ['slug' => $slug])); ?>" target="_blank">
                            <span class="btn-label">
                                <i class="fas fa-eye"></i>
                            </span>
                            <?php echo e(__('Preview')); ?>

                        </a>
                    <?php endif; ?>

                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="alert alert-danger pb-1 dis-none" id="carErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>

                            <div class="col-lg-12">
                                <label for=""
                                    class="mb-2"><strong><?php echo e(__('Gallery Images') . '*'); ?></strong></label>
                                <div id="reload-slider-div">
                                    <div class="row">

                                        <div class="col-12">
                                            <table class="table table-striped" id="imgtable">

                                                <?php $__currentLoopData = $galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="trdb table-row" id="trdb<?php echo e($item->id); ?>">
                                                        <td>
                                                            <div class="">
                                                                <img class="thumb-preview wf-150"
                                                                    src="<?php echo e(asset('assets/img/property/slider-images/' . $item->image)); ?>"
                                                                    alt="Ad Image">
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <i class="fa fa-times rmvbtndb"
                                                                data-indb="<?php echo e($item->id); ?>"></i>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <form action="<?php echo e(route('admin.property.imagesstore')); ?>" id="my-dropzone"
                                    enctype="multipart/formdata" class="dropzone create">
                                    <?php echo csrf_field(); ?>
                                    <div class="fallback">
                                        <input name="file" type="file" multiple />
                                    </div>
                                    <input type="hidden" value="<?php echo e($property->id); ?>" name="property_id">
                                </form>
                                <p class="em text-danger mb-0" id="errslider_images"></p>

                            </div>

                            <form id="carForm"
                                action="<?php echo e(route('admin.property_management.update_property', $property->id)); ?>"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="property_id" value="<?php echo e($property->id); ?>">
                                <input type="hidden" name="type" value="<?php echo e($property->type); ?>">
                                <input type="hidden" name="vendor_id" value="<?php echo e($property->vendor_id); ?>">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Thumbnail Image') . '*'); ?></label>
                                            <br>
                                            <div class="thumb-preview">
                                                <img src="<?php echo e($property->featured_image ? asset('assets/img/property/featureds/' . $property->featured_image) : asset('assets/img/noimage.jpg')); ?>"
                                                    alt="..." class="uploaded-img">
                                            </div>
                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input" name="featured_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Floor Planning Image')); ?></label>
                                            <br>
                                            <div class="thumb-preview remove">

                                                <img src="<?php echo e(!empty($property->floor_planning_image) ? asset('assets/img/property/plannings/' . $property->floor_planning_image) : asset('assets/img/noimage.jpg')); ?>"
                                                    alt="..." class="uploaded-img2">
                                                <?php if(!empty($property->floor_planning_image)): ?>
                                                    <i class="fas fa-times text-danger rmvflrImg"
                                                        data-indb="<?php echo e($property->id); ?>"></i>
                                                <?php endif; ?>
                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input2" name="floor_planning_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Video Image')); ?></label>
                                            <br>
                                            <div class="thumb-preview remove">

                                                <img src="<?php echo e(!empty($property->video_image) ? asset('assets/img/property/video/' . $property->video_image) : asset('assets/img/noimage.jpg')); ?>"
                                                    alt="..." class="uploaded-img3">
                                                <?php if(!empty($property->video_image)): ?>
                                                    <i class="fas fa-times text-danger rmvvdoImg"
                                                        data-indb="<?php echo e($property->id); ?>"></i>
                                                <?php endif; ?>
                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input3" name="video_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Video Url')); ?> </label>
                                            <input type="text" class="form-control" name="video_url"
                                                placeholder="Enter video url" value="<?php echo e($property->video_url); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Purpose')); ?>*</label>

                                            <select name="purpose" class="form-control">
                                                <option disabled> <?php echo e(__('Select a Purpose')); ?> </option>
                                                <option value="rent" <?php if($property->purpose == 'rent'): ?> 'selected' <?php endif; ?>>
                                                    <?php echo e(__('Rent')); ?>

                                                </option>
                                                <option value="sale" <?php if($property->purpose == 'sale'): ?> 'selected' <?php endif; ?>>
                                                    <?php echo e(__('Sale')); ?>

                                                </option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group ">
                                            <label><?php echo e(__('Category')); ?> *</label>
                                            <select name="category_id" class="form-control category">
                                                <option disabled selected>
                                                    <?php echo e(__('Select a Category')); ?>

                                                </option>

                                                <?php $__currentLoopData = $propertyCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($category->id); ?>"
                                                        <?php echo e($property->category_id == $category->id ? 'selected' : ''); ?>>
                                                        <?php echo e($category->categoryContent->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <?php if($propertySettings->property_country_status == 1): ?>
                                        <div class="col-lg-3">
                                            <div class="form-group ">

                                                <label><?php echo e(__('Country')); ?> *</label>
                                                <select name="country_id"
                                                    class="form-control country js-example-basic-single3">
                                                    <option disabled selected><?php echo e(__('Select Country')); ?>

                                                    </option>

                                                    <?php $__currentLoopData = $propertyCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($country->id); ?>"
                                                            <?php echo e($property->country_id == $country->id ? 'selected' : ''); ?>>
                                                            <?php echo e($country->countryContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($propertySettings->property_state_status == 1): ?>
                                        <div class="col-lg-3 state"
                                            <?php if(is_null($property->state_id)): ?> style="display:none !important;" <?php else: ?> style="display:block !important;" <?php endif; ?>>
                                            <div class="form-group">

                                                <label><?php echo e(__('State')); ?> *</label>
                                                <select onchange="getCities(event)" name="state_id"
                                                    class="form-control  state_id states js-example-basic-single3">
                                                    <option disabled><?php echo e(__('Select State')); ?>

                                                    </option>
                                                    <?php if($property->state_id): ?>
                                                        <?php $__currentLoopData = $propertyStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($state->id); ?>"
                                                                <?php echo e($property->state_id == $state->id ? 'selected' : ''); ?>>
                                                                <?php echo e($state?->stateContent->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>


                                                </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-lg-3 city"
                                        <?php if(empty($property->city_id)): ?> style="display:none;"<?php else: ?> style="display:block;" <?php endif; ?>>
                                        <div class="form-group ">

                                            <label><?php echo e(__('City')); ?> *</label>
                                            <select name="city_id" class="form-control city_id js-example-basic-single3">
                                                <option value="" disabled><?php echo e(__('Select City')); ?>

                                                </option>
                                                <?php if($property->city_id): ?>
                                                    <?php $__currentLoopData = $propertyCities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($property->city_id); ?>"
                                                            <?php echo e($property->city_id == $city->id ? 'selected' : ''); ?>>
                                                            <?php echo e($city?->cityContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Amenities')); ?>*</label>
                                            <select name="amenities[]" class="form-control js-example-basic-single2"
                                                multiple="multiple">
                                                <option value="" disabled>
                                                    <?php echo e(__('Please Select Amenities')); ?>

                                                </option>
                                                <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($amenity->id); ?>"
                                                        <?php $__currentLoopData = $propertyAmenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $propertyAmenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($propertyAmenity->amenity_id == $amenity->id ? 'selected' : ''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>>
                                                        <?php echo e($amenity->amenityContent->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Price') . ' (' . $settings->base_currency_text . ')'); ?> </label>
                                            <input type="number" class="form-control" name="price"
                                                placeholder="Enter Current Price" value="<?php echo e($property->price); ?>">
                                            <p class="text-warning">
                                                <?php echo e(__('If you leave it blank, price will be negotiable.')); ?>

                                            </p>
                                        </div>
                                    </div>


                                    <?php if($property->type == 'residential'): ?>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label><?php echo e(__('Beds')); ?> *</label>
                                                <input type="text" class="form-control" name="beds"
                                                    value="<?php echo e($property->beds); ?>" placeholder="Enter number of bed">
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label><?php echo e(__('Baths')); ?> *</label>
                                                <input type="text" class="form-control" name="bath"
                                                    value="<?php echo e($property->bath); ?>" placeholder="Enter number of bath">
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Area (sqft)')); ?> *</label>
                                            <input type="text" class="form-control" name="area"
                                                value="<?php echo e($property->area); ?>" placeholder="Enter area (sqft) ">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Status')); ?> *</label>
                                            <select name="status" id="" class="form-control">
                                                <option <?php echo e($property->status == 1 ? 'selected' : ''); ?> value="1">
                                                    <?php echo e(__('Active')); ?></option>
                                                <option <?php echo e($property->status == 0 ? 'selected' : ''); ?> value="0">
                                                    <?php echo e(__('Inactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Latitude')); ?> *</label>
                                            <input type="text" class="form-control" value="<?php echo e($property->latitude); ?>"
                                                name="latitude" placeholder="Enter Latitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Longitude')); ?> *</label>
                                            <input type="text" class="form-control"
                                                value="<?php echo e($property->longitude); ?>" name="longitude"
                                                placeholder="Enter Longitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Vendor')); ?></label>
                                            <select name="vendor_id" class="form-control vendor js-example-basic-single1">
                                                <option value="0" selected><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e($property->vendor_id == $item->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->username); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <?php
                                        $agents = App\Models\Agent::where('vendor_id', $property->vendor_id)
                                            ->select('id', 'username')
                                            ->get();
                                    ?>
                                    <div class="col-lg-3">
                                        <div class="form-group agent <?php if(empty($property->agent_id)): ?> d-none <?php endif; ?>">
                                            <label for=""><?php echo e(__('Agent')); ?></label>
                                            <select name="agent_id" class="form-control agent_id js-example-basic-single1">
                                                <option value="" selected><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($agent->id); ?>"
                                                        <?php echo e($agent->id == $property->agent_id ? 'selected' : ''); ?>>
                                                        <?php echo e($agent->username); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any agent, then this property will be listed under Vendor')); ?>

                                            </p>
                                        </div>
                                    </div>


                                </div>

                                <div id="accordion" class="mt-3">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $peopertyContent = App\Models\Property\Content::where(
                                                'property_id',
                                                $property->id,
                                            )
                                                ->where('language_id', $language->id)
                                                ->first();

                                        ?>
                                        <div class="version">
                                            <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                <h5 class="mb-0">
                                                    <button type="button" class="btn btn-link" data-toggle="collapse"
                                                        data-target="#collapse<?php echo e($language->id); ?>"
                                                        aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                        aria-controls="collapse<?php echo e($language->id); ?>">
                                                        <?php echo e($language->name . __(' Language')); ?>

                                                        <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                    </button>
                                                </h5>
                                            </div>

                                            <div id="collapse<?php echo e($language->id); ?>"
                                                class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                aria-labelledby="heading<?php echo e($language->id); ?>" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Title*')); ?></label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_title"
                                                                    placeholder="Enter Title"
                                                                    value="<?php echo e($peopertyContent ? $peopertyContent->title : ''); ?>">
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Address') . '*'); ?> </label>
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_address"
                                                                    placeholder="Enter Address"
                                                                    value="<?php echo e(@$peopertyContent->address); ?>"
                                                                    class="form-control">
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Description')); ?> *</label>
                                                                <textarea class="form-control summernote " id="<?php echo e($language->code); ?>_description"
                                                                    name="<?php echo e($language->code); ?>_description" data-height="300"><?php echo e(@$peopertyContent->description); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Keywords')); ?> *</label>
                                                                <input class="form-control"
                                                                    name="<?php echo e($language->code); ?>_meta_keyword"
                                                                    placeholder="Enter Meta Keywords"
                                                                    data-role="tagsinput"
                                                                    value="<?php echo e($peopertyContent ? $peopertyContent->meta_keyword : ''); ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Description')); ?> *</label>
                                                                <textarea class="form-control" name="<?php echo e($language->code); ?>_meta_description" rows="5"
                                                                    placeholder="Enter Meta Description"><?php echo e($peopertyContent ? $peopertyContent->meta_description : ''); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col">
                                                            <?php $currLang = $language; ?>

                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($language->id == $currLang->id) continue; ?> 
                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            onchange="cloneInput('collapse<?php echo e($currLang->id); ?>', 'collapse<?php echo e($language->id); ?>', event)">
                                                                        <span
                                                                            class="form-check-sign"><?php echo e(__('Clone for')); ?>

                                                                            <strong
                                                                                class="text-capitalize text-secondary"><?php echo e($language->name); ?></strong>
                                                                            <?php echo e(__('language')); ?></span>
                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12" id="variation_pricing">
                                        <h4 for=""><?php echo e(__('Additional Features (Optional)')); ?></h4>
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Label')); ?></th>
                                                    <th><?php echo e(__('Value')); ?></th>
                                                    <th><a href="javascrit:void(0)"
                                                            class="btn  btn-sm btn-success addRow"><i
                                                                class="fas fa-plus-circle"></i></a></th>
                                                </tr>
                                            <tbody id="tbody">

                                                <?php if(count($specifications) > 0): ?>
                                                    <?php $__currentLoopData = $specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td>
                                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $sp_content = App\Models\Property\SpacificationCotent::where(
                                                                            [
                                                                                ['language_id', $language->id],
                                                                                [
                                                                                    'property_spacification_id',
                                                                                    $specification->id,
                                                                                ],
                                                                            ],
                                                                        )->first();
                                                                    ?>
                                                                    <div
                                                                        class="form-group  <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <input type="text"
                                                                            name="<?php echo e($language->code); ?>_label[]"
                                                                            value="<?php echo e(@$sp_content->label); ?>"
                                                                            class="form-control"
                                                                            placeholder="Label (<?php echo e($language->name); ?>)">
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </td>
                                                            <td>
                                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $sp_content = App\Models\Property\SpacificationCotent::where(
                                                                            [
                                                                                ['language_id', $language->id],
                                                                                [
                                                                                    'property_spacification_id',
                                                                                    $specification->id,
                                                                                ],
                                                                            ],
                                                                        )->first();
                                                                    ?>
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <input type="text"
                                                                            name="<?php echo e($language->code); ?>_value[]"
                                                                            value="<?php echo e(@$sp_content->value); ?>"
                                                                            class="form-control"
                                                                            placeholder="Value (<?php echo e($language->name); ?>)">
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </td>
                                                            <td>
                                                                <a href="javascript:void(0)"
                                                                    data-specification="<?php echo e($specification->id); ?>"
                                                                    class="btn  btn-sm btn-danger deleteSpecification">
                                                                    <i class="fas fa-minus"></i></a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td>
                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div
                                                                    class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                    <input type="text"
                                                                        name="<?php echo e($language->code); ?>_label[]"
                                                                        class="form-control"
                                                                        placeholder="Label (<?php echo e($language->name); ?>)">
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div
                                                                    class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                    <input type="text"
                                                                        name="<?php echo e($language->code); ?>_value[]"
                                                                        class="form-control"
                                                                        placeholder="Value (<?php echo e($language->name); ?>)">
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <a href="javascript:void(0)"
                                                                class="btn btn-danger  btn-sm deleteRow">
                                                                <i class="fas fa-minus"></i></a>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                            </thead>
                                        </table>
                                    </div>
                                </div>

                                <div id="sliders"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="PropertySubmit" class="btn btn-primary">
                                <?php echo e(__('Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php
    $languages = App\Models\Language::get();
    $labels = '';
    $values = '';
    foreach ($languages as $language) {
        $label_name = $language->code . '_label[]';
        $value_name = $language->code . '_value[]';
        if ($language->direction == 1) {
            $direction = 'form-group rtl text-right';
        } else {
            $direction = 'form-group';
        }

        $labels .=
            "<div class='$direction'><input type='text' name='" .
            $label_name .
            "' class='form-control' placeholder='Label ($language->name)'></div>";
        $values .= "<div class='$direction'><input type='text' name='$value_name' class='form-control' placeholder='Value ($language->name)'></div>";
    }
?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';
        var labels = "<?php echo $labels; ?>";
        var values = "<?php echo $values; ?>";
        var stateUrl = "<?php echo e(route('admin.property_specification.get_state_cities')); ?>";
        var cityUrl = "<?php echo e(route('admin.property_specification.get_cities')); ?>";
        var storeUrl = "<?php echo e(route('admin.property.imagesupdate', ['vendor_id' => $property->vendor_id])); ?>";
        var removeUrl = "<?php echo e(route('admin.property.imagermv')); ?>";
        var rmvdbUrl = "<?php echo e(route('admin.property.imgdbrmv')); ?>";
        let agentUrl = "<?php echo e(route('admin.property_management.get_agent')); ?>";
        var specificationRmvUrl = "<?php echo e(route('admin.property_management.specification_delete')); ?>";

        let galleryImages = <?php echo e($uploadGImg); ?>;
    </script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-dropzone.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/property.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/property/edit.blade.php ENDPATH**/ ?>