<?php
    $version = $basicInfo->theme_version;
?>

<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(__('Forget Password')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_forget_password); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_forget_password); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->forget_password_page_title : __('Forget Password'),
        'subtitle' => __('Forget Password'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->forget_password_page_title : __('Forget Password'),
        'subtitle' => __('Forget Password'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- Authentication-area start -->
    <div class="authentication-area ptb-100">
        <div class="container">
            <div class="auth-form border radius-md">
                <?php if(Session::has('success')): ?>
                    <div class="alert alert-success"><?php echo e(__(Session::get('success'))); ?></div>
                <?php endif; ?>
                <?php if(Session::has('warning')): ?>
                    <div class="alert alert-success"><?php echo e(__(Session::get('warning'))); ?></div>
                <?php endif; ?>
                <form action="<?php echo e(route('user.send_forget_password_mail')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="title">
                        <h4 class="mb-20"><?php echo e(__('Forget Password')); ?></h4>
                    </div>
                    <div class="form-group mb-30">
                        <input type="text" class="form-control" name="email" placeholder="<?php echo e(__('Email Address')); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger mt-2"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <?php if($bs->google_recaptcha_status == 1): ?>
                        <div class="form-group mb-30">
                            <?php echo NoCaptcha::renderJs(); ?>

                            <?php echo NoCaptcha::display(); ?>


                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-danger"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>
                    <button type="submit"
                        class="btn btn-lg btn-primary radius-md w-100"><?php echo e(__('Send me a recovery link')); ?></button>
                </form>
            </div>
        </div>
    </div>
    <!-- Authentication-area end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/user/forget-password.blade.php ENDPATH**/ ?>