<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(!empty($pageHeading) ? $pageHeading->project_page_title : __('Projects')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keywords_projects); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_projects); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->project_page_title : __('Projects'),
        'subtitle' => __('Projects'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->project_page_title : __('Projects'),
        'subtitle' => __('Projects'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="projects-area pt-100 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="product-sort-area mb-20" data-aos="fade-up">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <form action="<?php echo e(route('frontend.projects')); ?>" method="GET">
                                    <div class="project-filter-form radius-md pb-10">
                                        <div class="row">
                                            <div class="col-lg-4 mb-10">
                                                <input type="search" name="title" class="form-control"
                                                    placeholder="<?php echo e(__('Search By Title')); ?>"
                                                    value="<?php echo e(request()->input('title')); ?>">
                                            </div>
                                            <div class="col-lg-4 mb-10">
                                                <input type="search" name="location" class="form-control"
                                                    placeholder="<?php echo e(__('Search By Location')); ?>"
                                                    value="<?php echo e(request()->input('location')); ?>">
                                            </div>
                                            <div class="col-lg-3 mb-10">
                                                <button class="btn btn-lg btn-primary w-100" type="submit">
                                                    <i class="far fa-search"></i> <?php echo e(__('Search')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="col-lg-4 mb-20">
                                <ul class="product-sort-list text-lg-end list-unstyled">
                                    <li class="item">
                                        <form action="<?php echo e(route('frontend.projects')); ?>" method="GET" onchange="submit();">
                                            <div class="sort-item d-flex align-items-center">
                                                <label class="color-dark me-2"><?php echo e(__('Sort By')); ?>:</label>
                                                <select class="nice-select" name="sort">
                                                    <option value="new"><?php echo e(__('Newest')); ?> </option>
                                                    <option value="old"><?php echo e(__('Oldest')); ?> </option>
                                                    <option value="high-to-low"><?php echo e(__('High to Low')); ?></option>
                                                    <option value="low-to-high"><?php echo e(__('Low to High')); ?></option>

                                                </select>
                                            </div>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-lg-4 col-sm-6" data-aos="fade-up" data-aos-delay="100">
                                <a href="<?php echo e(route('frontend.projects.details', ['slug' => $project->slug])); ?>">
                                    <div class="card mb-30 product-default">
                                        <div class="card-img">
                                            <div class="lazy-container ratio ratio-1-3">
                                                <img class="lazyload"
                                                    data-src="<?php echo e(asset('assets/img/project/featured/' . $project->featured_image)); ?>">
                                            </div>
                                            <span class="label">
                                                <?php if($project->status == 0): ?>
                                                    <?php echo e(__('Under Construction')); ?>

                                                <?php elseif($project->status == 1): ?>
                                                    <?php echo e(__('Complete')); ?>

                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        <div class="card-text text-center p-3">
                                            <h3 class="card-title product-title color-white mb-1">
                                                <?php echo e($project->title); ?>


                                            </h3>
                                            <span class="location icon-start"><i
                                                    class="fal fa-map-marker-alt"></i><?php echo e($project->address); ?></span>
                                            <br>
                                            <span class="price"> <?php echo e(symbolPrice($project->min_price)); ?>

                                                <?php echo e(!empty($project->max_price) ? ' - ' . symbolPrice($project->max_price) : ''); ?>


                                            </span>


                                            <?php if($project->agent): ?>
                                                <a class="color-medium"
                                                    href="<?php echo e(route('frontend.agent.details', ['username' => $project->agent->username])); ?>"
                                                    target="_self">
                                                    <div class="user rounded-pill mt-10">
                                                        <div class="user-img lazy-container ratio ratio-1-1 rounded-pill">
                                                            <img class="lazyload"
                                                                data-src="<?php echo e($project->agent->image ? asset('assets/img/agents/' . $project->agent->image) : asset('assets/img/blank-user.jpg')); ?>"
                                                                src="<?php echo e($project->agent->image ? asset('assets/img/agents/' . $project->agent->image) : asset('assets/img/blank-user.jpg')); ?>">
                                                        </div>
                                                        <div class="user-info">
                                                            <span><?php echo e($project->agent->username); ?></span>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php elseif($project->vendor): ?>
                                                <a class="color-medium"
                                                    href="<?php echo e(route('frontend.vendor.details', ['username' => $project->vendor->username])); ?>"
                                                    target="_self">
                                                    <div class="user rounded-pill mt-10">
                                                        <div class="user-img lazy-container ratio ratio-1-1 rounded-pill">
                                                            <img class="lazyload"
                                                                data-src="<?php echo e($project->vendor->photo ? asset('assets/admin/img/vendor-photo/' . $project->vendor->photo) : asset('assets/img/blank-user.jpg')); ?>"
                                                                src="<?php echo e($project->vendor->photo ? asset('assets/admin/img/vendor-photo/' . $project->vendor->photo) : asset('assets/img/blank-user.jpg')); ?>">
                                                        </div>
                                                        <div class="user-info">
                                                            <span><?php echo e($project->vendor->username); ?></span>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php elseif($project->vendor_id == 0): ?>
                                                <?php
                                                    $admin = App\Models\Admin::where('role_id', null)
                                                        ->with('adminInfo')
                                                        ->first();
                                                ?>

                                                <a class="color-medium"
                                                    href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>"
                                                    target="_self">
                                                    <div class="user rounded-pill mt-10">
                                                        <div class="user-img lazy-container ratio ratio-1-1 rounded-pill">
                                                            <img class=" lazyload"
                                                                data-src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>"
                                                                src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>">
                                                        </div>
                                                        <div class="user-info">
                                                            <span><?php echo e($admin->username); ?></span>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-lg-12">
                                <h3 class="text-center mt-5"> <?php echo e(__('No Project Found')); ?></h3>
                            </div>
                        <?php endif; ?>

                    </div>

                    <div class="pagination mb-30 justify-content-center">
                        <?php echo e($projects->links()); ?>


                    </div>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mt-4">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/project/index.blade.php ENDPATH**/ ?>