<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e($vendor->username); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('metaKeywords'); ?>
    <?php echo e($vendor->username); ?>, <?php echo e(!request()->filled('admin') ? @$vendorInfo->name : ''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php echo e(!request()->filled('admin') ? @$vendorInfo->details : ''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
        'subtitle' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
        'subtitle' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="agent-single pt-100 pb-60">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-lg-9">
                    <div class="row agent-single-box align-items-center mb-10 gx-xl-5" data-aos="fade-up">
                        <figure class="agent-img col-lg-6 mb-30">
                            <a class="lazy-container radius-md ratio ratio-1-1">
                                <?php if(request()->input('admin') == true): ?>
                                    <img class="lazyload"
                                        data-src="<?php echo e($vendor->image ? asset('assets/img/admins/' . $vendor->image) : asset('assets/img/blank-user.jpg')); ?>">
                                <?php elseif($vendor->photo != null): ?>
                                    <img class="lazyload"
                                        data-src="<?php echo e(asset('assets/admin/img/vendor-photo/' . $vendor->photo)); ?>">
                                <?php else: ?>
                                    <img class="lazyload" data-src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>">
                                <?php endif; ?>

                            </a>
                        </figure>
                        <div class="agent-details col-lg-6 mb-30">
                            <span class="label radius-sm"><?php echo e($vendor->username); ?></span>
                            <div class="mb-15"></div>
                            <h2 class="agent-title m-0">
                                <?php echo e(request()->input('admin') == true ? $vendor->adminInfo?->first_name . ' ' . $vendor->adminInfo?->last_name : @$vendorInfo->name); ?>


                            </h2>

                            <ul class="agent-info list-unstyled p-0 ">
                                <?php if($vendor->show_phone_number == 1): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-mobile-android"></i>
                                            <span><?php echo e(__('Phone')); ?>:</span>
                                        </div>
                                        <div>
                                            <a href="tel:<?php echo e($vendor->phone); ?>"><?php echo e($vendor->phone); ?></a>
                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if($vendor->show_email_addresss == 1): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-envelope"></i>
                                            <span><?php echo e(__('Email')); ?>:</span>
                                        </div>
                                        <div>
                                            <a href="mailTo:<?php echo e($vendor->email); ?>"><?php echo e($vendor->email); ?>

                                            </a>
                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if(request()->input('admin') != true): ?>
                                    <?php if(!is_null(@$vendorInfo->city)): ?>
                                        <li class="icon-start">
                                            <div>
                                                <i class="fal fa-map-marker-alt"></i>
                                                <span><?php echo e(__('City')); ?>:</span>
                                            </div>
                                            <div>
                                                <?php echo e(@$vendorInfo->city); ?>

                                            </div>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(!is_null(@$vendorInfo->state)): ?>
                                        <li class="icon-start">
                                            <div>
                                                <i class="fal fa-map-marker-alt"></i>
                                                <span><?php echo e(__('State')); ?>:</span>
                                            </div>
                                            <div>
                                                <?php echo e(@$vendorInfo->state); ?>

                                            </div>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(!is_null(@$vendorInfo->country)): ?>
                                        <li class="icon-start">
                                            <div>
                                                <i class="fal fa-map-marker-alt"></i>
                                                <span><?php echo e(__('Country') . ':'); ?></span>
                                            </div>
                                            <div>
                                                <?php echo e(@$vendorInfo->country); ?>

                                            </div>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <li class="icon-start">

                                    <?php if(request()->input('admin') == true): ?>
                                        <?php if($vendor->address != null): ?>
                                            <div>
                                                <i class="fal fa-map-marker-alt"></i>
                                                <span><?php echo e(__('Address') . ' : '); ?></span>
                                            </div>
                                            <div class="icon-start">
                                                <?php echo e($vendor->address); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php if(@$vendorInfo->address != null): ?>
                                            <div>
                                                <i class="fal fa-map-marker-alt"></i>
                                                <span><?php echo e(__('Address') . ' : '); ?></span>
                                            </div>
                                            <div class="icon-start">
                                                <?php echo e(@$vendorInfo->address); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </li>


                                <?php if(request()->input('admin') != true): ?>
                                    <li class="icon-start">
                                        <div>
                                            <i class="fal fa-calendar-day"></i>
                                            <span><?php echo e(__('Member since') . ':'); ?></span>
                                        </div>
                                        <div>
                                            <?php echo e(\Carbon\Carbon::parse($vendor->created_at)->format('F Y')); ?>

                                        </div>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <div class="d-flex flex-wrap lign-items-center mt-20 gap-15">
                                <?php if($vendor->show_email_addresss == 1): ?>
                                    <a href="mailTo:<?php echo e($vendor->email); ?>"
                                        class="btn btn-lg btn-primary"><?php echo e(__('Send Email')); ?></a>
                                <?php endif; ?>
                                <?php if($vendor->show_phone_number == 1): ?>
                                    <a href="tel:<?php echo e($vendor->phone); ?>"
                                        class="btn btn-lg btn-outline"><?php echo e(__('Call Now')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div><!-- agent-default -->


                    <?php if(request()->input('admin') == true): ?>
                        <?php if(!is_null($vendor->adminInfo?->details)): ?>
                            <div class="agent-single-details">
                                <div class="mb-20"></div>
                                <div class="agent-desc mb-40">
                                    <h3 class="mb-20"><?php echo e(__('About')); ?></h3>
                                    <p>
                                        <?php echo e($vendor->adminInfo?->details); ?>

                                    </p>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if(!is_null(@$vendorInfo->details)): ?>
                            <div class="agent-single-details">
                                <div class="mb-20"></div>
                                <div class="agent-desc mb-40">
                                    <h3 class="mb-20"><?php echo e(__('About')); ?></h3>
                                    <p>
                                        <?php echo e(@$vendorInfo->details); ?>

                                    </p>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>


                    <div class="agent-listing pb-10">
                        <h3 class="mb-20"><?php echo e(__('My Properties') . ' (' . count($all_properties) . ')'); ?></h3>

                        <div class="row ">
                            <div class="col-lg-12">

                                <div class="tabs-navigation tabs-navigation-2 mb-20">
                                    <ul class="nav nav-tabs">
                                        <li class="nav-item">
                                            <button class="nav-link active btn-md" data-bs-toggle="tab"
                                                data-bs-target="#tab_all"
                                                type="button"><?php echo e(__('All Properties')); ?></button>
                                        </li>

                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($category->properties()->count() > 0 && $category->categoryContent): ?>
                                                <li class="nav-item">
                                                    <button class="nav-link btn-md" data-bs-toggle="tab"
                                                        data-bs-target="#tab_<?php echo e($category->id); ?>"
                                                        type="button"><?php echo e($category->categoryContent?->name); ?></button>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <div class="tab-content" data-aos="fade-up">
                                    <div class="tab-pane fade show active" id="tab_all">
                                        <div class="row">

                                            <?php $__currentLoopData = $all_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div>
                                    </div>

                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if (request()->has('admin')) {
                                                $vendorId = 0;
                                            } else {
                                                $vendorId = $vendor->id;
                                            }

                                            $category_id = $category->id;
                                            $Cproperties = App\Models\Property\Property::join(
                                                'property_contents',
                                                'property_contents.property_id',
                                                'properties.id',
                                            )
                                                ->where('vendor_id', $vendorId)
                                                ->with([
                                                    'propertyContent' => function ($q) use ($language) {
                                                        $q->where('language_id', $language->id);
                                                    },
                                                ])
                                                ->where('property_contents.language_id', $language->id)
                                                ->where([['properties.status', 1], ['properties.approve_status', 1]])
                                                ->orderBy('properties.id', 'desc')
                                                ->select('properties.*')
                                                ->get();

                                        ?>
                                        <?php if(count($Cproperties) > 0): ?>
                                            <div class="tab-pane fade" id="tab_<?php echo e($category->id); ?>">

                                                <div class="row">
                                                    <?php $__currentLoopData = $Cproperties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($property->category_id == $category->id): ?>
                                                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="agent-listing projects-area pb-10">
                        <h3 class="mb-20"><?php echo e(__('My Projects') . ' (' . count($all_projects) . ')'); ?></h3>
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $all_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-lg-4 col-sm-6" data-aos="fade-up" data-aos-delay="100">
                                    <a href="<?php echo e(route('frontend.projects.details', ['slug' => $project->slug])); ?>">
                                        <div class="card mb-30">
                                            <div class="card-img">
                                                <div class="lazy-container ratio ratio-1-3">
                                                    <img class="lazyload" src="assets/images/placeholder.png"
                                                        data-src="<?php echo e(asset('assets/img/project/featured/' . $project->featured_image)); ?>">
                                                </div>
                                                <span class="label">
                                                    <?php if($project->status == 0): ?>
                                                        <?php echo e(__('Under Construction')); ?>

                                                    <?php elseif($project->status == 1): ?>
                                                        <?php echo e(__('Complete')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="card-text text-center p-3">
                                                <h3 class="card-title color-white mb-1">
                                                    <?php echo e(strlen($project->title) > 50 ? mb_substr($project->title, 0, 50, 'utf-8') . '...' : $project->title); ?>

                                                </h3>
                                                <span class="location icon-start"><i
                                                        class="fal fa-map-marker-alt"></i><?php echo e($project->address); ?></span>
                                                <span class="price"> <?php echo e(symbolPrice($project->min_price)); ?>

                                                    <?php echo e(!empty($project->max_price) ? ' - ' . symbolPrice($project->max_price) : ''); ?>


                                                </span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-lg-12">
                                    <h3 class="text-center mt-5"> <?php echo e(__('No Projects Found')); ?></h3>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if(count($agents) > 0): ?>
                        <div class="row mb-40">
                            <div class="col-12">
                                <h3 class="mb-20"><?php echo e(__('My Agents') . ' (' . count($agents) . ')'); ?></h3>
                                <div class="swiper agent-slider agent-slider-two" data-aos="fade-up">
                                    <div class="swiper-wrapper">
                                        <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="swiper-slide">
                                                <div class="agent-box radius-md">
                                                    <div class="agent-img">
                                                        <figure>
                                                            <a href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>"
                                                                class="lazy-container ratio ratio-1-2">
                                                                <img class="lazyload"
                                                                    src="  <?php echo e(asset('assets/front/')); ?>/images/placeholder.png"
                                                                    data-src="  <?php echo e(asset('assets/img/agents/' . $agent->image)); ?> "
                                                                    alt="agent">
                                                            </a>
                                                        </figure>
                                                        <div
                                                            class="agent-ratings d-flex align-items-center justify-content-between">

                                                            <span class="label bg-primary"><?php echo e(__('Real Estate')); ?></span>
                                                        </div>

                                                    </div>
                                                    <div class="agent-details text-center">
                                                        <span
                                                            class="color-primary font-sm"><?php echo e(count($agent->properties->where('approve_status', 1))); ?>

                                                            <?php echo e(__('Properties')); ?></span> |

                                                        <span
                                                            class="color-primary font-sm"><?php echo e(count($agent->projects->where('approve_status', 1))); ?>

                                                            <?php echo e(__('Projects')); ?></span>
                                                        <h4 class="agent-title"><a
                                                                href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>"><?php echo e($agent->agent_info?->first_name . ' ' . $agent->agent_info?->last_name); ?></a>
                                                        </h4>
                                                        <ul class="agent-info list-unstyled p-0 ">
                                                            <?php if($agent->show_phone_number == 1): ?>
                                                                <?php if($agent->phone): ?>
                                                                    <li class="icon-start d-block">
                                                                        <a href="tel:<?php echo e($agent->phone); ?>"><i
                                                                                class="fal fa-mobile-android color-primary"></i>
                                                                            <?php echo e($agent->phone); ?></a>
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                            <?php if($agent->show_email_addresss == 1): ?>
                                                                <?php if($agent->email): ?>
                                                                    <li class="icon-start d-block">
                                                                        <a href="mailTo:<?php echo e($agent->email); ?>"><i
                                                                                class="fal fa-envelope color-primary"></i>
                                                                            <?php echo e($agent->email); ?></a>
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </ul>
                                                        <a href="<?php echo e(route('frontend.agent.details', ['username' => $agent->username])); ?>"
                                                            class="btn-text"><?php echo e(__('View Profile')); ?></a>
                                                    </div>
                                                </div><!-- agent-default -->
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="swiper-pagination"></div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-lg-3">
                    <aside class="sidebar-widget-area pb-10" data-aos="fade-up">
                        <?php if($vendor->show_contact_form): ?>
                            <div class="widget widget-form radius-md mb-30">
                                <div class="user mb-20">
                                    <div class="user-img">
                                        <div class="lazy-container ratio ratio-1-1 rounded-pill">
                                            <?php if(request()->input('admin') == true): ?>
                                                <img class="lazyload"
                                                    data-src="<?php echo e($vendor->image ? asset('assets/img/admins/' . $vendor->image) : asset('assets/img/blank-user.jpg')); ?>"
                                                    alt="Vendor">
                                            <?php else: ?>
                                                <img class="lazyload"
                                                    data-src="<?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>"
                                                    alt="Vendor">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="user-info">
                                        <?php if(request('admin')): ?>
                                            <h5 class="m-0">
                                                <?php echo e($vendor->adminInfo?->first_name . ' ' . $vendor->adminInfo?->last_name); ?>

                                            </h5>
                                        <?php else: ?>
                                            <h5 class="m-0"> <?php echo e($vendor->vendor_info?->name); ?> </h5>
                                        <?php endif; ?>
                                        <?php if($vendor->show_phone_number == 1): ?>
                                            <a class="d-block" href="tel:<?php echo e($vendor->phone); ?>"> <?php echo e($vendor->phone); ?></a>
                                        <?php endif; ?>
                                        <?php if($vendor->show_email_addresss == 1): ?>
                                            <a href="mailto:<?php echo e($vendor->email); ?>"> <?php echo e($vendor->email); ?> </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <form action="<?php echo e(route('contact_user')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php if(request('admin')): ?>
                                        <input type="hidden" name="vendor_id" value="0">
                                    <?php else: ?>
                                        <input type="hidden" name="vendor_id" value="<?php echo e($vendor->id); ?>">
                                    <?php endif; ?>
                                    <div class="form-group mb-20">
                                        <input type="text" class="form-control" name="name"
                                            placeholder="<?php echo e(__('Name')); ?>*" required value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <input type="email" class="form-control" required name="email"
                                            placeholder="<?php echo e(__('Email Address')); ?>*" value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <input type="number" class="form-control" name="phone" required
                                            value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('Phone Number')); ?>*">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group mb-20">
                                        <textarea name="message" id="message" class="form-control" cols="30" rows="8" required
                                            data-error="Please enter your message" placeholder="<?php echo e(__('Write Your Message') . '*'); ?>"><?php echo e(old('message')); ?></textarea>

                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class=" text-danger"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php if($info->google_recaptcha_status == 1): ?>
                                        <div class="form-group mb-30">
                                            <?php echo NoCaptcha::renderJs(); ?>

                                            <?php echo NoCaptcha::display(); ?>


                                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="mt-1 text-danger"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>
                                    <button type="submit"
                                        class="btn btn-md btn-primary w-100"><?php echo e(__('Send message')); ?></button>
                                </form>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty(showAd(2))): ?>
                            <div class="text-center mb-30">
                                <?php echo showAd(2); ?>

                            </div>
                        <?php endif; ?>
                    </aside>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/vendor/details.blade.php ENDPATH**/ ?>