<div class="sidebar sidebar-style-2"
    data-background-color="<?php echo e($settings->admin_theme_version == 'light' ? 'white' : 'dark2'); ?>">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    <?php if(Auth::guard('admin')->user()->image != null): ?>
                        <img src="<?php echo e(asset('assets/img/admins/' . Auth::guard('admin')->user()->image)); ?>"
                            alt="Admin Image" class="avatar-img rounded-circle">
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/img/blank_user.jpg')); ?>" alt=""
                            class="avatar-img rounded-circle">
                    <?php endif; ?>
                </div>

                <div class="info">
                    <a data-toggle="collapse" href="#adminProfileMenu" aria-expanded="true">
                        <span>
                            <?php echo e(Auth::guard('admin')->user()->first_name); ?>


                            <?php if(is_null($roleInfo)): ?>
                                <span class="user-level"><?php echo e(__('Super Admin')); ?></span>
                            <?php else: ?>
                                <span class="user-level"><?php echo e($roleInfo->name); ?></span>
                            <?php endif; ?>

                            <span class="caret"></span>
                        </span>
                    </a>

                    <div class="clearfix"></div>

                    <div class="collapse in" id="adminProfileMenu">
                        <ul class="nav">
                            <li>
                                <a href="<?php echo e(route('admin.edit_profile')); ?>">
                                    <span class="link-collapse"><?php echo e('Edit Profile'); ?></span>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('admin.change_password')); ?>">
                                    <span class="link-collapse"><?php echo e('Change Password'); ?></span>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('admin.logout')); ?>">
                                    <span class="link-collapse"><?php echo e('Logout'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <?php
                if (!is_null($roleInfo)) {
                    $rolePermissions = json_decode($roleInfo->permissions);
                }
            ?>

            <ul class="nav nav-primary">
                
                <div class="row mb-3">
                    <div class="col-12">
                        <form action="">
                            <div class="form-group py-0">
                                <input name="term" type="text" class="form-control sidebar-search ltr"
                                    placeholder="Search Menu Here...">
                            </div>
                        </form>
                    </div>
                </div>

                
                <li class="nav-item <?php if(request()->routeIs('admin.dashboard')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.dashboard')); ?>">
                        <i class="la flaticon-paint-palette"></i>
                        <p><?php echo e('Dashboard'); ?></p>
                    </a>
                </li>

                

                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Property Features', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.property_specification.categories')): ?> active 
                        <?php elseif(request()->routeIs('admin.property_specification.countries')): ?> active 
              <?php elseif(request()->routeIs('admin.property_specification.settings')): ?> active 
              <?php elseif(request()->routeIs('admin.property_specification.states')): ?> active 
              <?php elseif(request()->routeIs('admin.property_specification.cities')): ?> active  <?php endif; ?>">
                        <a data-toggle="collapse" href="#propertySpecification">
                            <i class="far fa-file-alt"></i>
                            <p><?php echo e(__('Property Specifications')); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="propertySpecification"
                            class="collapse 
              <?php if(request()->routeIs('admin.property_specification.categories')): ?> show 
              <?php elseif(request()->routeIs('admin.property_specification.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.property_specification.countries')): ?> show 
              <?php elseif(request()->routeIs('admin.property_specification.states')): ?> show 
              <?php elseif(request()->routeIs('admin.property_specification.cities')): ?> show 
              <?php elseif(request()->routeIs('admin.property_specification.amenities')): ?>  show 
              <?php elseif(request()->routeIs('admin.property_specification.cities')): ?>  show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_specification.settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.property_specification.settings')); ?>">
                                        <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_specification.categories') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.property_specification.categories', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Categories')); ?></span>
                                    </a>
                                </li>


                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_specification.amenities') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.property_specification.amenities', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Amenities')); ?></span>
                                    </a>
                                </li>
                                <?php if($settings->property_country_status == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.property_specification.countries') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.property_specification.countries', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e(__('Countries')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if($settings->property_state_status == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.property_specification.states') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.property_specification.states', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e(__('States')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_specification.cities') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.property_specification.cities', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Cities')); ?></span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Property Management', $rolePermissions))): ?>
                    <li
                        class="nav-item
                     <?php if(request()->routeIs('admin.property_management.create_property')): ?> active
                     <?php elseif(request()->routeIs('admin.property_management.properties')): ?> active 
                     <?php elseif(request()->routeIs('admin.property_management.edit')): ?> active 
                     <?php elseif(request()->routeIs('admin.property_management.settings')): ?> active 
                      <?php elseif(request()->routeIs('admin.property_management.type')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#carManagement">
                            <i class="far fa-home"></i>
                            <p><?php echo e(__('Property Management')); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="carManagement"
                            class="collapse 
              <?php if(request()->routeIs('admin.property_management.create_property')): ?> show 
              <?php elseif(request()->routeIs('admin.property_management.type')): ?> show 
              <?php elseif(request()->routeIs('admin.property_management.properties')): ?> show 
              <?php elseif(request()->routeIs('admin.property_management.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.property_management.edit')): ?> show <?php endif; ?>
              ">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_management.settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.property_management.settings')); ?>">
                                        <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_management.create_property') || request()->routeIs('admin.property_management.type') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.property_management.type')); ?>">
                                        <span class="sub-item"><?php echo e(__('Add Property')); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.property_management.properties') ||
                                    request()->routeIs('admin.property_management.edit')
                                        ? 'active'
                                        : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.property_management.properties', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Manage Properties')); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Featured Properties', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.featured_pricing.index')): ?> active <?php elseif(request()->routeIs('admin.featured_pricing.edit')): ?> active <?php elseif(request()->routeIs('admin.requested_for_featured')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#featuredPricing">
                            <i class="far fa-money-bill-alt"></i>
                            <p><?php echo e('Featured Properties'); ?></p>

                            <span class="caret"></span>
                        </a>

                        <div id="featuredPricing"
                            class="collapse 
              <?php if(request()->routeIs('admin.featured_pricing.index')): ?> show <?php elseif(request()->routeIs('admin.featured_pricing.edit')): ?> show <?php elseif(request()->routeIs('admin.requested_for_featured')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">

                                <li
                                    class="<?php echo e(request()->routeIs('admin.featured_pricing.index') || request()->routeIs('admin.featured_pricing.edit') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.featured_pricing.index')); ?>">
                                        <span class="sub-item"><?php echo e('Pricing'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.requested_for_featured') && request()->input('status') == 'all' ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.requested_for_featured', ['status' => 'all'])); ?>">
                                        <span class="sub-item"><?php echo e('All Request'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.requested_for_featured') && request()->input('status') == 'pending' ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.requested_for_featured', ['status' => 'pending'])); ?>">
                                        <span class="sub-item"><?php echo e('Pending Request'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.requested_for_featured') && request()->input('status') == 'accepted' ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.requested_for_featured', ['status' => 'accepted'])); ?>">
                                        <span class="sub-item"><?php echo e('Accepted Request'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.requested_for_featured') && request()->input('status') == 'rejected' ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.requested_for_featured', ['status' => 'rejected'])); ?>">
                                        <span class="sub-item"><?php echo e('Rejected Request'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Property Messages', $rolePermissions))): ?>
                    <li class="nav-item  <?php if(request()->routeIs('admin.property_message.index')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.property_message.index')); ?>">
                            <i class="fas fa-comment"></i>
                            <p><?php echo e(__('Property Messages')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Project Management', $rolePermissions))): ?>
                    <li
                        class="nav-item
                     <?php if(request()->routeIs('admin.project_management.projects')): ?> active
                     <?php elseif(request()->routeIs('admin.project_management.create_project')): ?> active 
                     <?php elseif(request()->routeIs('admin.project_management.project_types')): ?> active 
                     <?php elseif(request()->routeIs('admin.project_management.settings')): ?> active 
                     <?php elseif(request()->routeIs('admin.project_management.edit')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#projectManagement">
                            <i class="fal fa-building"></i>
                            <p><?php echo e(__('Project Management')); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="projectManagement"
                            class="collapse 
              <?php if(request()->routeIs('admin.project_management.create_project')): ?> show 
              <?php elseif(request()->routeIs('admin.project_management.projects')): ?> show  
              <?php elseif(request()->routeIs('admin.project_management.settings')): ?> show  
               <?php elseif(request()->routeIs('admin.project_management.edit')): ?> show
              <?php elseif(request()->routeIs('admin.project_management.project_types')): ?> show <?php endif; ?>
              ">
                            <ul class="nav nav-collapse">

                                <li
                                    class="<?php echo e(request()->routeIs('admin.project_management.settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.project_management.settings')); ?>">
                                        <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.project_management.create_project') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.project_management.create_project')); ?>">
                                        <span class="sub-item"><?php echo e(__('Add Project')); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.project_management.projects') ||
                                    request()->routeIs('admin.property_management.edit') ||
                                    request()->routeIs('admin.project_management.project_types')
                                        ? 'active'
                                        : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.project_management.projects', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e(__('Manage Projects')); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                


                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Agent', $rolePermissions))): ?>
                    <li class="nav-item  <?php if(request()->routeIs('admin.agent_management.index')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.agent_management.index')); ?>">
                            <i class="fal fa-users-cog"></i>
                            <p> <?php echo e('Agents'); ?> </p>
                        </a>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Package Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.package.settings')): ?> active 
            <?php elseif(request()->routeIs('admin.package.index')): ?> active 
            <?php elseif(request()->routeIs('admin.package.edit')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#packageManagement">
                            <i class="fal fa-receipt"></i>
                            <p><?php echo e('Package Management'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="packageManagement"
                            class="collapse 
              <?php if(request()->routeIs('admin.package.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.package.index')): ?> show 
              <?php elseif(request()->routeIs('admin.package.edit')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">

                                <li class="<?php echo e(request()->routeIs('admin.package.settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.package.settings')); ?>">
                                        <span class="sub-item"><?php echo e('Settings'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php echo e(request()->routeIs('admin.package.index') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.package.index')); ?>">
                                        <span class="sub-item"><?php echo e('Packages'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Menu Builder', $rolePermissions))): ?>
                    <li class="nav-item <?php if(request()->routeIs('admin.menu_builder')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.menu_builder', ['language' => $defaultLang->code])); ?>">
                            <i class="fal fa-bars"></i>
                            <p><?php echo e('Menu Builder'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>



                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Payment Log', $rolePermissions))): ?>
                    <li class="nav-item <?php if(request()->routeIs('admin.payment-log.index')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.payment-log.index')); ?>">
                            <i class="fas fa-list-ol"></i>
                            <p><?php echo e('Payment Log'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('User Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.user_management.registered_users')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.registered_user.create')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.subscribers')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#user">
                            <i class="la flaticon-users"></i>
                            <p><?php echo e('Users Management'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="user"
                            class="collapse 
              <?php if(request()->routeIs('admin.user_management.registered_users')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.registered_user.create')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.subscribers')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php if(request()->routeIs('admin.user_management.registered_users')): ?> active 
                  <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> active
<?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?>
active <?php endif; ?>
                  ">
                                    <a href="<?php echo e(route('admin.user_management.registered_users')); ?>">
                                        <span class="sub-item"><?php echo e('Registered Users'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php if(request()->routeIs('admin.user_management.registered_user.create')): ?> active <?php endif; ?>
                  ">
                                    <a href="<?php echo e(route('admin.user_management.registered_user.create')); ?>">
                                        <span class="sub-item"><?php echo e('Add User'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php if(request()->routeIs('admin.user_management.subscribers')): ?> active 
                  <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.user_management.subscribers')); ?>">
                                        <span class="sub-item"><?php echo e('Subscribers'); ?></span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Vendors Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.add_vendor')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> active
            <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.settings')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#vendor">
                            <i class="la flaticon-users"></i>
                            <p><?php echo e('Vendors Management'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="vendor"
                            class="collapse
              <?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> show
              <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.add_vendor')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.settings')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li class="<?php if(request()->routeIs('admin.vendor_management.settings')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.vendor_management.settings')); ?>">
                                        <span class="sub-item"><?php echo e('Settings'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> active
                  <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> active
                  <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> active
                  <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.vendor_management.registered_vendor')); ?>">
                                        <span class="sub-item"><?php echo e('Registered vendors'); ?></span>
                                    </a>
                                </li>
                                <li class="<?php if(request()->routeIs('admin.vendor_management.add_vendor')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.vendor_management.add_vendor')); ?>">
                                        <span class="sub-item"><?php echo e('Add vendor'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Support Tickets', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.support_ticket.setting')): ?> active
            <?php elseif(request()->routeIs('admin.support_tickets')): ?> active
            <?php elseif(request()->routeIs('admin.support_tickets.message')): ?> active active <?php endif; ?>">
                        <a data-toggle="collapse" href="#support_ticket">
                            <i class="la flaticon-web-1"></i>
                            <p><?php echo e('Support Tickets'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="support_ticket"
                            class="collapse
              <?php if(request()->routeIs('admin.support_ticket.setting')): ?> show
              <?php elseif(request()->routeIs('admin.support_tickets')): ?> show
              <?php elseif(request()->routeIs('admin.support_tickets.message')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li class="<?php if(request()->routeIs('admin.support_ticket.setting')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.support_ticket.setting')); ?>">
                                        <span class="sub-item"><?php echo e('Setting'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.support_tickets') && empty(request()->input('status')) ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.support_tickets')); ?>">
                                        <span class="sub-item"><?php echo e('All Tickets'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 1 ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.support_tickets', ['status' => 1])); ?>">
                                        <span class="sub-item"><?php echo e('Pending Tickets'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 2 ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.support_tickets', ['status' => 2])); ?>">
                                        <span class="sub-item"><?php echo e('Open Tickets'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 3 ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.support_tickets', ['status' => 3])); ?>">
                                        <span class="sub-item"><?php echo e('Closed Tickets'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                



                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Home Page', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.home_page.hero_section.slider_version')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.about_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.category_section')): ?> active  
            <?php elseif(request()->routeIs('admin.home_page.work_process_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.feature_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.counter_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.testimonial_section')): ?> active  
            <?php elseif(request()->routeIs('admin.home_page.call_to_action_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.hero_section.static_version')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.about_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.brand_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.why_choose_us')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.city_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.subscribe_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.vendor_section')): ?> active  
            <?php elseif(request()->routeIs('admin.home_page.project_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.property_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.section_customization')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.pricing_section')): ?> active 
            <?php elseif(request()->routeIs('admin.home_page.partners')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#home_page">
                            <i class="fal fa-layer-group"></i>
                            <p><?php echo e('Home Page'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="home_page"
                            class="collapse 
              <?php if(request()->routeIs('admin.home_page.hero_section.slider_version')): ?> show 
               
              <?php elseif(request()->routeIs('admin.home_page.about_section')): ?> show  
              <?php elseif(request()->routeIs('admin.home_page.category_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.work_process_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.feature_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.counter_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.testimonial_section')): ?> show  
              <?php elseif(request()->routeIs('admin.home_page.call_to_action_section')): ?> show  
              <?php elseif(request()->routeIs('admin.home_page.hero_section.static_version')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.about_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.brand_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.why_choose_us_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.city_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.subscribe_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.vendor_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.project_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.property_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.section_customization')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.pricing_section')): ?> show 
              <?php elseif(request()->routeIs('admin.home_page.partners')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li class="submenu">
                                    <a data-toggle="collapse" href="#hero_section">
                                        <span class="sub-item"><?php echo e('Hero Section'); ?></span>
                                        <span class="caret"></span>
                                    </a>

                                    <div id="hero_section"
                                        class="collapse 
                    <?php if(request()->routeIs('admin.home_page.hero_section.slider_version')): ?> show             <?php elseif(request()->routeIs('admin.home_page.hero_section.static_version')): ?> show <?php endif; ?>">
                                        <ul class="nav nav-collapse subnav">
                                            <?php if($settings->theme_version == 2): ?>
                                                <li
                                                    class="<?php echo e(request()->routeIs('admin.home_page.hero_section.slider_version') ? 'active' : ''); ?>">
                                                    <a
                                                        href="<?php echo e(route('admin.home_page.hero_section.slider_version', ['language' => $defaultLang->code])); ?>">
                                                        <span class="sub-item"><?php echo e('Slider Version'); ?></span>
                                                    </a>
                                                </li>
                                            <?php else: ?>
                                                <li
                                                    class="<?php echo e(request()->routeIs('admin.home_page.hero_section.static_version') ? 'active' : ''); ?>">
                                                    <a
                                                        href="<?php echo e(route('admin.home_page.hero_section.static_version', ['language' => $defaultLang->code])); ?>">
                                                        <span class="sub-item"><?php echo e('Static Version'); ?></span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </li>

                                <?php if($settings->theme_version == 2 || $settings->theme_version == 3): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.category_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.category_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Category Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if($settings->theme_version == 1 || $settings->theme_version == 3): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.about_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.about_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('About Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.why_choose_us_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.why_choose_us_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Why Choose Us Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 1 || $settings->theme_version == 2): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.brand_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.brand_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Brand Section'); ?></span>
                                        </a>
                                        </>
                                <?php endif; ?>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.home_page.property_section') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.home_page.property_section', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Property Section'); ?></span>
                                    </a>
                                </li>


                                <?php if($settings->theme_version == 1 || $settings->theme_version == 2): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.feature_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.feature_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Featured Property Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if($settings->theme_version == 3): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.project_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.project_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Project Section'); ?></span>
                                        </a>
                                        </>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 2): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.pricing_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.pricing_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Pricing Section'); ?></span>
                                        </a>
                                        </>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 2 || $settings->theme_version == 3): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.work_process_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.work_process_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Work Process Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if($settings->theme_version != 2): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.counter_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.counter_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Counter Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.city_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.city_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('City Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.home_page.testimonial_section') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.home_page.testimonial_section', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Testimonial Section'); ?></span>
                                    </a>
                                </li>



                                <?php if($settings->theme_version == 2): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.call_to_action_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.call_to_action_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Call To Action Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.vendor_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.vendor_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Vendor Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if($settings->theme_version == 1): ?>
                                    <li
                                        class="<?php echo e(request()->routeIs('admin.home_page.subscribe_section') ? 'active' : ''); ?>">
                                        <a
                                            href="<?php echo e(route('admin.home_page.subscribe_section', ['language' => $defaultLang->code])); ?>">
                                            <span class="sub-item"><?php echo e('Subscribe Section'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.home_page.section_customization') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.home_page.section_customization')); ?>">
                                        <span class="sub-item"><?php echo e('Section Show/Hide'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>



                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Footer', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.footer.logo_and_image')): ?> active 
            <?php elseif(request()->routeIs('admin.footer.content')): ?> active 
            <?php elseif(request()->routeIs('admin.footer.quick_links')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#footer">
                            <i class="fal fa-shoe-prints"></i>
                            <p><?php echo e('Footer'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="footer"
                            class="collapse <?php if(request()->routeIs('admin.footer.logo_and_image')): ?> show 
              <?php elseif(request()->routeIs('admin.footer.content')): ?> show 
              <?php elseif(request()->routeIs('admin.footer.quick_links')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li class="<?php echo e(request()->routeIs('admin.footer.logo_and_image') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.footer.logo_and_image')); ?>">
                                        <span class="sub-item"><?php echo e('Logo & Image'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php echo e(request()->routeIs('admin.footer.content') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.footer.content', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Content'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php echo e(request()->routeIs('admin.footer.quick_links') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.footer.quick_links', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Quick Links'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Custom Pages', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.custom_pages')): ?> active 
            <?php elseif(request()->routeIs('admin.custom_pages.create_page')): ?> active 
            <?php elseif(request()->routeIs('admin.custom_pages.edit_page')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.custom_pages', ['language' => $defaultLang->code])); ?>">
                            <i class="la flaticon-file"></i>
                            <p><?php echo e('Custom Pages'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Blog Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.blog_management.categories')): ?> active 
            <?php elseif(request()->routeIs('admin.blog_management.blogs')): ?> active 
            <?php elseif(request()->routeIs('admin.blog_management.create_blog')): ?> active 
            <?php elseif(request()->routeIs('admin.blog_management.edit_blog')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#blog">
                            <i class="fal fa-blog"></i>
                            <p><?php echo e('Blog Management'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="blog"
                            class="collapse 
              <?php if(request()->routeIs('admin.blog_management.categories')): ?> show 
              <?php elseif(request()->routeIs('admin.blog_management.blogs')): ?> show 
              <?php elseif(request()->routeIs('admin.blog_management.create_blog')): ?> show 
              <?php elseif(request()->routeIs('admin.blog_management.edit_blog')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php echo e(request()->routeIs('admin.blog_management.categories') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.blog_management.categories', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Categories'); ?></span>
                                    </a>
                                </li>



                                <li
                                    class="<?php if(request()->routeIs('admin.blog_management.blogs')): ?> active 
                  <?php elseif(request()->routeIs('admin.blog_management.create_blog')): ?> active 
                  <?php elseif(request()->routeIs('admin.blog_management.edit_blog')): ?> active <?php endif; ?>">
                                    <a
                                        href="<?php echo e(route('admin.blog_management.blogs', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Posts'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('FAQ Management', $rolePermissions))): ?>
                    <li class="nav-item <?php echo e(request()->routeIs('admin.faq_management') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.faq_management', ['language' => $defaultLang->code])); ?>">
                            <i class="la flaticon-round"></i>
                            <p><?php echo e('FAQ Management'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Advertise', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.advertise.settings')): ?> active 
            <?php elseif(request()->routeIs('admin.advertise.all_advertisement')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#customid">
                            <i class="fab fa-buysellads"></i>
                            <p><?php echo e('Advertisements'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="customid"
                            class="collapse <?php if(request()->routeIs('admin.advertise.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.advertise.all_advertisement')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li class="<?php echo e(request()->routeIs('admin.advertise.settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.advertise.settings')); ?>">
                                        <span class="sub-item"><?php echo e('Settings'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.advertise.all_advertisement') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.advertise.all_advertisement')); ?>">
                                        <span class="sub-item"><?php echo e('All Advertisements'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Announcement Popups', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.announcement_popups')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.select_popup_type')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.create_popup')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.edit_popup')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.announcement_popups', ['language' => $defaultLang->code])); ?>">
                            <i class="fal fa-bullhorn"></i>
                            <p><?php echo e('Announcement Popups'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>




                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Basic Settings', $rolePermissions))): ?>
                    <li
                        class="nav-item 
            <?php if(request()->routeIs('admin.basic_settings.contact_page')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.mail_from_admin')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.mail_to_admin')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.mail_templates')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.edit_mail_template')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.breadcrumb')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.page_headings')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.plugins')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.seo')): ?> active 
            <?php elseif(request()->routeIs('admin.basic_settings.maintenance_mode')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.general_settings')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.cookie_alert')): ?> active
            <?php elseif(request()->routeIs('admin.basic_settings.social_medias')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#basic_settings">
                            <i class="la flaticon-settings"></i>
                            <p><?php echo e('Basic Settings'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="basic_settings"
                            class="collapse 
              <?php if(request()->routeIs('admin.basic_settings.contact_page')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.mail_from_admin')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.mail_to_admin')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.mail_templates')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.edit_mail_template')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.breadcrumb')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.page_headings')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.plugins')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.seo')): ?> show 
              <?php elseif(request()->routeIs('admin.basic_settings.maintenance_mode')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.cookie_alert')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.general_settings')): ?> show
              <?php elseif(request()->routeIs('admin.basic_settings.social_medias')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.general_settings') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.general_settings')); ?>">
                                        <span class="sub-item"><?php echo e('General Settings'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.contact_page') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.contact_page')); ?>">
                                        <span class="sub-item"><?php echo e('Contact Page'); ?></span>
                                    </a>
                                </li>

                                <li class="submenu">
                                    <a data-toggle="collapse" href="#mail-settings">
                                        <span class="sub-item"><?php echo e('Email Settings'); ?></span>
                                        <span class="caret"></span>
                                    </a>

                                    <div id="mail-settings"
                                        class="collapse 
                    <?php if(request()->routeIs('admin.basic_settings.mail_from_admin')): ?> show 
                    <?php elseif(request()->routeIs('admin.basic_settings.mail_to_admin')): ?> show
                    <?php elseif(request()->routeIs('admin.basic_settings.mail_templates')): ?> show
                    <?php elseif(request()->routeIs('admin.basic_settings.edit_mail_template')): ?> show <?php endif; ?>">
                                        <ul class="nav nav-collapse subnav">
                                            <li
                                                class="<?php echo e(request()->routeIs('admin.basic_settings.mail_from_admin') ? 'active' : ''); ?>">
                                                <a href="<?php echo e(route('admin.basic_settings.mail_from_admin')); ?>">
                                                    <span class="sub-item"><?php echo e('Mail From Admin'); ?></span>
                                                </a>
                                            </li>

                                            <li
                                                class="<?php echo e(request()->routeIs('admin.basic_settings.mail_to_admin') ? 'active' : ''); ?>">
                                                <a href="<?php echo e(route('admin.basic_settings.mail_to_admin')); ?>">
                                                    <span class="sub-item"><?php echo e('Mail To Admin'); ?></span>
                                                </a>
                                            </li>

                                            <li
                                                class="<?php if(request()->routeIs('admin.basic_settings.mail_templates')): ?> active 
                        <?php elseif(request()->routeIs('admin.basic_settings.edit_mail_template')): ?> active <?php endif; ?>">
                                                <a href="<?php echo e(route('admin.basic_settings.mail_templates')); ?>">
                                                    <span class="sub-item"><?php echo e('Mail Templates'); ?></span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.breadcrumb') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.breadcrumb')); ?>">
                                        <span class="sub-item"><?php echo e('Breadcrumb'); ?></span>
                                    </a>
                                </li>


                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.page_headings') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.basic_settings.page_headings', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Page Headings'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php echo e(request()->routeIs('admin.basic_settings.plugins') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.plugins')); ?>">
                                        <span class="sub-item"><?php echo e('Plugins'); ?></span>
                                    </a>
                                </li>

                                <li class="<?php echo e(request()->routeIs('admin.basic_settings.seo') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.basic_settings.seo', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('SEO Informations'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.maintenance_mode') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.maintenance_mode')); ?>">
                                        <span class="sub-item"><?php echo e('Maintenance Mode'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.cookie_alert') ? 'active' : ''); ?>">
                                    <a
                                        href="<?php echo e(route('admin.basic_settings.cookie_alert', ['language' => $defaultLang->code])); ?>">
                                        <span class="sub-item"><?php echo e('Cookie Alert'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.basic_settings.social_medias') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.basic_settings.social_medias')); ?>">
                                        <span class="sub-item"><?php echo e('Social Medias'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>
                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Payment Gateways', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.payment_gateways.online_gateways')): ?> active 
            <?php elseif(request()->routeIs('admin.payment_gateways.offline_gateways')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#payment_gateways">
                            <i class="la flaticon-paypal"></i>
                            <p><?php echo e('Payment Gateways'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="payment_gateways"
                            class="collapse 
              <?php if(request()->routeIs('admin.payment_gateways.online_gateways')): ?> show 
              <?php elseif(request()->routeIs('admin.payment_gateways.offline_gateways')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php echo e(request()->routeIs('admin.payment_gateways.online_gateways') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.payment_gateways.online_gateways')); ?>">
                                        <span class="sub-item"><?php echo e('Online Gateways'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.payment_gateways.offline_gateways') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.payment_gateways.offline_gateways')); ?>">
                                        <span class="sub-item"><?php echo e('Offline Gateways'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>


                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Admin Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> active 
            <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> active 
            <?php elseif(request()->routeIs('admin.admin_management.registered_admins')): ?> active <?php endif; ?>">
                        <a data-toggle="collapse" href="#admin">
                            <i class="fal fa-users-cog"></i>
                            <p><?php echo e('Admin Management'); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div id="admin"
                            class="collapse 
              <?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> show 
              <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> show 
              <?php elseif(request()->routeIs('admin.admin_management.registered_admins')): ?> show <?php endif; ?>">
                            <ul class="nav nav-collapse">
                                <li
                                    class="<?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> active 
                  <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('admin.admin_management.role_permissions')); ?>">
                                        <span class="sub-item"><?php echo e('Role & Permissions'); ?></span>
                                    </a>
                                </li>

                                <li
                                    class="<?php echo e(request()->routeIs('admin.admin_management.registered_admins') ? 'active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.admin_management.registered_admins')); ?>">
                                        <span class="sub-item"><?php echo e('Registered Admins'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Language Management', $rolePermissions))): ?>
                    <li
                        class="nav-item <?php if(request()->routeIs('admin.language_management')): ?> active 
            <?php elseif(request()->routeIs('admin.language_management.edit_keyword')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.language_management')); ?>">
                            <i class="fal fa-language"></i>
                            <p><?php echo e('Language Management'); ?></p>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/partials/side-navbar.blade.php ENDPATH**/ ?>