<div class="main-header">
    <!-- Logo Header Start -->
    <div class="logo-header"
        data-background-color="<?php echo e(Session::get('vendor_theme_version') == 'light' ? 'white' : 'dark2'); ?>">
        <?php if(!empty($websiteInfo->logo)): ?>
            <a href="<?php echo e(route('index')); ?>" class="logo" target="_blank">
                <img src="<?php echo e(asset('assets/img/' . $websiteInfo->logo)); ?>" alt="logo" class="navbar-brand"
                    width="120">
            </a>
        <?php endif; ?>

        <button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse"
            data-target="collapse" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon">
                <i class="icon-menu"></i>
            </span>
        </button>
        <button class="topbar-toggler more"><i class="icon-options-vertical"></i></button>

        <div class="nav-toggle">
            <button class="btn btn-toggle toggle-sidebar">
                <i class="icon-menu"></i>
            </button>
        </div>
    </div>
    <!-- Logo Header End -->

    <!-- Navbar Header Start -->
    <nav class="navbar navbar-header navbar-expand-lg"
        data-background-color="<?php echo e(Session::get('vendor_theme_version') == 'light' ? 'white2' : 'dark'); ?>">
        <div class="container-fluid">
            <ul class="navbar-nav topbar-nav ml-md-auto align-items-center ">
                <li>
                    <button type="button" class="btn  btn-secondary mr-2  btn-sm btn-round" data-toggle="modal"
                        data-target="#allLimits">
                        <?php if(!is_null($currentPackage)): ?>
                            <?php
                                $agentsD = $currentPackage->number_of_agent - $featuresCount['agents'];
                                $propertiesD = $currentPackage->number_of_property - $featuresCount['properties'];
                                $projectsD = $currentPackage->number_of_projects - $featuresCount['projects'];
                            ?>
                            <?php if(
                                $proGalImgDown ||
                                    $projectTypeDown ||
                                    $proSpeciDown ||
                                    $projectGalImgDown ||
                                    $projectSpeciDown ||
                                    $agentsD < 0 ||
                                    $propertiesD < 0 ||
                                    $projectsD < 0): ?>
                                <i class="fas fa-exclamation-triangle text-danger"></i>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php echo e(__('Check Limit')); ?>


                    </button>
                </li>
                <li>
                    <a class="btn btn-primary btn-sm btn-round" target="_blank"
                        href="<?php echo e(route('frontend.vendor.details', ['username' => Auth::guard('vendor')->user()->username])); ?>"
                        title="View Profile">
                        <i class="fas fa-eye"></i>
                    </a>
                </li>
                <form action="<?php echo e(route('vendor.change_theme')); ?>" class="form-inline mr-3" method="POST">

                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="selectgroup selectgroup-secondary selectgroup-pills">
                            <label class="selectgroup-item">
                                <input type="radio" name="vendor_theme_version" value="light"
                                    class="selectgroup-input"
                                    <?php echo e(Session::get('vendor_theme_version') == 'light' ? 'checked' : ''); ?>

                                    onchange="this.form.submit()">
                                <span class="selectgroup-button selectgroup-button-icon"><i
                                        class="fa fa-sun"></i></span>
                            </label>

                            <label class="selectgroup-item">
                                <input type="radio" name="vendor_theme_version" value="dark"
                                    class="selectgroup-input"
                                    <?php echo e(Session::get('vendor_theme_version') == 'dark' ? 'checked' : ''); ?>

                                    onchange="this.form.submit()">
                                <span class="selectgroup-button selectgroup-button-icon"><i
                                        class="fa fa-moon"></i></span>
                            </label>
                        </div>
                    </div>
                </form>


                <li class="nav-item dropdown hidden-caret">
                    <a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#" aria-expanded="false">
                        <div class="avatar-sm">
                            <?php if(Auth::guard('vendor')->user()->photo != null): ?>
                                <img src="<?php echo e(asset('assets/admin/img/vendor-photo/' . Auth::guard('vendor')->user()->photo)); ?>"
                                    alt="Vendor Image" class="avatar-img rounded-circle">
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>" alt=""
                                    class="avatar-img rounded-circle">
                            <?php endif; ?>
                        </div>
                    </a>

                    <ul class="dropdown-menu dropdown-user animated fadeIn">
                        <div class="dropdown-user-scroll scrollbar-outer">
                            <li>
                                <div class="user-box">
                                    <div class="avatar-lg">
                                        <?php if(Auth::guard('vendor')->user()->photo != null): ?>
                                            <img src="<?php echo e(asset('assets/admin/img/vendor-photo/' . Auth::guard('vendor')->user()->photo)); ?>"
                                                alt="Vendor Image" class="avatar-img rounded-circle">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('assets/img/blank-user.jpg')); ?>" alt=""
                                                class="avatar-img rounded-circle">
                                        <?php endif; ?>
                                    </div>

                                    <div class="u-text">
                                        <h4>
                                            <?php echo e(Auth::guard('vendor')->user()->username); ?>

                                        </h4>
                                        <p class="text-muted"><?php echo e(Auth::guard('vendor')->user()->email); ?></p>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?php echo e(route('vendor.edit.profile')); ?>">
                                    <?php echo e(__('Edit Profile')); ?>

                                </a>

                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?php echo e(route('vendor.change_password')); ?>">
                                    <?php echo e(__('Change Password')); ?>

                                </a>

                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?php echo e(route('vendor.logout')); ?>">
                                    <?php echo e(__('Logout')); ?>

                                </a>
                            </li>
                        </div>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
    <!-- Navbar Header End -->
</div>
<!-- Modal -->
<?php if(!is_null($currentPackage)): ?>
    <div class="modal fade" id="allLimits" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title card-title" id="exampleModalLabel">
                        <?php echo e($keywords['All_Features_Left'] ?? __('All Limit')); ?></h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php

                        $agentLeft = $currentPackage->number_of_agent - $featuresCount['agents'];
                        $propertiesLeft = $currentPackage->number_of_property - $featuresCount['properties'];
                        $projectLeft = $currentPackage->number_of_projects - $featuresCount['projects'];

                    ?>
                    <?php if(
                        $agentLeft < 0 ||
                            $propertiesLeft < 0 ||
                            $proGalImgDown ||
                            $proSpeciDown ||
                            $projectLeft < 0 ||
                            $projectGalImgDown ||
                            $projectTypeDown ||
                            $projectSpeciDown): ?>
                        <div class="alert alert-warning">
                            <span
                                class="text-warning"><?php echo e(__("If any of your package feature's limit exceeds, you can not add or edit any other feature.")); ?></span>
                        </div>
                    <?php endif; ?>
                    <ul class="list-group border ">

                        <li class="list-group-item">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($agentLeft < 0): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Agents Left')); ?> :
                                </span>

                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_agent == 999999 ? 'Unlimited' : ($currentPackage->number_of_agent - $featuresCount['agents'] < 0 ? 0 : $currentPackage->number_of_agent - $featuresCount['agents'])); ?>

                                </span>
                            </div>

                            <?php if($agentLeft == 0): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__('Your agent features limit has been reached. You can\'t add more agent.')); ?>

                                </p>
                            <?php endif; ?>
                            <?php if($featuresCount['agents'] > $currentPackage->number_of_agent): ?>
                                <p class="text-warning m-0"><?php echo e(__('Limit has been crossed, you have to delete')); ?>



                                    <?php echo e(abs($currentPackage->number_of_agent - $featuresCount['agents'])); ?>

                                    <?php echo e(abs($currentPackage->number_of_agent - $featuresCount['agents']) == 1 ? 'agent' : 'agents'); ?>


                                </p>
                            <?php endif; ?>
                        </li>

                        <li class="list-group-item">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($propertiesLeft < 0): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Properties Left')); ?> :
                                </span>

                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_property == 999999 ? 'Unlimited' : ($currentPackage->number_of_property - $featuresCount['properties'] < 0 ? 0 : $currentPackage->number_of_property - $featuresCount['properties'])); ?>

                                </span>
                            </div>
                            <?php if($propertiesLeft == 0): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__('Your property features limit has been reached. You can\'t add more property.')); ?>

                                </p>
                            <?php endif; ?>
                            <?php if($featuresCount['properties'] > $currentPackage->number_of_property): ?>
                                <p class="text-warning m-0"><?php echo e(__('Limit has been crossed, you have to delete')); ?>



                                    <?php echo e(abs($currentPackage->number_of_property - $featuresCount['properties'])); ?>

                                    <?php echo e(abs($currentPackage->number_of_property - $featuresCount['properties']) == 1 ? 'property' : 'properties'); ?>


                                </p>
                            <?php endif; ?>


                        <li class="list-group-item ">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($proGalImgDown): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Gallery Images Limit (Per Property)')); ?> :
                                </span>

                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_property_gallery_images == 999999 ? 'Unlimited' : $currentPackage->number_of_property_gallery_images); ?>

                                </span>
                            </div>


                            <?php if($proImgCount > $currentPackage->number_of_property_gallery_images): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__("Please remove some 'gallery images' from properties & make sure each property has maximum ")); ?>

                                    <?php echo e(abs($currentPackage->number_of_property_gallery_images)); ?>

                                    <?php echo e(__('gallery images')); ?>

                                </p>
                            <?php endif; ?>
                        </li>


                        <li class="list-group-item ">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($proSpeciDown): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Additional Features Limit (Per Property)')); ?> :
                                </span>
                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_property_adittionl_specifications == 999999 ? 'Unlimited' : $currentPackage->number_of_property_adittionl_specifications); ?>

                                </span>
                            </div>


                            <?php if($proSpeciCount > $currentPackage->number_of_property_adittionl_specifications): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__("Please remove some 'additional features' from properties & make sure each property has maximum ")); ?>

                                    <?php echo e(abs($currentPackage->number_of_property_adittionl_specifications)); ?>

                                    <?php echo e(__('additional features')); ?>

                                </p>
                            <?php endif; ?>
                        </li>


                        <li class="list-group-item">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($projectLeft < 0): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Projects Left')); ?> :
                                </span>

                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_projects == 999999 ? 'Unlimited' : ($currentPackage->number_of_projects - $featuresCount['projects'] < 0 ? 0 : $currentPackage->number_of_projects - $featuresCount['projects'])); ?>

                                </span>
                            </div>
                            <?php if($projectLeft == 0): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__('Your project features limit has been reached. You can\'t add more project.')); ?>

                                </p>
                            <?php endif; ?>

                            <?php if($featuresCount['projects'] > $currentPackage->number_of_projects): ?>
                                <p class="text-warning m-0"><?php echo e(__('Limit has been crossed, you have to delete')); ?>



                                    <?php echo e(abs($currentPackage->number_of_projects - $featuresCount['projects'])); ?>

                                    <?php echo e(abs($currentPackage->number_of_projects - $featuresCount['projects']) == 1 ? 'project' : 'projects'); ?>


                                </p>
                            <?php endif; ?>
                        </li>

                        
                        <li class="list-group-item ">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($projectGalImgDown): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Gallery Images Limit (Per Project)')); ?> :
                                </span>
                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_project_gallery_images == 999999 ? 'Unlimited' : $currentPackage->number_of_project_gallery_images); ?>

                                </span>
                            </div>


                            <?php if($projectImgCount > $currentPackage->number_of_project_gallery_images): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__("Please remove some 'gallery images' from projects & make sure each project has maximum ")); ?>

                                    <?php echo e(abs($currentPackage->number_of_project_gallery_images)); ?>

                                    <?php echo e(__('gallery images')); ?>

                                </p>
                            <?php endif; ?>
                        </li>
                        <li class="list-group-item ">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($projectTypeDown): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Project Types Limit (Per Project)')); ?> :
                                </span>
                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_project_types == 999999 ? 'Unlimited' : $currentPackage->number_of_project_types); ?>

                                </span>

                            </div>


                            <?php if($projectTypeCount > $currentPackage->number_of_project_types): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__("Please remove some 'project type' from projects & make sure each project has maximum ")); ?>

                                    <?php echo e(abs($currentPackage->number_of_project_types)); ?>

                                    <?php echo e(__('project types')); ?>

                                </p>
                            <?php endif; ?>
                        </li>

                        <li class="list-group-item ">
                            <div class="d-flex  justify-content-between">
                                <span class="text-focus">
                                    <?php if($projectSpeciDown): ?>
                                        <i class="fas fa-exclamation-circle text-danger"></i>
                                    <?php endif; ?>
                                    <?php echo e(__('Additional Features Limit (Per Project)')); ?> :
                                </span>
                                <span class="badge badge-primary badge-sm">
                                    <?php echo e($currentPackage->number_of_project_additionl_specifications == 999999 ? 'Unlimited' : $currentPackage->number_of_project_additionl_specifications); ?>

                                </span>
                            </div>

                            <?php if($projectSpeciCount > $currentPackage->number_of_project_additionl_specifications): ?>
                                <p class="text-warning m-0">
                                    <?php echo e(__("Please remove some 'additional features' from projects & make sure each project has maximum ")); ?>

                                    <?php echo e(abs($currentPackage->number_of_project_additionl_specifications)); ?>

                                    <?php echo e(__('additional features')); ?>

                                </p>
                            <?php endif; ?>
                        </li>



                    </ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal"><?php echo e($keywords['Close'] ?? __('Close')); ?></button>

                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/vendors/partials/top-navbar.blade.php ENDPATH**/ ?>