<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(!empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keywords_vendor_page); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_vendor_page); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
        'subtitle' => __('Vendors'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->vendor_page_title : __('Vendors'),
        'subtitle' => __('Vendors'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="agent-grid pt-100 pb-70">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                            <div class="agent-box radius-md mb-30">
                                <div class="agent-img">
                                    <figure>
                                        <a href="#" class="lazy-container ratio ratio-1-2">
                                            <img class="lazyload"
                                                src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>"
                                                data-src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>">
                                        </a>
                                    </figure>
                                    <div class="agent-ratings d-flex align-items-center justify-content-between">
                                        <div class="ratings">

                                        </div>
                                        <span class="label"><?php echo e(__('Real Estate')); ?></span>
                                    </div>

                                </div>
                                <div class="agent-details text-center">
                                    <?php
                                        $admin_info = App\Models\AdminInfo::where([
                                            ['admin_id', $admin->id],
                                            ['language_id', $language->id],
                                        ])
                                            ->select('first_name', 'last_name')
                                            ->first();
                                        $adminProperties = App\Models\Property\Property::where([
                                            ['vendor_id', 0],
                                            ['approve_status', 1],
                                        ])->count();
                                        $adminAgents = App\Models\Agent::where('vendor_id', 0)->count();
                                        $adminProjects = App\Models\Project\Project::where([
                                            ['vendor_id', 0],
                                            ['approve_status', 1],
                                        ])->count();

                                    ?>
                                    <span class="color-primary font-sm"><?php echo e($adminProperties); ?>

                                        <?php echo e(__('Properties')); ?></span> |
                                    <span class="color-primary font-sm"><?php echo e($adminAgents); ?>

                                        <?php echo e(__('Agents')); ?></span> |
                                    <span class="color-primary font-sm"><?php echo e($adminProjects); ?>

                                        <?php echo e(__('Projects')); ?></span>


                                    <h4 class="agent-title"><a
                                            href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>"><?php echo e(@$admin_info->first_name . ' ' . @$admin_info->last_name); ?></a>
                                    </h4>
                                    <ul class="agent-info list-unstyled p-0">

                                        <?php if($admin->show_phone_number == 1): ?>
                                            <?php if(!is_null($admin->phone)): ?>
                                                <li class="icon-start ">
                                                    <a href="tel:<?php echo e($admin->phone); ?>"> <i class="fal fa-phone-plus"></i>
                                                        <?php echo e($admin->phone); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if($admin->show_email_addresss == 1): ?>
                                            <li class="icon-start font-sm">
                                                <a href="mailto:<?php echo e($admin->email); ?>"> <i class="fal fa-envelope"></i>
                                                    <?php echo e($admin->email); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                    <a href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>"
                                        class="btn-text"><?php echo e(__('View Profile')); ?></a>
                                </div>
                            </div><!-- agent-default -->
                        </div>

                        <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                                <div class="agent-box radius-md mb-30">
                                    <div class="agent-img">
                                        <figure>
                                            <a href="#" class="lazy-container ratio ratio-1-2">
                                                <img class="lazyload"
                                                    src="<?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>"
                                                    data-src="<?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>">
                                            </a>
                                        </figure>
                                        <div class="agent-ratings d-flex align-items-center justify-content-between">
                                            <div class="ratings">

                                            </div>
                                            <span class="label"><?php echo e(__('Real Estate')); ?></span>
                                        </div>

                                    </div>
                                    <div class="agent-details text-center">
                                        <?php
                                            $vendor_info = App\Models\VendorInfo::where([
                                                ['vendor_id', $vendor->id],
                                                ['language_id', $language->id],
                                            ])
                                                ->select('name')
                                                ->first();

                                        ?>
                                        <span
                                            class="color-primary font-sm"><?php echo e(count($vendor->properties->where('approve_status', 1))); ?>

                                            <?php echo e(__('Properties')); ?></span> |
                                        <span class="color-primary font-sm"><?php echo e(count($vendor->agents)); ?>

                                            <?php echo e(__('Agents')); ?></span> |
                                        <span
                                            class="color-primary font-sm"><?php echo e(count($vendor->projects->where('approve_status', 1))); ?>

                                            <?php echo e(__('Projects')); ?></span>


                                        <h4 class="agent-title"><a
                                                href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"><?php echo e(@$vendor_info->name); ?></a>
                                        </h4>
                                        <ul class="agent-info list-unstyled p-0">

                                            <?php if($vendor->show_phone_number == 1): ?>
                                                <?php if(!is_null($vendor->phone)): ?>
                                                    <li class="icon-start ">
                                                        <a href="tel:<?php echo e($vendor->phone); ?>"> <i
                                                                class="fal fa-phone-plus"></i> <?php echo e($vendor->phone); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($vendor->show_email_addresss == 1): ?>
                                                <li class="icon-start font-sm">
                                                    <a href="mailto:<?php echo e($vendor->email); ?>"> <i class="fal fa-envelope"></i>
                                                        <?php echo e($vendor->email); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                        <a href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"
                                            class="btn-text"><?php echo e(__('View Profile')); ?></a>
                                    </div>
                                </div><!-- agent-default -->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="pagination mb-30 justify-content-center">
                        <?php echo e($vendors->links()); ?>


                    </div>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mt-4">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-3">
                    <aside class="sidebar-widget-area" data-aos="fade-up">
                        <div class="widget widget-form radius-md mb-30">
                            <form action="<?php echo e(route('frontend.vendors')); ?>" method="GET">
                                <h3 class="title mb-20"><?php echo e(__('Find Vendor')); ?></h3>
                                <div class="form-group mb-20">

                                    <input type="text" name="name" value="<?php echo e(request()->input('name')); ?>"
                                        class="form-control " placeholder="<?php echo e(__('Vendor name/username')); ?>">
                                </div>
                                <div class="form-group mb-20">
                                    <select class="nice-select" aria-label="#" id="type" name="type">
                                        <option value="" selected><?php echo e(__('Select Property Type')); ?></option>

                                        <option value="residential"
                                            <?php echo e(request()->input('type') == 'residential' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Residential')); ?> </option>

                                        <option value="commercial"
                                            <?php echo e(request()->input('type') == 'commercial' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Commercial')); ?> </option>


                                    </select>
                                </div>
                                <div class="form-group mb-20">

                                    <input type="text" name="location" class="form-control  "
                                        value="<?php echo e(request()->input('location')); ?>"
                                        placeholder="<?php echo e(__('Enter location')); ?>">
                                </div>
                                <button type="submit" class="btn btn-md btn-primary w-100"><?php echo e(__('Search Now')); ?></button>
                            </form>
                        </div>
                        <?php if(!empty(showAd(2))): ?>
                            <div class="text-center mb-40">
                                <?php echo showAd(2); ?>

                            </div>
                        <?php endif; ?>
                    </aside>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/vendor/index.blade.php ENDPATH**/ ?>