<?php
    $version = $basicInfo->theme_version;
?>

<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(!empty($pageHeading) ? $pageHeading->login_page_title : __('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_login); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_login); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->login_page_title : __('Login'),
        'subtitle' => __('Login'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->login_page_title : __('Login'),
        'subtitle' => __('Login'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Authentication-area start -->
    <div class="authentication-area ptb-100">
        <div class="container">

            <div class="auth-form border radius-md">
                <div class="form-group overflow-hidden mb-3">
                    <div class="row justify-content-between">
                        <?php if($basicInfo->facebook_login_status == 1): ?>
                            <a class="text-center w-50 pt-2 py-2 bg-facebook" href="<?php echo e(route('user.login.facebook')); ?>"><i
                                    class="fas fa-facebook-f"></i>
                                <?php echo e(__('Login with Facebook')); ?></a>
                        <?php endif; ?>
                        <?php if($basicInfo->google_login_status == 1): ?>
                            <a class="text-center w-50 pt-2 py-2 bg-google" href="<?php echo e(route('user.login.google')); ?>"> <i
                                    class="fas fa-google"></i>
                                <?php echo e(__('Login with Google')); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if(Session::has('success')): ?>
                    <div class="alert alert-success"><?php echo e(__(Session::get('success'))); ?></div>
                <?php endif; ?>
                <?php if(Session::has('error')): ?>
                    <div class="alert alert-danger"><?php echo e(__(Session::get('error'))); ?></div>
                <?php endif; ?>
                <form action="<?php echo e(route('user.login_submit')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="title">
                        <h4 class="mb-20"><?php echo e(__('Login')); ?></h4>
                    </div>
                    <div class="form-group mb-30">
                        <input type="text"   class="form-control" name="username"
                            placeholder="<?php echo e(__('Username')); ?>" required>
                        <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger mt-2"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group mb-30">
                        <input type="password"  class="form-control" name="password"
                            placeholder="<?php echo e(__('Password')); ?>" required>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger mt-2"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <?php if($bs->google_recaptcha_status == 1): ?>
                        <div class="form-group mb-30">
                            <?php echo NoCaptcha::renderJs(); ?>

                            <?php echo NoCaptcha::display(); ?>


                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-danger"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <div class="row align-items-center mb-20">
                        <div class="col-4 col-xs-12">
                            <div class="link">
                                <a href="<?php echo e(route('user.forget_password')); ?>"><?php echo e(__('Forgot password') . '?'); ?></a>
                            </div>
                        </div>
                        <div class="col-8 col-xs-12">
                            <div class="link go-signup">
                                <?php echo e(__("don't have an account") . '?'); ?> <a
                                    href="<?php echo e(route('user.signup')); ?>"><?php echo e(__('Click Here')); ?></a>
                                <?php echo e(__('to Signup')); ?>

                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-lg btn-primary radius-md w-100"> <?php echo e(__('Login')); ?> </button>
                </form>
            </div>
        </div>
    </div>
    <!-- Authentication-area end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.layout-v' . $version, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/user/login.blade.php ENDPATH**/ ?>