<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Messages')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('vendor.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>


            <li class="nav-item">
                <a href="#"><?php echo e(__('Messages')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block"><?php echo e(__('All Message')); ?></div>
                        </div>

                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($messages) == 0): ?>
                                <h3 class="text-center mt-2"><?php echo e(__('NO MESSAGE FOUND') . '!'); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(__('Property')); ?></th>
                                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                                <th scope="col"><?php echo e(__('Email ID')); ?></th>

                                                <th scope="col"><?php echo e(__('Phone')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>

                                                    <td class="table-title">
                                                        <?php
                                                            $property_content = $message->property->propertyContent;
                                                            if (is_null($property_content)) {
                                                                $property_content = $property
                                                                    ->propertyContents()
                                                                    ->first();
                                                            }
                                                        ?>
                                                        <?php if(!empty($property_content)): ?>
                                                            <a href="<?php echo e(route('frontend.property.details', ['slug' => $property_content->slug])); ?>"
                                                                target="_blank">
                                                                <?php echo e(strlen(@$property_content->title) > 100 ? mb_substr(@$property_content->title, 0, 1000, 'utf-8') . '...' : @$property_content->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>

                                                    <td><?php echo e($message->name); ?></td>
                                                    <td><a href="mailto:<?php echo e($message->email); ?>"><?php echo e($message->email); ?></a>
                                                    </td>
                                                    <td> <a href="tel:<?php echo e($message->phone); ?>"><?php echo e($message->phone); ?></a>
                                                    </td>

                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item editBtn" href="#"
                                                                    data-toggle="modal" data-target="#editModal"
                                                                    data-id="<?php echo e($message->id); ?>"
                                                                    data-name="<?php echo e($message->name); ?>"
                                                                    data-phone="<?php echo e($message->phone); ?>"
                                                                    data-message="<?php echo e($message->message); ?>"
                                                                    data-email="<?php echo e($message->email); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-eye"></i> <?php echo e(__('View')); ?>

                                                                    </span>
                                                                </a>
                                                                <form class="deleteForm d-inline-block dropdown-item p-0"
                                                                    action="<?php echo e(route('admin.property_message.destroy')); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="message_id"
                                                                        value="<?php echo e($message->id); ?>">

                                                                    <button type="submit" class=" deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash-alt"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>

    

    
    <?php echo $__env->make('backend.property.message-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/property/message.blade.php ENDPATH**/ ?>